<?php include 'sessionheaderrecption.php'; ?>
<?php
// استقبال بيانات النموذج
$patient_key = $_POST['patient_key'] ?? '';
$provider_id = 3640;
$system_type = 1;

$response_body = '';
$response_code = null;
$beneficiary_data = [];

// الاتصال بقاعدة البيانات
function getPDO() {
    $host = 'localhost:3306';
    $db   = 'acesaudi_site';
    $user = 'acesaudi_usr';
    $pass = 'tabfyv-6xiFry-noczak';
    $charset = 'utf8mb4';

    $dsn = "mysql:host=$host;dbname=$db;charset=$charset";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    return new PDO($dsn, $user, $pass, $options);
}

// إعدادات وصيل
define('WASEEL_USERNAME', 'aceclaim');
define('WASEEL_PASSWORD', 'ace3640');
define('TOKEN_FILE', __DIR__ . '/token.json');

// توليد توكن جديد
function getNewToken() {
    $url = 'https://api.eclaims.waseel.com/oauth/authenticate';
    $data = ['username' => WASEEL_USERNAME, 'password' => WASEEL_PASSWORD];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode === 200) {
        $result = json_decode($response, true);
        $tokenData = [
            'access_token' => $result['access_token'],
            'expires_at' => time() + (intval($result['expires_in'] ?? 3600) - 60)
        ];
        file_put_contents(TOKEN_FILE, json_encode($tokenData));
        return $tokenData['access_token'];
    } else {
        return null;
    }
}

function getAccessToken() {
    if (file_exists(TOKEN_FILE)) {
        $tokenData = json_decode(file_get_contents(TOKEN_FILE), true);
        if (time() < ($tokenData['expires_at'] ?? 0)) {
            return $tokenData['access_token'];
        }
    }
    return getNewToken();
}

function getValue($array, $key) {
    return htmlspecialchars($array[$key] ?? '');
}

// تنفيذ الاتصال بالـ API إذا تم إرسال النموذج
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $patient_key) {
    $token = getAccessToken();

    if ($token) {
        $url = "https://api.eclaims.waseel.com/beneficiaries/providers/$provider_id/patientKey/$patient_key/systemType/$system_type";

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: Bearer $token",
            "Accept: application/json"
        ]);

        $response = curl_exec($ch);
        $response_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        $response_body = $response;

        if ($response_code === 200) {
            $beneficiary_data = json_decode($response, true);
        } else {
            $response_body = "فشل في جلب البيانات. رمز الاستجابة: $response_code\n$response";
        }

        // تسجيل في قاعدة البيانات
        try {
            $pdo = getPDO();
            $stmt = $pdo->prepare("INSERT INTO api_logs (
                request_time, provider_id, patient_key, system_type, 
                response_code, response_body, ip_address
            ) VALUES (
                NOW(), :provider_id, :patient_key, :system_type,
                :response_code, :response_body, :ip_address
            )");

            $stmt->execute([
                ':provider_id'   => $provider_id,
                ':patient_key'   => $patient_key,
                ':system_type'   => $system_type,
                ':response_code' => $response_code,
                ':response_body' => substr($response_body, 0, 1000),
                ':ip_address'    => $_SERVER['REMOTE_ADDR']
            ]);
        } catch (Exception $e) {
            $response_body .= "\n\n[Database Error]: " . $e->getMessage();
        }
    } else {
        $response_body = 'فشل في الحصول على التوكن من وصيل';
    }
}
?>

<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Reception ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <style>
    h3 {
      color: #333;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      background-color: white;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
      border-radius: 10px;
      overflow: hidden;
    }

    thead tr {
      background-color: #3c8dbc;
    }

    th, td {
      padding: 10px;
      text-align: left;
      border-bottom: 1px solid #ddd;
    }

    th {
      font-weight: bold;
      color:rgb(0, 0, 0);
      font-size: 14px;
    }

    td {
      vertical-align: middle;
    }

    input[type="text"],
    input[type="date"],
    select {
      width: 100%;
      padding: 6px 8px;
      border: 1px solid #ccc;
      border-radius: 6px;
      box-sizing: border-box;
      font-size: 14px;
      transition: border-color 0.3s;
    }

    input:focus,
    select:focus {
      border-color: #3c8dbc;
      outline: none;
    }

    .required {
      color: red;
    }

    .add-btn {
      cursor: pointer;
      font-size: 24px;
      color: #3c8dbc;
      display: inline-block;
      text-align: center;
    }

    .add-btn:hover {
      color: #3c8dbc;
    }

    .remove-btn {
      cursor: pointer;
      font-size: 18px;
      color: red;
    }

    .remove-btn:hover {
      color: darkred;
    }

    button[type="submit"] {
      margin-top: 20px;
      padding: 10px 20px;
      font-size: 16px;
      background-color: #3c8dbc;
      color: white;
      border: none;
      border-radius: 6px;
      cursor: pointer;
      transition: background-color 0.3s;
    }

    button[type="submit"]:hover {
      background-color: #3c8dbc;
    }

  </style>

  <!-- #region -->
  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->

</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
 <?php include 'receptionheader.php'; ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
         <!-- Sidebar user panel -->
    <?php include 'receptionsidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenureception.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Search & Create New Request Eligibility</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Create New Request Eligibility</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
      
            <div class="box-header">
              <h3 class="box-title"> Please Fllow the All Fileds In Below Form </h3>
            </div>
            <!-- /.box-header -->

          <div class="col-md-12">
          
<?php
// الاتصال بقاعدة البيانات
$conn = new mysqli("localhost", "acesaudi_usr", 'tabfyv-6xiFry-noczak', "acesaudi_site");
if ($conn->connect_error) {
    die("فشل الاتصال بقاعدة البيانات: " . $conn->connect_error);
}

$beneficiaryId = '';
$data = [];

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['beneficiary_id'])) {
    $beneficiaryId = $_POST['beneficiary_id'];

    // استعلام SQL لجلب البيانات من جدولين باستخدام JOIN
    $stmt = $conn->prepare("
        SELECT 
            b.FULLNAME,
            b.DOB,
            b.DOCUMENTID,
            c.MEMBERID,
            c.POLICYHOLDER,
            c.POLICYNUMBER,
            c.EXPIRYDATE
        FROM NPHIES_BENEFICIARY b
        INNER JOIN NPHIES_COVERAGE c ON b.BENEFICIARYID = c.BENEFICIARYID
        WHERE b.BENEFICIARYID = ?
        LIMIT 1
    ");
    $stmt->bind_param("s", $beneficiaryId);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = $result->fetch_assoc();
    $stmt->close();
}

// دالة مساعدة لعرض البيانات بأمان
function getValue2(array $array, string $key): string {
    return isset($array[$key]) ? htmlspecialchars($array[$key]) : '';
}
?>

<!-- نموذج إدخال رقم الهوية -->
<form method="POST" action="" style="text-align: center;">
    <label>رقم الهوية</label><br>
    <input type="text" name="beneficiary_id" value="<?php echo htmlspecialchars($beneficiaryId); ?>" required style="text-align: center;"><br><br>
    <input type="submit" class="btn btn-primary" value="Inquire CCHI الاستعلام برقم الهوية">
</form>

<?php if (!empty($data)): ?>
<hr>
<h3>Personal Information - بيانات المستفيد</h3>
<form method="post" action="submitneweligibilityrequest.php">

    <div class="col-md-3">
        <label>Beneficiary - الاسم الكامل</label><br>
        <input type="text" name="fullName" value="<?= getValue2($data, 'FULLNAME') ?>" readonly><br><br>
    </div>

    <div class="col-md-3">
        <label>Date Of Birthday - تاريخ الميلاد</label><br>
        <input type="text" name="DATEOFBIRTH" value="<?= getValue2($data, 'DOB') ?>" readonly><br><br>
    </div>

    <div class="col-md-3">
        <label>Document ID - رقم الوثيقة</label><br>
        <input type="text" name="beneficiary_id" value="<?= getValue2($data, 'DOCUMENTID') ?>" readonly><br><br>
    </div>

    <div class="col-md-3">
        <label>Insurance Payer Name - شركة التأمين</label><br>
        <input type="text" name="insuranceCompany" value="<?= getValue2($data, 'POLICYHOLDER') ?>" readonly><br><br>
    </div>

    <div class="col-md-3">
        <label>Member ID - رقم العضوية</label><br>
        <input type="text" name="memberId" value="<?= getValue2($data, 'MEMBERID') ?>" readonly><br><br>
    </div>

    <div class="col-md-3">
        <label>POLICY ID - رقم بوليصة التأمين</label><br>
        <input type="text" name="POLICYNUMBER" value="<?= getValue2($data, 'POLICYNUMBER') ?>" readonly><br><br>
    </div>

    <div class="col-md-3">
        <label>Service Date - تاريخ الخدمة</label><br>
        <input type="date" name="expiryDate" value="<?= date('Y-m-d') ?>" readonly><br><br>
    </div>

    <div class="col-md-3">
        <label>Until Date - تاريخ نهاية الخدمة</label><br>
        <input type="date" name="expiryDate" value="<?= getValue2($data, 'EXPIRYDATE') ?>"><br><br>
    </div>

    <div class="col-md-3">
        <label>Status - حالة التأمين</label><br>
        <input type="text" name="status" value="Active" readonly><br><br>
    </div>

    <div class="col-md-12">
        <label>Purpose - الغرض من التقديم</label><br>

        <div class="form-group">
                  <div class="radio">
                    <label>
                      <input type="radio" name="purpose" id="optionsRadios1" value="benefits" checked="">
                      Benefits
                    </label>
                  </div>
                  <div class="radio">
                    <label>
                      <input type="radio" name="purpose" id="optionsRadios2" value="validation">
                      Validation 
                    </label>
                  </div>
                  <div class="radio">
                    <label>
                      <input type="radio" name="purpose" id="optionsRadios2" value="discovery">
                      Discovery
                    </label>
                  </div>
                  
                </div>
    </div>

    <div class="col-md-12">
     <div class="box-footer" style="text-align: center;">
        <button type="submit" class="btn btn-primary">Create New Request Eligibility</button>
    </div>
    </div>
   
</form>
<?php endif; ?>


          </div>
               



        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
