
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
 <?php include 'financeheader.php'; ?>
 
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'financesidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenufinance.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Aggregate account statement Report</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Aggregate account statement Report</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">

<?php
ini_set('display_errors', 0);
error_reporting(E_ALL & ~E_WARNING);
/********* DB *********/
$host     = 'localhost:3306';
$dbname   = 'acesaudi_site';
$username = 'acesaudi_usr';
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username, $password, [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
} catch (PDOException $e) {
    die("فشل الاتصال: " . $e->getMessage());
}

function h($v){ return htmlspecialchars((string)($v ?? ''), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }

/********* Inputs *********/
$date_from   = $_GET['date_from']   ?? '';   // YYYY-MM-DD
$date_to     = $_GET['date_to']     ?? '';   // YYYY-MM-DD
$status      = $_GET['status']      ?? '';   // مدفوع / غير مدفوع / فارغ
$customer_id = trim($_GET['customerid'] ?? ''); // رقم المستفيد
$export_det  = isset($_GET['export']);        // تصدير التفصيلي
$export_grp  = isset($_GET['export_group']);  // تصدير التجميعي

/********* WHERE Builder *********/
$where  = [];
$params = [];

// التاريخ
if ($date_from !== '') { $where[] = "ins.`dateschauled` >= ?"; $params[] = $date_from; }
if ($date_to   !== '') { $where[] = "ins.`dateschauled` <= ?"; $params[] = $date_to; }

// الحالة
if ($status === 'مدفوع') {
    $where[]  = "TRIM(COALESCE(ins.`payment_status`, '')) = 'مدفوع'";
} elseif ($status === 'غير مدفوع') {
    $where[]  = "TRIM(COALESCE(ins.`payment_status`, '')) <> 'مدفوع'";
}

// رقم المستفيد
if ($customer_id !== '') {
    if (ctype_digit($customer_id)) {
        $where[] = "ins.`customerid` = ?";
        $params[] = $customer_id;
    } else {
        $where[] = "ins.`customerid` LIKE ?";
        $params[] = "%{$customer_id}%";
    }
}

$where_sql = $where ? ('WHERE ' . implode(' AND ', $where)) : '';

/********* مشتق photo الأحدث لكل عميل/خدمة *********/
$photoLatest = "
    SELECT p.idcustomer, p.proudctid, p.fullname, p.typeservice
    FROM photo p
    INNER JOIN (
        SELECT idcustomer, proudctid, MAX(photoid) AS maxpid
        FROM photo
        GROUP BY idcustomer, proudctid
    ) last ON last.idcustomer = p.idcustomer
          AND last.proudctid  = p.proudctid
          AND last.maxpid     = p.photoid
";

/********* الاستعلام التفصيلي *********/
$sql_detail = "
    SELECT
        ins.`id`,
        ins.`customerid`,
        ins.`serviceid`,
        ph.`fullname`,
        ph.`typeservice`,
        ins.`installmentamount`,
        ins.`userschauled`,
        ins.`dateschauled`,
        TRIM(COALESCE(ins.`payment_status`, '')) AS payment_status,
        ins.`fileid`
    FROM `installments` ins
    LEFT JOIN ( $photoLatest ) ph
           ON ph.idcustomer = ins.customerid
          AND ph.proudctid  = ins.serviceid
    {$where_sql}
    ORDER BY ins.`dateschauled` DESC, ins.`id` DESC
";
$stmt = $pdo->prepare($sql_detail);
$stmt->execute($params);
$rows = $stmt->fetchAll();

$total_amount = 0.0;
foreach ($rows as $r) $total_amount += (float)$r['installmentamount'];

/********* الاستعلام التجميعي حسب (المستفيد + الخدمة) *********/
$sql_group = "
    SELECT
        ins.`customerid`,
        ins.`serviceid`,
        MAX(ph.`fullname`)    AS fullname,
        MAX(ph.`typeservice`) AS typeservice,
        COUNT(*) AS total_count,
        SUM(ins.`installmentamount`) AS total_amount,
        SUM(CASE WHEN TRIM(COALESCE(ins.`payment_status`, '')) = 'مدفوع'
                 THEN 1 ELSE 0 END) AS paid_count,
        SUM(CASE WHEN TRIM(COALESCE(ins.`payment_status`, '')) = 'مدفوع'
                 THEN ins.`installmentamount` ELSE 0 END) AS paid_amount,
        SUM(CASE WHEN TRIM(COALESCE(ins.`payment_status`, '')) <> 'مدفوع'
                 THEN 1 ELSE 0 END) AS unpaid_count,
        SUM(CASE WHEN TRIM(COALESCE(ins.`payment_status`, '')) <> 'مدفوع'
                 THEN ins.`installmentamount` ELSE 0 END) AS unpaid_amount
    FROM `installments` ins
    LEFT JOIN ( $photoLatest ) ph
           ON ph.idcustomer = ins.customerid
          AND ph.proudctid  = ins.serviceid
    {$where_sql}
    GROUP BY ins.`customerid`, ins.`serviceid`
    ORDER BY total_amount DESC, ins.`customerid` ASC, ins.`serviceid` ASC
";
$stmtg = $pdo->prepare($sql_group);
$stmtg->execute($params);
$groups = $stmtg->fetchAll();

// مجاميع عامة
$G_total = $G_paid = $G_unpaid = 0.0;
foreach ($groups as $g) {
    $G_total  += (float)$g['total_amount'];
    $G_paid   += (float)$g['paid_amount'];
    $G_unpaid += (float)$g['unpaid_amount'];
}

/********* Export: Group *********/
if ($export_grp) {
    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
    header('Content-Disposition: attachment; filename="installments_grouped.xls"');
    echo "<table border='1' style='text-align:center; font-family:Tahoma;width: 100%;text-align: center;' class='table table-hover table-striped'>";
    echo "<tr>
            <th style='text-align: center;'>#</th>
            <th style='text-align: center;'>رقم المستفيد</th>
            <th style='text-align: center;'>اسم المستفيد</th>
            <th style='text-align: center;'>رقم الخدمة</th>
            <th style='text-align: center;'>نوع الخدمة</th>
            <th style='text-align: center;'>عدد الأقساط</th>
            <th style='text-align: center;'>إجمالي الأقساط</th>
            <th style='text-align: center;'>عدد المدفوع</th>
            <th style='text-align: center;'>مجموع المدفوع</th>
            <th style='text-align: center;'>عدد غير مدفوع</th>
            <th style='text-align: center;'>مجموع غير مدفوع</th>
            <th style='text-align: center;'>الرصيد</th>
          </tr>";
    $i=1;
    foreach ($groups as $g) {
        $balance = (float)$g['total_amount'] - (float)$g['paid_amount'];
        echo "<tr>
                <td>".($i++)."</td>
                <td>".h($g['customerid'])."</td>
                <td>".h($g['fullname'])."</td>
                <td>".h($g['serviceid'])."</td>
                <td>".h($g['typeservice'])."</td>
                <td>".h($g['total_count'])."</td>
                <td>".number_format((float)$g['total_amount'], 2)."</td>
                <td>".h($g['paid_count'])."</td>
                <td>".number_format((float)$g['paid_amount'], 2)."</td>
                <td>".h($g['unpaid_count'])."</td>
                <td>".number_format((float)$g['unpaid_amount'], 2)."</td>
                <td>".number_format($balance, 2)."</td>
              </tr>";
    }
    echo "<tr style='font-weight:bold;background:#f3f5fb'>
            <td colspan='6'>إجمالي عام</td>
            <td>".number_format($G_total, 2)."</td>
            <td></td>
            <td>".number_format($G_paid, 2)."</td>
            <td></td>
            <td>".number_format($G_unpaid, 2)."</td>
            <td>".number_format($G_total - $G_paid, 2)."</td>
          </tr>";
    echo "</table>";
    exit;
}

/********* Export: Detail *********/
if ($export_det) {
    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
    header('Content-Disposition: attachment; filename="installments_detail.xls"');
    echo "<table border='1' style='text-align:center; font-family:Tahoma;width: 100%;' class='table table-hover table-striped''>";
    echo "<tr>
            <th style='text-align: center;'>#</th>
            <th style='text-align: center;'>رقم المستفيد</th>
            <th style='text-align: center;'>اسم المستفيد</th>
            <th style='text-align: center;'>رقم الخدمة</th>
            <th style='text-align: center;'>نوع الخدمة</th>
            <th style='text-align: center;'>مبلغ القسط</th>
            <th style='text-align: center;'>المستخدم المجدول</th>
            <th style='text-align: center;'>تاريخ الجدولة</th>
            <th style='text-align: center;'>حالة الدفع</th>
            <th style='text-align: center;'>رقم الملف</th>
          </tr>";
    $i=1;
    foreach ($rows as $r) {
        echo "<tr>
                <td>".($i++)."</td>
                <td>".h($r['customerid'])."</td>
                <td>".h($r['fullname'])."</td>
                <td>".h($r['serviceid'])."</td>
                <td>".h($r['typeservice'])."</td>
                <td>".number_format((float)$r['installmentamount'], 2)."</td>
                <td>".h($r['userschauled'])."</td>
                <td>".h($r['dateschauled'])."</td>
                <td>".h($r['payment_status'])."</td>
                <td>".h($r['fileid'])."</td>
              </tr>";
    }
    echo "<tr style='font-weight:bold;background:#f3f5fb'>
            <td colspan='5'>الإجمالي</td>
            <td>".number_format($total_amount, 2)."</td>
            <td colspan='4'></td>
          </tr>";
    echo "</table>";
    exit;
}
?>

<form method="get" class="form" class="form" style="text-align: center;">
  <div class="form-row">
    <label style="text-align: center;">  من</label> <input type="date" name="date_from" value="<?= h($date_from) ?>" class="form-control">
    <label style="text-align: center;">  إلى</label> <input type="date" name="date_to"   value="<?= h($date_to) ?>" class="form-control">
   
    <label style="text-align: center;">  الحالة</label>
    <select name="status" class="form-control">
        <option value="">الكل</option>
        <option value="مدفوع"     <?= $status==='مدفوع'?'selected':''; ?>>مدفوع</option>
        <option value="غير مدفوع" <?= $status==='غير مدفوع'?'selected':''; ?>>غير مدفوع</option>
    </select>
   
    <label style="text-align: center;">  رقم المستفيد</label>
    <input type="text" name="customerid" value="<?= h($customer_id) ?>" placeholder="مثال: 1179240682" class="form-control"><br>
    <button type="submit" class="btn btn-block btn-primary">تصفية</button>
    <button type="submit" name="export_group" value="1" class="btn btn-block btn-success">تصدير التجميعي</button>
    <button type="submit" name="export" value="1" class="btn btn-block btn-info">تصدير التفصيلي</button>
  </div>
</form>

<h3 style="text-align: center;">كشف حساب تجميعي حسب رقم المستفيد</h3>
<table class="table table-hover table-striped">
  <thead>
    <tr>
      <th style="text-align: center;">#</th>
      <th style="text-align: center;">رقم المستفيد</th>
      <th style="text-align: center;">اسم المستفيد</th>
      <th style="text-align: center;">رقم الخدمة</th>
      <th style="text-align: center;">نوع الخدمة</th>
      <th style="text-align: center;">عدد الأقساط</th>
      <th style="text-align: center;">إجمالي الأقساط</th>
      <th style="text-align: center;">عدد المدفوع</th>
      <th style="text-align: center;">مجموع المدفوع</th>
      <th style="text-align: center;">عدد المبالغ الغير مدفوعة</th>
      <th style="text-align: center;">مجموع المبالغ الغير مدفوعة</th>
      <th style="text-align: center;">الرصيد</th>
    </tr>
  </thead>
  <tbody>
    <?php if(!$groups): ?>
      <tr><td colspan="12" style="text-align: center;">لا توجد بيانات</td></tr>
    <?php else: $i=1; foreach($groups as $g): 
        $balance = (float)$g['total_amount'] - (float)$g['paid_amount'];
    ?>
      <tr>
        <td style="text-align: center;"><?= $i++ ?></td>
        <td style="text-align: center;"><?= h($g['customerid']) ?></td>
        <td style="text-align: center;"><?= h($g['fullname']) ?></td>
        <td style="text-align: center;"><?= h($g['serviceid']) ?></td>
        <td style="text-align: center;"><?= h($g['typeservice']) ?></td>
        <td style="text-align: center;"><?= h($g['total_count']) ?></td>
        <td style="text-align: center;"><?= number_format((float)$g['total_amount'], 2) ?></td>
        <td style="text-align: center;"><?= h($g['paid_count']) ?></td>
        <td style="text-align: center;"><?= number_format((float)$g['paid_amount'], 2) ?></td>
        <td style="text-align: center;"><?= h($g['unpaid_count']) ?></td>
        <td style="text-align: center;"><?= number_format((float)$g['unpaid_amount'], 2) ?></td>
        <td style="text-align: center;"><?= number_format($balance, 2) ?></td>
      </tr>
    <?php endforeach; endif; ?>
  </tbody>
  <tfoot>
    <tr style="font-weight:bold;background:#f3f5fb">
      <td colspan="6" style="text-align: center;">إجمالي عام</td>
      <td style="text-align: center;"><?= number_format($G_total, 2) ?></td>
      <td></td>
      <td style="text-align: center;"><?= number_format($G_paid, 2) ?></td>
      <td></td>
      <td style="text-align: center;"><?= number_format($G_unpaid, 2) ?></td>
      <td style="text-align: center;"><?= number_format($G_total - $G_paid, 2) ?></td>
    </tr>
  </tfoot>
</table>

<h3 style="text-align: center;">كشف حساب تجميعي حسب رقم المستفيد</h3>
<table class="table table-hover table-striped">
  <thead>
    <tr>
      <th style="text-align: center;">#</th>
      <th style="text-align: center;">رقم المستفيد</th>
      <th style="text-align: center;">اسم المستفيد</th>
      <th style="text-align: center;">رقم الخدمة</th>
      <th style="text-align: center;">نوع الخدمة</th>
      <th style="text-align: center;">مبلغ القسط</th>
      <th style="text-align: center;">المستخدم المجدول</th>
      <th style="text-align: center;">تاريخ الجدولة</th>
      <th style="text-align: center;">حالة الدفع</th>
      <th style="text-align: center;">رقم الملف</th>
    </tr>
  </thead>
  <tbody>
  <?php if(!$rows): ?>
    <tr><td colspan="10" style="text-align: center;">لا توجد نتائج.</td></tr>
  <?php else: $i=1; foreach($rows as $r): ?>
    <tr>
      <td style="text-align: center;"><?= $i++ ?></td>
      <td style="text-align: center;"><?= h($r['customerid']) ?></td>
      <td style="text-align: center;"><?= h($r['fullname']) ?></td>
      <td style="text-align: center;"><?= h($r['serviceid']) ?></td>
      <td style="text-align: center;"><?= h($r['typeservice']) ?></td>
      <td style="text-align: center;"><?= number_format((float)$r['installmentamount'], 2) ?></td>
      <td style="text-align: center;"><?= h($r['userschauled']) ?></td>
      <td style="text-align: center;"><?= h($r['dateschauled']) ?></td>
      <td style="text-align: center;"><?= h($r['payment_status']) ?></td>
      <td style="text-align: center;"><?= h($r['fileid']) ?></td>
    </tr>
  <?php endforeach; endif; ?>
  </tbody>
  <tfoot>
    <tr style="font-weight:bold;background:#f3f5fb">
      <td colspan="5" style="text-align: center;">الإجمالي</td>
      <td style="text-align: center;"><?= number_format($total_amount, 2) ?></td>
      <td colspan="4"></td>
    </tr>
  </tfoot>
</table>



            </div>
            <!-- /.box-body -->
          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>

