<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>فلترة المواعيد</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css">
<style>
  body{font-family:Tahoma, Arial; padding:20px}
  .form-group{margin-bottom:15px}
  label{display:block;margin-bottom:6px}
  .input-group{display:flex;align-items:center;gap:8px}
  .input-group-addon{width:36px;text-align:center}
  .btn{padding:8px 14px;border:0;border-radius:6px;background:#6f42c1;color:#fff;cursor:pointer}
  .btn:hover{opacity:.9}
</style>
</head>
<body>

<form action="filterkpis.php" method="post">
  <div class="form-group">
    <label>من تاريخ:</label>
    <div class="input-group">
      <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
      <input type="date" name="from_date" id="from_date" class="form-control" required>
    </div>
  </div>

  <div class="form-group">
    <label>إلى تاريخ:</label>
    <div class="input-group">
      <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
      <input type="date" name="to_date" id="to_date" class="form-control" required>
    </div>
  </div>

  <div class="form-group">
    <label>حالة الموعد:</label>
    <select name="bookingstatus" id="bookingstatus" class="form-control" required>
    <option value="متوفر">متوفر</option>  
    <option value="محجوز">محجوز</option>
      <option value="مكتمل">مكتمل</option>
      <option value="قيد المعالجة">قيد المعالجة</option>
      <option value="ملغي">ملغي</option>
    </select>
  </div>

  <!-- انتبه: عمود الجدول اسمه spesilstid -->
  <input type="hidden" name="spesilstid" value="239">

  <div style="text-align:center">
    <button type="submit" class="btn">بحث وفلترة</button>
  </div>
</form>

<script>
// تعبئة تاريخ اليوم كتلقائي
(function(){
  const today = new Date().toISOString().slice(0,10);
  const from = document.getElementById('from_date');
  const to   = document.getElementById('to_date');
  if(!from.value) from.value = today;
  if(!to.value)   to.value   = today;
})();
</script>
</body>
</html>
