<?php
/******************************************************
 * تقرير مُجمّع مع فلترة بالتاريخ + تصدير Excel (XLS)
 * - الفلترة تؤثر على: الجلسات/مكتمل/محجوز/الساعات/الأرصدة/أنواع ABA/OT/SLP
 * - إجمالي قيمة الخدمة من جدول services (قيمة غير زمنية)
 * - قيمة الجلسة = (إجمالي قيمة الخدمة ÷ إجمالي عدد الجلسات ضمن الفترة)
 ******************************************************/

mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

/* ===== إعداد مدة الجلسة (بالدقائق) ===== */
$SESSION_MINUTES = 60; // غيّرها إلى 45 لو جلساتك 45 دقيقة

/* ===== اتصال PDO ===== */
$dbHost = 'localhost';
$dbName = 'acesaudi_site';
$dbUser = 'acesaudi_usr';
$dbPass = 'tabfyv-6xiFry-noczak';
$dsn = "mysql:host=$dbHost;dbname=$dbName;charset=utf8mb4";
$options = [
  PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
  PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];
try {
  $pdo = new PDO($dsn, $dbUser, $dbPass, $options);
  $pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_general_ci");
} catch (Exception $e) {
  die("فشل الاتصال بقاعدة البيانات: ".h($e->getMessage()));
}

/* ===== أسماء الجداول والأعمدة ===== */
$BOOKINGS_TABLE   = 'bookings';
$B_PID            = 'patient_id';
$B_PNAME          = 'patient_name';
$B_SERVICE_ID     = 'service_id';
$B_TYPE           = 'typeservice';
$B_STATUS         = 'bookingstatus';
$B_DATE           = 'booking_date';

$SERVICES_TABLE        = 'services';
$SERVICES_PK           = 'serviceid';
$SERVICES_TOTAL_AMOUNT = 'cashprice';

$QRCODE_TABLE       = 'qrcode';
$QRCODE_PID_COL     = 'idcustomer';
$QRCODE_SERVICE_COL = 'serviceid';        // بدّلها إلى 'proudctid' لو عندك بهذا الاسم
$QRCODE_AMOUNT_COL  = 'totalamountwvat';

/* ===== استلام ومعالجة تاريخ الفلترة & التصدير ===== */
$dateFrom = isset($_GET['from']) ? trim($_GET['from']) : '';
$dateTo   = isset($_GET['to'])   ? trim($_GET['to'])   : '';
$export   = isset($_GET['export']) ? trim($_GET['export']) : ''; // 'excel' عند الضغط على الزر

$validDate = function($d){
  return ($d !== '' && preg_match('/^\d{4}-\d{2}-\d{2}$/', $d));
};

$hasFrom = $validDate($dateFrom);
$hasTo   = $validDate($dateTo);

/* مقطع WHERE للتاريخ */
$dateWhere = '';
$dateParams = [];
if ($hasFrom && $hasTo) {
  $dateWhere = " AND b.$B_DATE BETWEEN ? AND ? ";
  $dateParams = [$dateFrom, $dateTo];
} elseif ($hasFrom) {
  $dateWhere = " AND b.$B_DATE >= ? ";
  $dateParams = [$dateFrom];
} elseif ($hasTo) {
  $dateWhere = " AND b.$B_DATE <= ? ";
  $dateParams = [$dateTo];
}

/* ===== الأنواع الهدف كأعمدة ثابتة ===== */
$WANTED_TYPES = ['ABA','OT','SLP'];
$types = $WANTED_TYPES;

function canonical_type(?string $raw): ?string {
  if ($raw === null) return null;
  $s = trim($raw);
  if ($s === '') return null;
  $u = mb_strtoupper(preg_replace('/\s+/u',' ', $s), 'UTF-8');
  $plain = preg_replace('/[^\p{L}\p{N}\s]+/u', ' ', $u);
  $plain = preg_replace('/\s+/u', ' ', $plain);

  if (mb_stripos($plain, 'ABA', 0, 'UTF-8') !== false
      || mb_stripos($plain, 'سلوكي', 0, 'UTF-8') !== false
      || mb_stripos($plain, 'تحليل سلوك', 0, 'UTF-8') !== false) return 'ABA';

  if (mb_stripos($plain, 'OT', 0, 'UTF-8') !== false
      || mb_stripos($plain, 'وظيف', 0, 'UTF-8') !== false) return 'OT';

  if (mb_stripos($plain, 'SLP', 0, 'UTF-8') !== false
      || mb_stripos($plain, 'تخاط', 0, 'UTF-8') !== false
      || mb_stripos($plain, 'نطق', 0, 'UTF-8') !== false) return 'SLP';

  return null;
}

/* ===== 0) قائمة المستفيدين ضمن الفترة ===== */
$sqlPatients = "
  SELECT b.$B_PID AS pid, MAX(COALESCE(b.$B_PNAME,'')) AS pname
  FROM $BOOKINGS_TABLE b
  WHERE COALESCE(TRIM(b.$B_PID),'') <> ''
  " . ($dateWhere ? $dateWhere : '') . "
  GROUP BY b.$B_PID
";
$stP = $pdo->prepare($sqlPatients);
$stP->execute($dateParams);

$patients = [];
$patientIds = [];

while ($r = $stP->fetch()) {
  $pid  = (string)$r['pid'];
  $name = (string)$r['pname'];
  $patients[$pid] = [
    'name'                 => $name,
    'by_type'              => array_fill_keys($types, 0),
    'sessions_all'         => 0,
    'completed_all'        => 0,
    'reserved_all'         => 0,
    'fin_total_plans'      => 0.0,
    'fin_paid'             => 0.0,
    'fin_remain'           => 0.0,
    'fin_per_session'      => 0.0,
    'hours_completed'      => 0.0,
    'hours_remaining'      => 0.0,
    'beneficiary_balance'  => 0.0,
    'spent_balance'        => 0.0,
  ];
  $patientIds[] = $pid;
}

/* ===== 1) عدّ الأنواع ضمن الفترة ===== */
if ($patientIds) {
  $in = implode(',', array_fill(0, count($patientIds), '?'));
  $sqlType = "
    SELECT b.$B_PID AS pid, COALESCE(b.$B_TYPE,'') AS tservice, COUNT(*) AS cnt
    FROM $BOOKINGS_TABLE b
    WHERE b.$B_PID IN ($in)
      AND COALESCE(TRIM(b.$B_PID),'') <> ''
      $dateWhere
    GROUP BY b.$B_PID, b.$B_TYPE
  ";
  $params = array_merge($patientIds, $dateParams);
  $stTA = $pdo->prepare($sqlType);
  $stTA->execute($params);
  while ($row = $stTA->fetch()) {
    $pid = (string)$row['pid'];
    $typ = canonical_type((string)$row['tservice']);
    $cnt = (int)$row['cnt'];
    if ($typ !== null && isset($patients[$pid])) {
      $patients[$pid]['by_type'][$typ] += $cnt;
    }
  }
}

/* ===== 2) إجمالي الجلسات/مكتمل/محجوز ضمن الفترة + إجمالي قيمة الخدمة ===== */
$svcMap = []; // [pid] => ...
if ($patientIds) {
  $in = implode(',', array_fill(0, count($patientIds), '?'));
  $sqlAll = "
    SELECT
      b.$B_PID        AS pid,
      b.$B_SERVICE_ID AS sid,
      MAX(s.$SERVICES_TOTAL_AMOUNT) AS cashprice,
      COUNT(*) AS total_sessions,
      SUM(CASE WHEN b.$B_STATUS='مكتمل' THEN 1 ELSE 0 END) AS completed_sessions,
      SUM(CASE WHEN b.$B_STATUS='محجوز' THEN 1 ELSE 0 END) AS reserved_sessions
    FROM $BOOKINGS_TABLE b
    LEFT JOIN $SERVICES_TABLE s
      ON s.$SERVICES_PK = b.$B_SERVICE_ID
    WHERE b.$B_PID IN ($in)
      AND COALESCE(TRIM(b.$B_PID),'') <> ''
      $dateWhere
    GROUP BY b.$B_PID, b.$B_SERVICE_ID
  ";
  $params = array_merge($patientIds, $dateParams);
  $stAll = $pdo->prepare($sqlAll);
  $stAll->execute($params);

  while ($row = $stAll->fetch()) {
    $pid   = (string)$row['pid'];
    $sid   = (string)$row['sid'];
    $cash  = (float)($row['cashprice'] ?? 0);
    $sess  = (int)  ($row['total_sessions'] ?? 0);
    $done  = (int)  ($row['completed_sessions'] ?? 0);
    $res   = (int)  ($row['reserved_sessions'] ?? 0);

    if (!isset($svcMap[$pid])) {
      $svcMap[$pid] = ['plans_sum'=>0.0, 'sessions_sum'=>0, 'completed_sum'=>0, 'reserved_sum'=>0, 'services'=>[]];
    }
    $svcMap[$pid]['services'][$sid] = 0.0; // سنملؤها لاحقًا من qrcode
    $svcMap[$pid]['plans_sum']     += $cash;
    $svcMap[$pid]['sessions_sum']  += $sess;
    $svcMap[$pid]['completed_sum'] += $done;
    $svcMap[$pid]['reserved_sum']  += $res;
  }

  /* ===== 3) مدفوعات qrcode (بدون فلترة تاريخ) ===== */
  $sqlPay = "
    SELECT q.$QRCODE_PID_COL AS pid, q.$QRCODE_SERVICE_COL AS sid, SUM(q.$QRCODE_AMOUNT_COL) AS paid_sum
    FROM $QRCODE_TABLE q
    WHERE q.$QRCODE_PID_COL IN ($in)
      AND COALESCE(TRIM(q.$QRCODE_PID_COL),'') <> ''
    GROUP BY q.$QRCODE_PID_COL, q.$QRCODE_SERVICE_COL
  ";
  $stPay = $pdo->prepare($sqlPay);
  $stPay->execute($patientIds);
  while ($row = $stPay->fetch()) {
    $pid  = (string)$row['pid'];
    $sid  = (string)$row['sid'];
    $paid = (float)($row['paid_sum'] ?? 0);
    if (isset($svcMap[$pid]['services'][$sid])) {
      $svcMap[$pid]['services'][$sid] += $paid;
    }
  }

  /* ===== 4) تعبئة المخرجات لكل مستفيد ===== */
  foreach ($patients as $pid => &$info) {
    $plans_sum     = isset($svcMap[$pid]) ? (float)$svcMap[$pid]['plans_sum']    : 0.0;
    $sessions_sum  = isset($svcMap[$pid]) ? (int)$svcMap[$pid]['sessions_sum']   : 0;
    $completed_sum = isset($svcMap[$pid]) ? (int)$svcMap[$pid]['completed_sum']  : 0;
    $reserved_sum  = isset($svcMap[$pid]) ? (int)$svcMap[$pid]['reserved_sum']   : 0;

    $paid_sum = 0.0;
    if (isset($svcMap[$pid])) {
      foreach ($svcMap[$pid]['services'] as $sid => $paidForSid) {
        $paid_sum += (float)$paidForSid;
      }
    }

    $remain       = max(0.0, $plans_sum - $paid_sum);
    $per_session  = ($sessions_sum > 0) ? ($plans_sum / $sessions_sum) : 0.0;

    $hours_completed = ($completed_sum * $SESSION_MINUTES) / 60.0;
    $hours_remaining = ($reserved_sum  * $SESSION_MINUTES) / 60.0;

    $beneficiary_balance = $reserved_sum  * $per_session;
    $spent_balance       = $completed_sum * $per_session;

    $info['sessions_all']         = $sessions_sum;
    $info['completed_all']        = $completed_sum;
    $info['reserved_all']         = $reserved_sum;
    $info['fin_total_plans']      = $plans_sum;
    $info['fin_paid']             = $paid_sum;
    $info['fin_remain']           = $remain;
    $info['fin_per_session']      = $per_session;
    $info['hours_completed']      = $hours_completed;
    $info['hours_remaining']      = $hours_remaining;
    $info['beneficiary_balance']  = $beneficiary_balance;
    $info['spent_balance']        = $spent_balance;
  }
  unset($info);
}

/* ===== مجاميع عامة ===== */
$grand = [
  'patients'               => count($patients),
  'total_types_all'        => 0,
  'sessions_all'           => 0,
  'completed_all'          => 0,
  'reserved_all'           => 0,
  'fin_total_plans'        => 0.0,
  'fin_paid'               => 0.0,
  'fin_remain'             => 0.0,
  'fin_per_session'        => 0.0,
  'hours_completed_sum'    => 0.0,
  'hours_remaining_sum'    => 0.0,
  'beneficiary_balance_sum'=> 0.0,
  'spent_balance_sum'      => 0.0,
];
foreach ($patients as $p) {
  $grand['total_types_all']         += (int)$p['by_type']['ABA'] + (int)$p['by_type']['OT'] + (int)$p['by_type']['SLP'];
  $grand['sessions_all']            += (int)$p['sessions_all'];
  $grand['completed_all']           += (int)$p['completed_all'];
  $grand['reserved_all']            += (int)$p['reserved_all'];
  $grand['fin_total_plans']         += (float)$p['fin_total_plans'];
  $grand['fin_paid']                += (float)$p['fin_paid'];
  $grand['fin_remain']              += (float)$p['fin_remain'];
  $grand['hours_completed_sum']     += (float)$p['hours_completed'];
  $grand['hours_remaining_sum']     += (float)$p['hours_remaining'];
  $grand['beneficiary_balance_sum'] += (float)$p['beneficiary_balance'];
  $grand['spent_balance_sum']       += (float)$p['spent_balance'];
}
$grand['fin_per_session'] = ($grand['sessions_all']>0) ? ($grand['fin_total_plans'] / $grand['sessions_all']) : 0.0;

/* ===== فرع التصدير إلى Excel (XLS) ===== */
if ($export === 'excel') {
  // لا تطبع أي شيء قبل هذه الترويسات
  header('Content-Type: application/vnd.ms-excel; charset=utf-8');
  header('Content-Disposition: attachment; filename="general_revenue_'.date('Y-m-d_His').'.xls"');
  // BOM لسلامة العربية في إكسل
  echo "\xEF\xBB\xBF";
  echo "<meta charset='utf-8'>";

  echo "<table border='1' style='text-align:center;font-family:Tahoma;border-collapse:collapse'>";

  // عنوان + نطاق زمني
  echo "<tr><th colspan='".(13 + count($types) + 1)."' style='font-size:14px'>تقرير مُجمّع الإيراد المالي</th></tr>";
  echo "<tr><td colspan='".(13 + count($types) + 1)."'>النطاق الزمني: ".($hasFrom?h($dateFrom):'—')." إلى ".($hasTo?h($dateTo):'—')."</td></tr>";
  echo "<tr><td colspan='".(13 + count($types) + 1)."'>&nbsp;</td></tr>";

  // رأس الجدول
  echo "<tr style='background:#e9f2ff'>";
  echo "<th>#</th>";
  echo "<th>رقم المستفيد</th>";
  echo "<th>اسم المستفيد</th>";
  echo "<th>إجمالي الجلسات</th>";
  echo "<th>إجمالي قيمة الخدمة</th>";
  echo "<th>المدفوع من المبلغ</th>";
  echo "<th>المتبقي (الخدمة - المدفوع)</th>";
  echo "<th>قيمة الجلسة</th>";
  echo "<th>ساعات مكتملة</th>";
  echo "<th>ساعات متبقية</th>";
  echo "<th>الرصيد المتبقي</th>";
  echo "<th>الرصيد المصروف</th>";
  foreach ($types as $t) echo "<th>عدد جلسات ".h($t)."</th>";
  echo "<th>إجمالي (ABA+OT+SLP)</th>";
  echo "</tr>";

  if (!$patients) {
    echo "<tr><td colspan='".(13 + count($types) + 1)."'>لا توجد بيانات ضمن الفترة</td></tr>";
  } else {
    $i=0;
    foreach ($patients as $pid => $info) {
      $i++;
      $sum3 = (int)$info['by_type']['ABA'] + (int)$info['by_type']['OT'] + (int)$info['by_type']['SLP'];
      echo "<tr>";
      echo "<td>".$i."</td>";
      echo "<td>".h($pid)."</td>";
      echo "<td>".h($info['name'])."</td>";
      echo "<td>".number_format((int)$info['sessions_all'])."</td>";
      echo "<td>".number_format((float)$info['fin_total_plans'], 2)."</td>";
      echo "<td>".number_format((float)$info['fin_paid'], 2)."</td>";
      echo "<td>".number_format((float)$info['fin_remain'], 2)."</td>";
      echo "<td>".number_format((float)$info['fin_per_session'], 2)."</td>";
      echo "<td>".number_format((float)$info['hours_completed'], 2)."</td>";
      echo "<td>".number_format((float)$info['hours_remaining'], 2)."</td>";
      echo "<td>".number_format((float)$info['beneficiary_balance'], 2)."</td>";
      echo "<td>".number_format((float)$info['spent_balance'], 2)."</td>";
      foreach ($types as $t) {
        echo "<td>".number_format((int)($info['by_type'][$t] ?? 0))."</td>";
      }
      echo "<td>".number_format($sum3)."</td>";
      echo "</tr>";
    }

    // تذييل الإجماليات
    echo "<tr style='background:#f7f7f7;font-weight:bold'>";
    echo "<td colspan='3' style='text-align:right'>الإجماليات:</td>";
    echo "<td>".number_format($grand['sessions_all'])."</td>";
    echo "<td>".number_format($grand['fin_total_plans'], 2)."</td>";
    echo "<td>".number_format($grand['fin_paid'], 2)."</td>";
    echo "<td>".number_format($grand['fin_remain'], 2)."</td>";
    echo "<td>".number_format($grand['fin_per_session'], 2)."</td>";
    echo "<td>".number_format($grand['hours_completed_sum'], 2)."</td>";
    echo "<td>".number_format($grand['hours_remaining_sum'], 2)."</td>";
    echo "<td>".number_format($grand['beneficiary_balance_sum'], 2)."</td>";
    echo "<td>".number_format($grand['spent_balance_sum'], 2)."</td>";
    // يمكن لاحقًا جمع كل نوع على مستوى الجميع
    foreach ($types as $t) echo "<td></td>";
    echo "<td>".number_format($grand['total_types_all'])."</td>";
    echo "</tr>";
  }

  echo "</table>";
  exit; // مهم: لا تكمل HTML الصفحة
}

/* ===== عرض HTML العادي ===== */
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>تقرير الإيراد العام </title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
  <style>
    body{background:#f8f9fa}
    .table thead th{white-space:nowrap}
    .amount,.count{font-weight:600}
    .sticky-head thead th{position:sticky; top:0; background:#fff; z-index:2}
    .minw{min-width:120px}
    .muted{color:#6c757d}
    .filter-card .form-control{min-width:200px}
  </style>
</head>
<body>
<div class="container py-4" style="max-width: 1880px;">

  <!-- فورم الفلترة -->
  <div class="card shadow-sm mb-3 filter-card">
    <div class="card-body">
      <form class="row g-2 align-items-end" method="get">
        <div class="col-auto">
          <label class="form-label">من تاريخ</label>
          <input type="date" name="from" class="form-control" value="<?= h($hasFrom ? $dateFrom : '') ?>">
        </div>
        <div class="col-auto">
          <label class="form-label">إلى تاريخ</label>
          <input type="date" name="to" class="form-control" value="<?= h($hasTo ? $dateTo : '') ?>">
        </div>
        <div class="col-auto d-flex gap-2">
          <button class="btn btn-primary">تطبيق الفلترة بالتاريخ</button>
          <?php
            $self = strtok($_SERVER['REQUEST_URI'],'?');
            $qs = http_build_query(array_filter(['from'=>$dateFrom, 'to'=>$dateTo, 'export'=>'excel']));
          ?>
          <!-- ✅ زر تصدير Excel بنفس الفلاتر الحالية -->
          <a class="btn btn-success" href="<?= h($self.($qs?('?'.$qs):'?export=excel')) ?>">
            تصدير Excel
          </a>
        </div>
        <div class="col-auto">
          <a class="btn btn-outline-secondary" href="<?= h(strtok($_SERVER['REQUEST_URI'],'?')) ?>">إزالة الفلترة</a>
        </div>
        <div class="col-12 mt-2 text-muted">
          <?php if ($hasFrom || $hasTo): ?>
            النطاق الزمني:
            <strong>
              <?= $hasFrom ? h($dateFrom) : '—' ?> &nbsp; إلى &nbsp; <?= $hasTo ? h($dateTo) : '—' ?>
            </strong>
          <?php else: ?>
            لا توجد فلترة زمنية — يتم عرض جميع الحجوزات
          <?php endif; ?>
        </div>
      </form>
    </div>
  </div>

  <div class="d-flex align-items-center justify-content-between mb-3">
    <h4 class="m-0">تقرير مُجمّع الإيراد المالي </h4>
  </div>

  <div class="card shadow-sm">
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle sticky-head">
          <thead class="table-light">
            <tr>
              <th>#</th>
              <th class="minw">رقم المستفيد</th>
              <th class="minw">اسم المستفيد</th>

              <th class="minw">إجمالي الجلسات</th>
              <th class="minw">إجمالي قيمة الخدمة</th>
              <th class="minw">المدفوع من المبلغ</th>
              <th class="minw">المتبقي (الخدمة - المدفوع)</th>
              <th class="minw">قيمة الجلسة</th>

              <th class="minw">ساعات مكتملة</th>
              <th class="minw">ساعات متبقية</th>

              <th class="minw">الرصيد المتبقي</th>
              <th class="minw">الرصيد المصروف</th>

              <?php foreach ($types as $t): ?>
                <th class="minw">عدد جلسات <?= h($t) ?></th>
              <?php endforeach; ?>
              <th class="minw">إجمالي (ABA+OT+SLP)</th>
            </tr>
          </thead>
          <tbody>
          <?php if (!$patients): ?>
            <tr><td colspan="<?= 13 + count($types) + 1 ?>" class="text-center text-muted">لا توجد بيانات ضمن الفترة</td></tr>
          <?php else:
            $i=0;
            foreach ($patients as $pid => $info):
              $i++;
              $sum3 = (int)$info['by_type']['ABA'] + (int)$info['by_type']['OT'] + (int)$info['by_type']['SLP'];
          ?>
            <tr>
              <td><?= $i ?></td>
              <td><?= h($pid) ?></td>
              <td><?= h($info['name']) ?></td>

              <td class="count"><?= number_format((int)$info['sessions_all']) ?></td>
              <td class="amount"><?= number_format((float)$info['fin_total_plans'], 2) ?> ريال</td>
              <td class="amount"><?= number_format((float)$info['fin_paid'], 2) ?> ريال</td>
              <td class="amount"><?= number_format((float)$info['fin_remain'], 2) ?> ريال</td>
              <td class="amount"><?= number_format((float)$info['fin_per_session'], 2) ?> ريال</td>

              <td class="count"><?= number_format((float)$info['hours_completed'], 2) ?></td>
              <td class="count"><?= number_format((float)$info['hours_remaining'], 2) ?></td>

              <td class="amount"><?= number_format((float)$info['beneficiary_balance'], 2) ?> ريال</td>
              <td class="amount"><?= number_format((float)$info['spent_balance'], 2) ?> ريال</td>

              <?php foreach ($types as $t): ?>
                <td class="count"><?= number_format((int)($info['by_type'][$t] ?? 0)) ?></td>
              <?php endforeach; ?>
              <td class="count"><?= number_format($sum3) ?></td>
            </tr>
          <?php endforeach; endif; ?>
          </tbody>

          <?php if ($patients): ?>
          <tfoot>
            <tr class="table-light">
              <th colspan="3" class="text-end">الإجماليات:</th>
              <th class="count"><?= number_format($grand['sessions_all']) ?></th>
              <th class="amount"><?= number_format($grand['fin_total_plans'], 2) ?> ريال</th>
              <th class="amount"><?= number_format($grand['fin_paid'], 2) ?> ريال</th>
              <th class="amount"><?= number_format($grand['fin_remain'], 2) ?> ريال</th>
              <th class="amount"><?= number_format($grand['fin_per_session'], 2) ?> ريال</th>
              <th class="count"><?= number_format($grand['hours_completed_sum'], 2) ?></th>
              <th class="count"><?= number_format($grand['hours_remaining_sum'], 2) ?></th>
              <th class="amount"><?= number_format($grand['beneficiary_balance_sum'], 2) ?> ريال</th>
              <th class="amount"><?= number_format($grand['spent_balance_sum'], 2) ?> ريال</th>
              <?php foreach ($types as $t): ?>
                <th><!-- مجموع النوع يمكن إضافته لاحقًا --></th>
              <?php endforeach; ?>
              <th class="count"><?= number_format($grand['total_types_all']) ?></th>
            </tr>
          </tfoot>
          <?php endif; ?>
        </table>
      </div>
    </div>
  </div>

</div>
</body>
</html>
