<?php
/** api/search_services.php */
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// اتصال DB
$have_conn = false;
if (file_exists(__DIR__ . '/../conn.php')) {
  include __DIR__ . '/../conn.php';
  if (isset($conn) && $conn instanceof mysqli) $have_conn = true;
}
if (!$have_conn) {
  $conn = new mysqli('localhost','DB_USER','DB_PASS','acesaudi_site2');
  if ($conn->connect_error) { http_response_code(500); echo json_encode(['error'=>'DB failed']); exit; }
}
$conn->set_charset('utf8mb4');

// مدخلات
$q   = trim($_GET['q'] ?? '');
$cid = trim($_GET['insurancecompanyid'] ?? '');
$limit = (int)($_GET['limit'] ?? 15);
$limit = max(1, min(50, $limit));

$where=[]; $params=[]; $types='';
if ($q !== '') {
  $like = '%'.$q.'%';
  $where[] = "(SERVICE_CODE LIKE ? OR NON_STANDARD_CODE LIKE ? OR service_name_ar LIKE ? OR service_name_en LIKE ?)";
  array_push($params, $like, $like, $like, $like);
  $types .= 'ssss';
}
if ($cid !== '') {
  $where[] = "insurancecompanyid = ?";
  $params[] = $cid;
  $types   .= 's';
}

$sql = "SELECT
  service_id, insurancecompanyid, insurancecompanyname,
  SERVICE_TYPE, SERVICE_CODE, NON_STANDARD_CODE, NON_STANDARD_DESC,
  service_name_ar, service_name_en, UNIT_PRICE, specialty, FACTOR
  FROM insuranceservices";

if ($where) $sql .= " WHERE " . implode(" AND ", $where);
$sql .= " ORDER BY service_id DESC LIMIT ?";
$params[] = $limit; $types .= 'i';

$st = $conn->prepare($sql);
$st->bind_param($types, ...$params);
$st->execute();
$res = $st->get_result();
$out = [];
while ($r = $res->fetch_assoc()) { $out[] = $r; }
$st->close();

echo json_encode(['results'=>$out], JSON_UNESCAPED_UNICODE);
