<?php
/******************************************************
 * تقرير مواعيد مستفيد حسب الخدمة + 3 أعمدة مالية + تصدير Excel
 * - services: serviceid, cashprice, totalsessions
 * - المبلغ المقدم = (cashprice / totalsessions) * #مكتمل (إجمالي)
 * - المبلغ المتبقي = cashprice - المبلغ المقدم
 ******************************************************/

mb_internal_encoding('UTF-8');

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }

/* ===== قائمة الخدمات (للعرض فقط) ===== */
$SERVICE_OPTIONS = [
    '1' => 'التأهيل المهني المكثف',
    '2' => 'برنامج تدريب الوالدين عن بعد',
    '3' => 'خدمة تقييم التخصص الواحد - علاج سلوكي',
    '4' => 'التقييم المتعدد التخصصات',
    '5' => 'خدمة باقة جلسات علاجية في التخصص الواحد',
    '6' => 'البرنامج السلوكي المكثف',
    '7' => 'خدمة البرنامج التأهيلي المكثف',
    '8' => 'خدمة إستشرنا',
    '9' => 'برنامج علاج الانتقائية في الطعام',
    '10' => 'أنا أدرب طفلي',
    '11' => 'الرعاية المنزلية',
    '12' => 'خدمة الظل',
    '13' => 'خدمة جلسة استشارية مع طبيب استشاري',
    '14' => 'خدمة التشخيص',
    '15' => 'خدمة اختبار الذكاء',
    '16' => 'برنامج التميز التأهيلي',
    '17' => 'برنامج التهيئة الأكاديمية',
    '18' => 'برنامج التميز التأهيلي',
    '19' => 'برنامج التأهيل المهني غير المكثف',
    '20' => 'التميز التأهيلي',
    '21' => 'التهيئة الأكاديمية',
];

/* ===== إعداد اتصال PDO ===== */
$dbHost = 'localhost';     // أو localhost:3306
$dbName = 'acesaudi_site';
$dbUser = 'acesaudi_usr';
$dbPass = 'tabfyv-6xiFry-noczak';

$dsn = "mysql:host={$dbHost};dbname={$dbName};charset=utf8mb4";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $dbUser, $dbPass, $options);
    $pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_general_ci");
} catch (Exception $e) {
    die("فشل الاتصال بقاعدة البيانات: " . h($e->getMessage()));
}

/* ===== إعدادات جدول الخدمات ===== */
$SERVICES_TABLE        = 'services';
$SERVICES_PK           = 'serviceid';
$SERVICES_TOTAL_AMOUNT = 'cashprice';
$SERVICES_TOTAL_SESS   = 'totalsessions';

/* ===== قراءة المدخلات ===== */
$patientId = isset($_POST['patient_id']) ? trim($_POST['patient_id']) : '';
$serviceId = isset($_POST['service_id']) ? trim($_POST['service_id']) : '';
$fromDate  = isset($_POST['from_date'])  ? trim($_POST['from_date'])  : '';
$toDate    = isset($_POST['to_date'])    ? trim($_POST['to_date'])    : '';
$export    = isset($_POST['export']) ? $_POST['export'] : ''; // 'excel' عند الضغط على زر التصدير

// تصحيح المدى الزمني
if ($fromDate !== '' && $toDate !== '' && $fromDate > $toDate) {
    $tmp = $fromDate; $fromDate = $toDate; $toDate = $tmp;
}

$didSubmit = ($_SERVER['REQUEST_METHOD'] === 'POST');
$errorMsg = '';
$rows = [];
$stats = ['total'=>0, 'مكتمل'=>0, 'محجوز'=>0, 'ملغي'=>0];

// قيم الخدمة
$service_total_amount   = 0.0;
$service_total_sessions = 0;
$per_session_value      = 0.0;

// تقدم المستفيد
$completed_all      = 0;
$amount_provided    = 0.0;
$remaining_sessions = 0;
$amount_remaining   = 0.0;

/* ===== جلب البيانات عند الطلب/التصدير ===== */
if ($didSubmit) {
    if ($patientId === '' || $serviceId === '') {
        $errorMsg = "رجاءً أدخل رقم هوية المستفيد واختر رقم الخدمة.";
    } elseif (!array_key_exists($serviceId, $SERVICE_OPTIONS)) {
        // يمكن حذف هذا التحقق لو القائمة ليست مرجعية لكل الخدمات الفعلية
        $errorMsg = "رقم الخدمة غير موجود في القائمة الثابتة.";
    } else {
        try {
            // WHERE ديناميكي
            $where = "patient_id = :pid AND service_id = :sid";
            $params = [':pid'=>$patientId, ':sid'=>$serviceId];

            if ($fromDate !== '') {
                $where .= " AND booking_date >= :fromDate";
                $params[':fromDate'] = $fromDate;
            }
            if ($toDate !== '') {
                $where .= " AND booking_date <= :toDate";
                $params[':toDate'] = $toDate;
            }

            // تفاصيل الحجوزات ضمن النطاق
            $sqlDetails = "
                SELECT 
                    id, booking_date, dayname, time_slot, end_time, period,
                    bookingstatus, room_id, spclistsname, service_id, typeservice,
                    patient_name, notes
                FROM bookings
                WHERE $where
                ORDER BY booking_date DESC, time_slot DESC
            ";
            $stmt = $pdo->prepare($sqlDetails);
            $stmt->execute($params);
            $rows = $stmt->fetchAll();

            // إجمالي السجلات ضمن النطاق
            $sqlTotal = "SELECT COUNT(*) FROM bookings WHERE $where";
            $stmtT = $pdo->prepare($sqlTotal);
            $stmtT->execute($params);
            $stats['total'] = (int)$stmtT->fetchColumn();

            // تجميع حسب الحالة ضمن النطاق
            $sqlByStatus = "
                SELECT bookingstatus, COUNT(*) AS c
                FROM bookings
                WHERE $where
                GROUP BY bookingstatus
            ";
            $stmtS = $pdo->prepare($sqlByStatus);
            $stmtS->execute($params);
            foreach ($stmtS as $r) {
                $st = (string)($r['bookingstatus'] ?? '');
                $stats[$st] = (int)($r['c'] ?? 0);
            }

            // بيانات الخدمة
            $sqlService = "
                SELECT {$SERVICES_TOTAL_AMOUNT} AS total_amount,
                       {$SERVICES_TOTAL_SESS}   AS total_sessions
                FROM {$SERVICES_TABLE}
                WHERE {$SERVICES_PK} = :sid
                LIMIT 1
            ";
            $stmtSrv = $pdo->prepare($sqlService);
            $stmtSrv->execute([':sid' => $serviceId]);
            if ($srv = $stmtSrv->fetch()) {
                $service_total_amount   = (float)($srv['total_amount']   ?? 0);
                $service_total_sessions = (int)  ($srv['total_sessions'] ?? 0);
            }

            // عدد الجلسات المكتملة إجمالاً (بدون نطاق التاريخ)
            $sqlCompletedAll = "
                SELECT COUNT(*) 
                FROM bookings
                WHERE patient_id = :pid AND service_id = :sid AND bookingstatus = 'مكتمل'
            ";
            $stmtCA = $pdo->prepare($sqlCompletedAll);
            $stmtCA->execute([':pid'=>$patientId, ':sid'=>$serviceId]);
            $completed_all = (int)$stmtCA->fetchColumn();

            // الحسابات المالية
            if ($service_total_sessions > 0) {
                $per_session_value  = $service_total_amount / $service_total_sessions;
                $amount_provided    = $per_session_value * $completed_all;
                $remaining_sessions = max(0, $service_total_sessions - $completed_all);
                $amount_remaining   = max(0, $service_total_amount - $amount_provided);
            } else {
                $per_session_value  = 0.0;
                $amount_provided    = 0.0;
                $remaining_sessions = 0;
                $amount_remaining   = $service_total_amount;
            }

        } catch (Exception $e) {
            $errorMsg = "حدث خطأ أثناء جلب البيانات: " . h($e->getMessage());
        }
    }
}

/* ===== فرع التصدير إلى Excel (XLS) قبل أي HTML ===== */
if ($didSubmit && !$errorMsg && $export === 'excel') {
    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
    header('Content-Disposition: attachment; filename="appointments_'.date('Y-m-d_His').'.xls"');

    echo "<meta charset='utf-8'>";
    echo "<table border='1' style='text-align:center;font-family:Tahoma;border-collapse:collapse'>";

    // معلومات عامة أعلى الملف
    echo "<tr><th colspan='16' style='font-size:14px'>تقرير المواعيد — المستفيد: ".h($patientId)." — الخدمة: ".h($serviceId.' — '.($SERVICE_OPTIONS[$serviceId] ?? ''))."</th></tr>";
    if ($fromDate || $toDate) {
        echo "<tr><td colspan='16'>النطاق الزمني: ".($fromDate?:'—')." إلى ".($toDate?:'—')."</td></tr>";
    }
    echo "<tr><td colspan='16'>&nbsp;</td></tr>";

    // ملخص مالي
    echo "<tr style='background:#f7f7f7'>
            <th>القيمة الإجمالية للخدمة</th>
            <th>المبلغ المقدم</th>
            <th>المبلغ المتبقي</th>
            <th>قيمة الجلسة</th>
            <th>إجمالي مكتمل</th>
            <th>المتبقي من الجلسات</th>
            <th colspan='10'></th>
          </tr>";
    echo "<tr>
            <td>".number_format($service_total_amount,2)."</td>
            <td>".number_format($amount_provided,2)."</td>
            <td>".number_format($amount_remaining,2)."</td>
            <td>".number_format($per_session_value,2)."</td>
            <td>".(int)$completed_all."</td>
            <td>".(int)$remaining_sessions."</td>
            <td colspan='10'></td>
          </tr>";

    echo "<tr><td colspan='16'>&nbsp;</td></tr>";

    // رأس الجدول التفصيلي
    echo "<tr style='background:#e9f2ff'>
            <th>#</th>
            <th>اسم المستفيد</th>
            <th>التاريخ</th>
            <th>اليوم</th>
            <th>الوقت</th>
            <th>نهاية</th>
            <th>الفترة</th>
            <th>الحالة</th>
            <th>الغرفة</th>
            <th>الأخصائي</th>
            <th>رقم الخدمة</th>
            <th>نوع الخدمة</th>
            <th>ملاحظات</th>
            <th>القيمة الإجمالية للخدمة</th>
            <th>المبلغ المقدم</th>
            <th>المبلغ المتبقي</th>
          </tr>";

    if (!$rows) {
        echo "<tr><td colspan='16'>لا توجد مواعيد مطابقة</td></tr>";
    } else {
        foreach ($rows as $i=>$r) {
            echo "<tr>";
            echo "<td>".($i+1)."</td>";
            echo "<td>".h($r['patient_name'])."</td>";
            echo "<td>".h($r['booking_date'])."</td>";
            echo "<td>".h($r['dayname'])."</td>";
            echo "<td>".h($r['time_slot'])."</td>";
            echo "<td>".h($r['end_time'])."</td>";
            echo "<td>".h($r['period'])."</td>";
            echo "<td>".h($r['bookingstatus'])."</td>";
            echo "<td>".h($r['room_id'])."</td>";
            echo "<td>".h($r['spclistsname'])."</td>";
            echo "<td>".h($r['service_id'])."</td>";
            echo "<td>".h($r['typeservice'])."</td>";
            echo "<td>".h($r['notes'])."</td>";
            echo "<td>".number_format($service_total_amount, 2)."</td>";
            echo "<td>".number_format($amount_provided, 2)."</td>";
            echo "<td>".number_format($amount_remaining, 2)."</td>";
            echo "</tr>";
        }
    }

    echo "</table>";
    exit;
}

/* ===== بقية الصفحة (HTML) ===== */
$completed_in_range = (int)($stats['مكتمل'] ?? 0);
$remaining_in_range = max(0, (int)$stats['total'] - $completed_in_range);
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>فلترة مواعيد المستفيد حسب التاريخ</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">
<style>
 body{font-family:"Tajawal",system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial}
 .card{border-radius:1rem}
 .table thead th{white-space:nowrap}
 .badge{font-size:.95rem}
 .small-muted{font-size:.875rem;color:#6c757d}
 .amount{font-weight:600}
</style>
</head>
<body class="bg-light">
<div class="container py-4">

    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <h1 class="h4 mb-3"> فلترة تقرير مواعيد المستفيد حسب الخدمة</h1>
            <form method="post" class="row gy-3">
                <div class="col-md-3">
                    <label class="form-label">رقم هوية المستفيد</label>
                    <input type="text" name="patient_id" class="form-control" required
                           value="<?= h($patientId) ?>" placeholder="مثال: 1234567890">
                </div>
                <div class="col-md-3">
                    <label class="form-label">الخدمة</label>
                    <select name="service_id" class="form-select" required>
                        <option value="">اختر الخدمة...</option>
                        <?php foreach ($SERVICE_OPTIONS as $sid=>$label): ?>
                            <option value="<?= h($sid) ?>" <?= ($sid === $serviceId ? 'selected' : '') ?>>
                                <?= h($sid . ' — ' . $label) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-3">
                    <label class="form-label">من تاريخ</label>
                    <input type="date" name="from_date" class="form-control" value="<?= h($fromDate) ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">إلى تاريخ</label>
                    <input type="date" name="to_date" class="form-control" value="<?= h($toDate) ?>">
                </div>

                <div class="col-12 d-flex align-items-end gap-2">
                    <button type="submit" class="btn btn-primary ms-auto">عرض النتائج</button>
                    <!-- ✅ زر تصدير Excel (يرسل نفس الفلاتر) -->
                    <button type="submit" name="export" value="excel" class="btn btn-success">
                        <i class="fa fa-file-excel-o"></i> تصدير Excel
                    </button>
                </div>
            </form>

            <?php if ($errorMsg): ?>
                <div class="alert alert-danger mt-3"><?= $errorMsg ?></div>
            <?php endif; ?>
        </div>
    </div>

    <?php if ($didSubmit && !$errorMsg): ?>
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <div class="d-flex flex-wrap justify-content-between align-items-center mb-3">
                    <div>
                        <div class="fw-bold">نتائج البحث:</div>
                        <div class="small-muted">
                            رقم الهوية: <span class="fw-semibold"><?= h($patientId) ?></span>
                            &nbsp;|&nbsp; service_id: <span class="fw-semibold"><?= h($serviceId) ?></span>
                            &nbsp;|&nbsp; الخدمة: <span class="fw-semibold"><?= h($SERVICE_OPTIONS[$serviceId] ?? '') ?></span>
                            <?php if ($fromDate || $toDate): ?>
                                &nbsp;|&nbsp; النطاق الزمني:
                                <span class="fw-semibold">
                                    <?= $fromDate ? h($fromDate) : '—' ?> إلى <?= $toDate ? h($toDate) : '—' ?>
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="d-flex flex-wrap gap-2 mt-2 mt-md-0">
                        <span class="badge text-bg-secondary">الإجمالي (ضمن النطاق): <?= (int)$stats['total'] ?></span>
                        <span class="badge text-bg-success">مكتمل (ضمن النطاق): <?= (int)($stats['مكتمل'] ?? 0) ?></span>
                        <span class="badge text-bg-warning">محجوز: <?= (int)($stats['محجوز'] ?? 0) ?></span>
                        <span class="badge text-bg-danger">ملغي: <?= (int)($stats['ملغي'] ?? 0) ?></span>
                        <span class="badge text-bg-info">المتبقي ضمن النطاق: <?= $remaining_in_range ?></span>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>القيمة الإجمالية للخدمة</th>
                                <th>المبلغ المالي المُقدَّم</th>
                                <th>المبلغ المالي المتبقي</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="amount"><?= number_format($service_total_amount, 2) ?> ريال</td>
                                <td class="amount">
                                    <?= number_format($amount_provided, 2) ?> ريال
                                    <span class="small-muted ms-1">(المكتمل الكلي: <?= (int)$completed_all ?> جلسة، قيمة الجلسة: <?= number_format($per_session_value, 2) ?>)</span>
                                </td>
                                <td class="amount">
                                    <?= number_format($amount_remaining, 2) ?> ريال
                                    <span class="small-muted ms-1">(المتبقي من الجلسات: <?= (int)$remaining_sessions ?>)</span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>

        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>اسم المستفيد</th>
                                <th>التاريخ</th>
                                <th>اليوم</th>
                                <th>الوقت</th>
                                <th>نهاية</th>
                                <th>الفترة</th>
                                <th>الحالة</th>
                                <th>الغرفة</th>
                                <th>الأخصائي</th>
                                <th>رقم الخدمة</th>
                                <th>نوع الخدمة</th>
                                <th>ملاحظات</th>
                                <th>القيمة الإجمالية للخدمة</th>
                                <th>المبلغ المُقدَّم</th>
                                <th>المبلغ المتبقي</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if (!$rows): ?>
                            <tr><td colspan="16" class="text-center text-muted">لا توجد مواعيد مطابقة</td></tr>
                        <?php else: ?>
                            <?php foreach ($rows as $i=>$r): ?>
                                <tr>
                                    <td><?= $i+1 ?></td>
                                    <td><?= h($r['patient_name']) ?></td>
                                    <td><?= h($r['booking_date']) ?></td>
                                    <td><?= h($r['dayname']) ?></td>
                                    <td><?= h($r['time_slot']) ?></td>
                                    <td><?= h($r['end_time']) ?></td>
                                    <td><?= h($r['period']) ?></td>
                                    <td>
                                        <?php
                                            $status = (string)$r['bookingstatus'];
                                            $class  = 'text-bg-secondary';
                                            if     ($status === 'مكتمل') $class = 'text-bg-success';
                                            elseif ($status === 'محجوز') $class = 'text-bg-warning';
                                            elseif ($status === 'ملغي')  $class = 'text-bg-danger';
                                        ?>
                                        <span class="badge <?= $class ?>"><?= h($status) ?></span>
                                    </td>
                                    <td><?= h($r['room_id']) ?></td>
                                    <td><?= h($r['spclistsname']) ?></td>
                                    <td><?= h($r['service_id']) ?></td>
                                    <td><?= h($r['typeservice']) ?></td>
                                    <td><?= h($r['notes']) ?></td>
                                    <td class="amount"><?= number_format($service_total_amount, 2) ?> ريال</td>
                                    <td class="amount"><?= number_format($amount_provided, 2) ?> ريال</td>
                                    <td class="amount"><?= number_format($amount_remaining, 2) ?> ريال</td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <div class="small-muted">
                    <strong>ملاحظة:</strong> يُحتسب <em>المبلغ المُقدَّم</em> اعتمادًا على <strong>إجمالي الجلسات المكتملة للمستفيد</strong> عبر كل الفترات.
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
</body>
</html>
