<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام حجز مواعيد المرضى</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            direction: rtl;
            margin: 0;
            padding: 20px;
        }
        h1 {
            text-align: center;
        }
        .form-container {
            max-width: 600px;
            margin: 0 auto;
            background: #f9f9f9;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        select, input[type="text"], input[type="time"], input[type="date"] {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
        .availability-list {
            margin-top: 20px;
        }
        .availability-buttons {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
            margin-top: 10px;
        }
        .availability-buttons button {
            padding: 10px 20px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        .availability-buttons button:hover {
            background-color: #0056b3;
        }
        .confirmation-message {
            text-align: center;
            font-size: 18px;
            color: green;
            margin-top: 20px;
        }
    </style>
</head>
<body>

<h1>نظام حجز مواعيد المرضى</h1>

<div class="form-container">
    <form id="booking-form">
        <label for="booking_date">التاريخ:</label>
        <input type="date" id="booking_date" name="booking_date" required>

        <label for="period">الفترة:</label>
        <select id="period" name="period" required>
            <option value="morning">صباحي</option>
            <option value="afternoon">مسائي</option>
        </select>

        <label for="room_id">الغرفة:</label>
        <select id="room_id" name="room_id" required>
            <!-- سيتم ملؤها ديناميكيًا -->
        </select>

        <label for="patient_name">اسم المريض:</label>
        <input type="text" id="patient_name" name="patient_name" required>

        <label for="typeservice">نوع الخدمة:</label>
        <input type="text" id="typeservice" name="typeservice" required>
    </form>

    <div class="availability-list" id="availability-list">
        <!-- سيتم عرض الأوقات المتاحة هنا -->
    </div>

    <div class="confirmation-message" id="confirmation-message" style="display: none;">
        <p>تم حجز الموعد بنجاح! شكرًا لاختيارك عيادتنا.</p>
    </div>
</div>

<script>
    document.getElementById('period').addEventListener('change', function() {
        let period = this.value;
        let date = document.getElementById('booking_date').value;
        if (date) {
            fetchAvailableSlots(period, date);
        }
    });

    function fetchAvailableSlots(period, date) {
        fetch(`get_available_slots.php?period=${period}&date=${date}`)
            .then(response => response.json())
            .then(data => {
                updateRoomSelect(data.rooms);
                updateAvailabilityList(data.slots);
            })
            .catch(error => console.error('Error:', error));
    }

    function updateRoomSelect(rooms) {
        const roomSelect = document.getElementById('room_id');
        roomSelect.innerHTML = '';
        rooms.forEach(room => {
            let option = document.createElement('option');
            option.value = room;
            option.textContent = `غرفة ${room}`;
            roomSelect.appendChild(option);
        });
    }

    function updateAvailabilityList(slots) {
        const availabilityList = document.getElementById('availability-list');
        availabilityList.innerHTML = '';
        if (slots.length === 0) {
            availabilityList.innerHTML = '<p>لا توجد أوقات متاحة في هذا القسم حالياً.</p>';
        } else {
            let buttonsHtml = '<div class="availability-buttons">';
            slots.forEach(slot => {
                buttonsHtml += `<button class="slot-button" data-time="${slot.time}" data-room="${slot.room}">
                                    ${slot.time} - غرفة: ${slot.room}
                                  </button>`;
            });
            buttonsHtml += '</div>';
            availabilityList.innerHTML = buttonsHtml;
            attachSlotButtonListeners();
        }
    }

    function attachSlotButtonListeners() {
        const slotButtons = document.querySelectorAll('.slot-button');
        slotButtons.forEach(button => {
            button.addEventListener('click', function() {
                const selectedTime = this.dataset.time;
                const selectedRoom = this.dataset.room;
                const patientName = document.getElementById('patient_name').value;
                const date = document.getElementById('booking_date').value;
                const period = document.getElementById('period').value;
                const typeservice = document.getElementById('typeservice').value;

                bookAppointment(selectedTime, selectedRoom, patientName, date, period, typeservice);
            });
        });
    }

    function bookAppointment(selectedTime, selectedRoom, patientName, date, period, typeservice) {
        let formData = new FormData();
        formData.append('time_slot', selectedTime);
        formData.append('room_id', selectedRoom);
        formData.append('patient_name', patientName);
        formData.append('booking_date', date);
        formData.append('period', period);
        formData.append('typeservice', typeservice);

        fetch('book_appointment.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(data => {
            if (data === 'success') {
                document.getElementById('booking-form').style.display = 'none';
                document.getElementById('availability-list').style.display = 'none';
                document.getElementById('confirmation-message').style.display = 'block';
            } else {
                alert('حدث خطأ أثناء الحجز، يرجى المحاولة مرة أخرى.');
            }
        })
        .catch(error => console.error('Error:', error));
    }
</script>

</body>
</html>
