<?php
/**
 * عرض وفلترة وتصدير جدول claimsrequests
 * - فلاتر تاريخ من/إلى على registerdate
 * - فلترة بالحالة على orderstatus إذا كان العمود موجودًا
 * - زر "تصدير إكسل" (CSV بترميز UTF-8 + BOM)
 * - عمود "عرض المطالبة"
 * - عمود "إنشاء فاتورة" يمرّر orderid & customerid إلى createinvoice.php
 */

mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ===== الاتصال بقاعدة البيانات =====
$have_external_conn = false;
if (file_exists(__DIR__ . '/conn.php')) {
    include __DIR__ . '/conn.php'; // يجب أن يعرّف $conn = new mysqli(...)
    if (isset($conn) && $conn instanceof mysqli) {
        $have_external_conn = true;
    }
}
if (!$have_external_conn) {
    // عدّل بيانات الاتصال إن لم تستخدم conn.php
    $conn = new mysqli('localhost', 'acesaudi_site', 'tabfyv-6xiFry-noczak', 'acesaudi_usr');
    if ($conn->connect_error) {
        die('فشل الاتصال بقاعدة البيانات: ' . $conn->connect_error);
    }
}
$conn->set_charset('utf8mb4');

// ===== التحقق من وجود عمود orderstatus =====
$status_col = 'orderstatus';
$status_filter_enabled = false;

$chkSql = "SELECT COUNT(*) AS c
           FROM INFORMATION_SCHEMA.COLUMNS
           WHERE TABLE_SCHEMA = DATABASE()
             AND TABLE_NAME = 'claimsrequests'
             AND COLUMN_NAME = ?";
$chk = $conn->prepare($chkSql);
$chk->bind_param("s", $status_col);
$chk->execute();
$existsRes = $chk->get_result()->fetch_assoc();
$chk->close();
$status_filter_enabled = !empty($existsRes['c']);

// ===== قراءة الفلاتر =====
$from_raw = isset($_GET['from']) ? trim($_GET['from']) : '';
$to_raw   = isset($_GET['to'])   ? trim($_GET['to'])   : '';
$status   = isset($_GET['status']) ? trim($_GET['status']) : ''; // جديد/معلق/مرفوض/ملاحظات
$export   = isset($_GET['export']) ? trim($_GET['export']) : '';

$where  = [];
$params = [];
$types  = "";

// فلترة التاريخ (registerdate DATETIME)
if ($from_raw !== '') {
    $from_dt = date('Y-m-d 00:00:00', strtotime($from_raw));
    $where[] = "registerdate >= ?";
    $params[] = $from_dt;
    $types   .= "s";
}
if ($to_raw !== '') {
    $to_dt = date('Y-m-d 23:59:59', strtotime($to_raw));
    $where[] = "registerdate <= ?";
    $params[] = $to_dt;
    $types   .= "s";
}

// فلترة الحالة
$allowed_statuses = ['جديد','معلق','مرفوض','ملاحظات'];
if ($status_filter_enabled && $status !== '' && in_array($status, $allowed_statuses, true)) {
    $where[] = "$status_col = ?";
    $params[] = $status;
    $types   .= "s";
}

// ===== الاستعلام الأساسي =====
$select_cols = "
    idrequestclaim,
    customername,
    customerid,
    service,
    orderid,
    paymentmethode,
    eligabiltystatus,
    registerdate" . ($status_filter_enabled ? ", $status_col" : "");

$sql = "SELECT $select_cols FROM claimsrequests";
if (!empty($where)) $sql .= " WHERE " . implode(" AND ", $where);
$sql .= " ORDER BY registerdate DESC, idrequestclaim DESC";

// ===== تنفيذ الاستعلام =====
$stmt = $conn->prepare($sql);
if (!$stmt) die('<h3 style="color:red;text-align:center;">فشل تحضير الاستعلام: ' . htmlspecialchars($conn->error, ENT_QUOTES, 'UTF-8') . '</h3>');
if (!empty($params)) $stmt->bind_param($types, ...$params);
$stmt->execute();
$res = $stmt->get_result();
$rows = $res ? $res->fetch_all(MYSQLI_ASSOC) : [];
$stmt->close();

// ===== وضع التصدير CSV =====
if ($export === 'excel') {
    $safe = function($v) {
        $v = (string)($v ?? '');
        if (preg_match('/^[=+\-@]/u', $v)) $v = "'".$v;
        return $v;
    };

    $filename = "claimsrequests_" . date('Ymd_His') . ".csv";
    header('Content-Type: text/csv; charset=UTF-8');
    header('Content-Disposition: attachment; filename="'.$filename.'"');
    echo "\xEF\xBB\xBF";

    $out = fopen('php://output', 'w');

    $headers = [
        'ID','الاسم','رقم الهوية','الخدمة','رقم الطلب',
        'وسيلة الدفع','حالة الأحقية','تاريخ التسجيل'
    ];
    if ($status_filter_enabled) $headers[] = 'الحالة';
    fputcsv($out, $headers);

    foreach ($rows as $r) {
        $row = [
            (int)$r['idrequestclaim'],
            $safe($r['customername'] ?? ''),
            $safe($r['customerid'] ?? ''),
            $safe($r['service'] ?? ''),
            $safe($r['orderid'] ?? ''),
            $safe($r['paymentmethode'] ?? ''),
            $safe($r['eligabiltystatus'] ?? ''),
            ($r['registerdate'] ? date('Y-m-d H:i', strtotime($r['registerdate'])) : '')
        ];
        if ($status_filter_enabled) $row[] = $safe($r[$status_col] ?? '');
        fputcsv($out, $row);
    }
    fclose($out);
    exit;
}

// ===== دوال مساعدة للواجهة =====
function build_query($extra = []) {
    $q = $_GET;
    foreach ($extra as $k=>$v) {
        if ($v === null) unset($q[$k]); else $q[$k] = $v;
    }
    return '?' . http_build_query($q);
}

// عدد الأعمدة: 11 (مع عمود الحالة إن وُجد): #, الاسم, الهوية, الخدمة, الطلب, الدفع, الحالة?, الأحقية, التاريخ, عرض, فاتورة
$col_count = 11 + ($status_filter_enabled ? 1 : 0);
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>طلبات المطالبات التأمينية</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body{font-family:Tajawal, Tahoma, Arial; background:#f7f7f7; margin:0; padding:20px;}
.container{max-width:1600px; margin:auto; background:#fff; padding:20px; border-radius:12px; box-shadow:0 6px 18px rgba(0,0,0,.06);}
h2{margin-top:0}
.form-row{display:flex; gap:12px; flex-wrap:wrap; align-items:flex-end; margin-bottom:16px}
.form-group{display:flex; flex-direction:column; min-width:220px}
label{margin-bottom:6px; font-size:14px; color:#333}
input[type="date"], select{padding:8px 10px; border:1px solid #ddd; border-radius:8px}
button,.btn{padding:9px 14px; border:0; background:#0d6efd; color:#fff; border-radius:8px; cursor:pointer; text-decoration:none; display:inline-block}
button:hover,.btn:hover{background:#0b5ed7}
.btn-secondary{background:#198754}
.btn-secondary:hover{background:#157347}
.btn-warning{background:#ff8c00}
.btn-warning:hover{background:#e67f00}
.badge{display:inline-block; padding:3px 8px; border-radius:999px; font-size:12px; color:#fff}
.badge-new{background:#198754}
.badge-pending{background:#ffc107; color:#000}
.badge-reject{background:#dc3545}
.badge-note{background:#6c757d}
.table-wrap{overflow:auto}
table{width:100%; border-collapse:collapse; margin-top:10px}
th,td{border-bottom:1px solid #eee; padding:10px; text-align:center; white-space:nowrap}
th{background:#fafafa}
.alert{background:#fff3cd; color:#664d03; border:1px solid #ffecb5; padding:10px 12px; border-radius:8px; margin:10px 0}
.count{margin:6px 0 0 0; color:#666; font-size:14px}
.actions{display:flex; gap:8px; justify-content:center}
</style>
</head>
<body>
<div class="container">
  <h2>طلبات المطالبات التأمينية</h2>

  <?php if (!$status_filter_enabled): ?>
    <div class="alert">
      لا يوجد عمود <b>orderstatus</b> في جدول <b>claimsrequests</b> لذا فلترة الحالة معطّلة مؤقتًا.
      لإضافته:
      <code>ALTER TABLE claimsrequests ADD COLUMN orderstatus VARCHAR(30) NULL AFTER paymentmethode;</code>
    </div>
  <?php endif; ?>

  <form method="get" class="filters">
    <div class="form-row">
      <div class="form-group">
        <label>من تاريخ</label>
        <input type="date" name="from" value="<?php echo htmlspecialchars($from_raw, ENT_QUOTES, 'UTF-8'); ?>">
      </div>
      <div class="form-group">
        <label>إلى تاريخ</label>
        <input type="date" name="to" value="<?php echo htmlspecialchars($to_raw, ENT_QUOTES, 'UTF-8'); ?>">
      </div>
      <div class="form-group">
        <label>الحالة</label>
        <select name="status" <?php echo $status_filter_enabled ? '' : 'disabled'; ?>>
          <option value="">الكل</option>
          <?php foreach ($allowed_statuses as $st): ?>
            <option value="<?php echo htmlspecialchars($st,ENT_QUOTES,'UTF-8'); ?>"
                    <?php echo ($status === $st) ? 'selected' : ''; ?>>
              <?php echo $st; ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="form-group">
        <button type="submit">تطبيق الفلاتر</button>
      </div>
      <div class="form-group">
        <a class="btn btn-secondary" href="<?php echo build_query(['export'=>'excel']); ?>">تصدير إكسل</a>
      </div>
    </div>
  </form>

  <div class="count">عدد النتائج: <b><?php echo number_format(count($rows)); ?></b></div>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>الاسم</th>
          <th>رقم الهوية</th>
          <th>الخدمة</th>
          <th>رقم الطلب</th>
          <th>وسيلة الدفع</th>
          <?php if ($status_filter_enabled): ?>
            <th>الحالة</th>
          <?php endif; ?>
          <th>حالة الأحقية</th>
          <th>تاريخ التسجيل</th>
          <th>عرض</th>
         
        </tr>
      </thead>
      <tbody>
        <?php if (empty($rows)): ?>
          <tr><td colspan="<?php echo $col_count; ?>">لا توجد بيانات مطابقة للفلاتر.</td></tr>
        <?php else: ?>
          <?php foreach ($rows as $r): ?>
            <tr>
              <td><?php echo (int)$r['idrequestclaim']; ?></td>
              <td><?php echo htmlspecialchars($r['customername'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars($r['customerid'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars($r['service'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars($r['orderid'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars($r['paymentmethode'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>

              <?php if ($status_filter_enabled): ?>
                <td>
                  <?php
                    $st = $r[$status_col] ?? '';
                    $badge = '';
                    if ($st === 'جديد')       $badge = 'badge badge-new';
                    elseif ($st === 'معلق')   $badge = 'badge badge-pending';
                    elseif ($st === 'مرفوض')  $badge = 'badge badge-reject';
                    elseif ($st === 'ملاحظات')$badge = 'badge badge-note';
                    echo $st ? '<span class="'.$badge.'">'.htmlspecialchars($st,ENT_QUOTES,'UTF-8').'</span>' : '';
                  ?>
                </td>
              <?php endif; ?>

              <td><?php echo htmlspecialchars($r['eligabiltystatus'] ?? '', ENT_QUOTES, 'UTF-8'); ?></td>
              <td><?php
                $dt = $r['registerdate'] ?? '';
                echo $dt ? htmlspecialchars(date('Y-m-d H:i', strtotime($dt)), ENT_QUOTES, 'UTF-8') : '';
              ?></td>

              <!-- زر عرض المطالبة -->
              <td class="actions">
                <a class="btn" href="<?php
                    echo 'viewclaim.php?idrequestclaim='.(int)$r['idrequestclaim']
                         .'&beneficiaryid='.rawurlencode($r['customerid'] ?? '');
                ?>" target="_blank">عرض المطالبة</a>
              </td>

              <!-- زر إنشاء الفاتورة (يمرّر orderid & customerid) -->
              <td class="actions">
                <?php
                  $order = $r['orderid'] ?? '';
                  $cust  = $r['customerid'] ?? '';
                  if ($order !== '' && $cust !== '') {
                      $invoiceUrl = 'createinvoice.php?orderid=' . rawurlencode($order)
                                  . '&customerid=' . rawurlencode($cust);
                      echo '<a class="btn btn-warning" href="'.$invoiceUrl.'" target="_blank">إنشاء فاتورة</a>';
                  } else {
                      echo '<span style="color:#999;">بيانات ناقصة</span>';
                  }
                ?>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
</body>
</html>
