
<title>الفاتورة الألكترونية</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" /> 
</head>
<body>

<div class="container" style="text-align: center;padding-top: 50px;">
<div class="jumbotron">
     <br>
     <a href="#" class="thumbnail">
      <img src="logo2030.png" alt="..." style="width: 250px;height: 250px;">
    </a><br>
    <?php
/** createinvoice.php – full server side (DB connect + save) */
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
error_reporting(E_ALL);
ini_set('display_errors', 1);

/* ========== DB CONNECTION ========== */
$have_external_conn = false;
if (file_exists(__DIR__.'/conn.php')) {
  include __DIR__.'/conn.php';
  if (isset($conn) && $conn instanceof mysqli) $have_external_conn = true;
}
if (!$have_external_conn) {
  // نفس بيانات الاتصال التي استخدمتها سابقًا
  $conn = new mysqli("localhost:3306", "acesaudi_usr", "tabfyv-6xiFry-noczak", "acesaudi_site");
  if ($conn->connect_error) die("DB error: ".$conn->connect_error);
}
$conn->set_charset('utf8mb4');

/* ========== HELPERS ========== */
function esc($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
function gen_invoice_no(mysqli $c): string {
  // يرفع آخر رقم في جدول الفواتير (يمكن تغييره للاعتماد على qrcode)
  $r = $c->query("SELECT MAX(CAST(invoice_no AS UNSIGNED)) AS mx FROM insurance_invoices");
  $mx = ($r && ($row=$r->fetch_assoc()) && $row['mx']) ? (int)$row['mx'] : 0;
  return str_pad((string)($mx+1), 5, '0', STR_PAD_LEFT);
}
function to_dt($v){
  if(!$v) return null;
  $v = str_replace('T',' ',$v);
  if (preg_match('/^\d{4}-\d{2}-\d{2}$/',$v)) $v .= ' 00:00:00';
  if (preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}$/',$v)) $v .= ':00';
  $ts = strtotime($v); return $ts ? date('Y-m-d H:i:s',$ts) : null;
}
function nf($x){ return number_format((float)$x,2,'.',''); }

/* ========== (اختياري) Prefill عبر GET ========== */
echo $orderid            = trim($_GET['orderid']            ?? '');
$customerid         = trim($_GET['customerid']         ?? ''); // BENEFICIARYID أو DOCUMENTID
$insurancecompanyid = trim($_GET['insurancecompanyid'] ?? ''); // PAYER NPHIES ID

/* اجلب بيانات المستفيد (إن لزم لاستخدام الهاتف/الاسم) */
$B = [];
if ($customerid !== '') {
  $sql = "SELECT * FROM NPHIES_BENEFICIARY WHERE BENEFICIARYID=? OR DOCUMENTID=? LIMIT 1";
  if ($st = $conn->prepare($sql)) {
    $st->bind_param("ss", $customerid, $customerid);
    $st->execute(); $B = $st->get_result()->fetch_assoc() ?: [];
    $st->close();
  }
}

/* ========== SAVE ========== */
$msg = '';
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['save_invoice'])) {

  /* 1) اجمع حقول الرأس من النموذج */
  $invoice_no    = trim($_POST['invoice_no'] ?? gen_invoice_no_from_qrcode($conn));
  $invoice_date  = trim($_POST['invoice_date'] ?? date('Y-m-d'));
  $issue_date    = trim($_POST['issue_date'] ?? $invoice_date);
  $payment_terms = (int)($_POST['payment_terms'] ?? 0);
  $due_date      = trim($_POST['due_date'] ?? $invoice_date);
  $currency      = trim($_POST['currency'] ?? 'SAR');
  $mobile      = trim($_POST['mobile'] ?? '');
  $beneficiaryid = trim($_POST['beneficiaryid'] ?? '');
  $documentid    = trim($_POST['documentid'] ?? '');
  $patient_name  = trim($_POST['patient_name'] ?? '');
  $orderid_post  = trim($_POST['orderid'] ?? '');
  $payer_nphies  = trim($_POST['payer_nphies_id'] ?? '');
  $notes         = trim($_POST['notes'] ?? '');
  $payer_name = trim(htmlspecialchars($_POST['payer_name']));

  /* 2) مصفوفات البنود */
  $service_id   = $_POST['service_id']   ?? [];
  $item_desc    = $_POST['item_desc']    ?? [];
  $item_note    = $_POST['item_note']    ?? [];
  $qty          = $_POST['qty']          ?? [];
  $unit_price   = $_POST['unit_price']   ?? [];
  $discount_pct = $_POST['discount_pct'] ?? [];
  $tax_pct      = $_POST['tax_pct']      ?? [];
  $copayment    = $_POST['copayment']    ?? [];

  /* 3) احسب المجاميع */
  $subtotal=0; $discount_total=0; $tax_total=0; $grand_total=0; $copayment_total=0;
  $lines=[]; $n = max(count($item_desc), count($qty));
  for ($i=0; $i<$n; $i++) {
    $desc = trim($item_desc[$i] ?? '');
    if ($desc==='') continue;

    $sid   = (int)($service_id[$i] ?? 0);
    $note  = trim($item_note[$i] ?? '');
    $q     = (float)str_replace(',','',$qty[$i] ?? 1);
    $price = (float)str_replace(',','',$unit_price[$i] ?? 0);
    $discP = (float)str_replace(',','',$discount_pct[$i] ?? 0);
    $taxP  = (float)str_replace(',','',$tax_pct[$i] ?? 0);
    $cop   = (float)str_replace(',','',$copayment[$i] ?? 0);

    $line_gross = $q * $price;
    $line_disc  = $line_gross * ($discP/100);
    $line_net   = $line_gross - $line_disc;
    $line_tax   = $line_net * ($taxP/100);
    $line_total = $line_net + $line_tax;

    $subtotal        += $line_net;
    $discount_total  += $line_disc;
    $tax_total       += $line_tax;
    $grand_total     += $line_total;
    $copayment_total += $cop;

    $lines[] = [
      'sid'=>$sid,'desc'=>$desc,'note'=>$note,
      'q'=>$q,'price'=>$price,'discP'=>$discP,'taxP'=>$taxP,
      'line_net'=>$line_net,'line_tax'=>$line_tax,'line_total'=>$line_total,'cop'=>$cop
    ];
  }

  /* 4) تحضيرات إضافية لـ qrcode */
  $service_names = [];
  foreach ($lines as $ln){ $t = trim($ln['desc'] ?? ''); if($t!=='') $service_names[] = mb_substr($t,0,100); }
  $servicename = mb_substr(implode(', ', array_slice(array_unique($service_names),0,6)), 0, 500);
  $items_json  = json_encode($lines, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);

  $idqrcode        = $invoice_no;                                 // لا تثبّت رقمًا ثابتًا
  $customerid_val  = $beneficiaryid ?: $documentid;
  $idcustomer_val  = $documentid ?: $beneficiaryid;
  $customername    = $patient_name;
  $mobile_val      = $B['CONTACTNUMBER'] ?? '';
  $mobile      = trim($_POST['mobile'] ?? '');
  $insuranseconame = $payer_name ?? '';                           // اسم شركة التأمين (إن توفر)
  $insurancecoid   = $payer_nphies;
  $invoicestatus   = 'new';
  $userconfirmed   = 'Finance';
  $timeadded       = date('Y-m-d H:i:s');

  $issue_dt  = to_dt($issue_date) ?: $timeadded;
  $due_dt    = to_dt($due_date)   ?: $issue_dt;

  $totalamountwat_s = nf($grand_total); // إجمالي مع الضريبة
  $s_vat_s          = nf($tax_total);   // يطابق العمود ``s vat``
  $amountwat_s      = nf($subtotal);    // صافي قبل الضريبة

  /* 5) المعاملة */
  $conn->begin_transaction();
  try {
    /* 5.a) إدراج qrcode (أسماء الأعمدة حسب هيكلة جدولك) */
    $sql = "INSERT INTO `qrcode`
            (`idinvoice`,`idqrcode`,`customerid`,`totalamountwvat`,`vat`,`amountwvat`,`timeadded`,
             `invoicestatus`,`userconfirmed`,`idcustomer`,`customername`,`servicename`,`mobile`,
             `insuranseconame`,`insurancecoid`,`discount_total`,`copayment_total`,`items`,
             `issue_date`,`due_date`,`payment_terms`,`currency`,`payer_nphies_id`,
             `subtotal`,`grand_total`,`notes`)
            VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    $st = $conn->prepare($sql);
    if(!$st) throw new RuntimeException("prepare qrcode: ".$conn->error);

    // 25 قيمة: 21 نص + 4 أرقام (float)
    $types_qr = "sssssssssssssssddssssssdds";
    $st->bind_param(
      $types_qr,
      $idqrcode, $idqrcode, $customerid_val, $totalamountwat_s, $s_vat_s, $amountwat_s, $timeadded,
      $invoicestatus, $userconfirmed, $idcustomer_val, $customername, $servicename, $mobile,
      $insuranseconame, $insurancecoid, $discount_total, $copayment_total, $items_json,
      $issue_dt, $due_dt, $payment_terms, $currency, $payer_nphies,
      $subtotal, $grand_total, $notes
    );
    if(!$st->execute()) throw new RuntimeException("exec qrcode: ".$st->error);
    $st->close();

    /* 5.b) إدراج رأس الفاتورة */
    $sql = "INSERT INTO insurance_invoices
            (invoice_no, invoice_date, issue_date, due_date, payment_terms, currency,
             beneficiaryid, documentid, patient_name, mobile, orderid, payer_nphies_id,
             subtotal, discount_total, tax_total, copayment_total, grand_total, notes)
            VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    $st = $conn->prepare($sql);
    if(!$st) throw new RuntimeException("prepare inv: ".$conn->error);

    $types_inv = "ssssissssssdddddds";
    $st->bind_param(
      $types_inv,
      $invoice_no, $invoice_date, $issue_date, $due_date, $payment_terms, $currency,
      $beneficiaryid, $documentid, $patient_name, $mobile, $orderid_post, $payer_nphies,
      $subtotal, $discount_total, $tax_total, $copayment_total, $grand_total, $notes
    );
    if(!$st->execute()) throw new RuntimeException("exec inv: ".$st->error);
    $invoice_id = $st->insert_id;
    $st->close();

    /* 5.c) إدراج البنود في insurance_invoice_items */
    if (!is_array($lines) || empty($lines)) {
      throw new RuntimeException('لا توجد بنود لإدراجها.');
    }
    $sql = "INSERT INTO insurance_invoice_items
              (invoice_id, item_desc, qty, unit_price, discount_pct, tax_pct,
               line_net, line_tax, line_total, copayment)
            VALUES (?,?,?,?,?,?,?,?,?,?)";
    $st = $conn->prepare($sql);
    if(!$st) throw new RuntimeException("prepare items: ".$conn->error);

    // 1 int + 1 string + 8 double
    $types_items = "isdddddddd";
    $invoice_id_i   = (int)$invoice_id;
    $item_desc_s    = '';
    $qty_d = $unit_price_d = $discount_pct_d = $tax_pct_d = $line_net_d = $line_tax_d = $line_total_d = $copayment_d = 0.0;

    if(!$st->bind_param(
      $types_items,
      $invoice_id_i, $item_desc_s, $qty_d, $unit_price_d, $discount_pct_d, $tax_pct_d,
      $line_net_d, $line_tax_d, $line_total_d, $copayment_d
    )) throw new RuntimeException("bind items: ".$st->error);

    foreach ($lines as $ln) {
      $item_desc_s    = (string)($ln['desc'] ?? ($ln['code'] ?? ''));
      $qty_d          = max(0,(float)$ln['q']);
      $unit_price_d   = max(0,(float)$ln['price']);
      $discount_pct_d = max(0,(float)$ln['discP']);
      $tax_pct_d      = max(0,(float)$ln['taxP']);
      $line_net_d     = (float)$ln['line_net'];
      $line_tax_d     = (float)$ln['line_tax'];
      $line_total_d   = (float)$ln['line_total'];
      $copayment_d    = (float)$ln['cop'];
      if(!$st->execute()) throw new RuntimeException("exec item: ".$st->error);
    }
    $st->close();

    $conn->commit();
    $msg = 'تم حفظ الفاتورة بنجاح. رقم الفاتورة: '.esc($invoice_no).' (ID='.(int)$invoice_id.')';

  } catch (Throwable $e) {
    $conn->rollback();
    die('فشل الحفظ: '.esc($e->getMessage()));
  }
}

/* يمكن عرض رسالة النجاح أعلى النموذج */
if ($msg !== '') {
  echo '<div class="alert alert-success" role="alert" style="margin:10px 0;">'. $msg .'</div>';
}

/* باقي الصفحة: اترك نموذجك الحالي كما هو ويرسل إلى نفس الصفحة مع name="save_invoice" */
?>
  <span class="label label-danger"><br>💡<br><h3>هل تود تأكيد توليد الفاتورة الضريبية ؟</h3><br><h3>Are you sure that the invoice will be confirme it electronically ? </h3></span><br>
  <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" fill="currentColor" class="bi bi-check-circle-fill" viewBox="0 0 16 16">
         <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zm-3.97-3.03a.75.75 0 0 0-1.08.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-.01-1.05z"/>
       </svg><br>


<?php
/** createinvoice.php — إصدار كامل مع Autocomplete + حفظ في qrcode */
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
error_reporting(E_ALL);
ini_set('display_errors', 1);

/* ===== اتصال قاعدة البيانات ===== */
$have_external_conn = false;
if (file_exists(__DIR__.'/conn.php')) {
  include __DIR__.'/conn.php'; // يجب أن يعرّف $conn = new mysqli(...)
  if (isset($conn) && $conn instanceof mysqli) $have_external_conn = true;
}
if (!$have_external_conn) {
  $conn = new mysqli('localhost','acesaudi_usr','tabfyv-6xiFry-noczak','acesaudi_site');
  if ($conn->connect_error) die('DB connection failed: '.$conn->connect_error);
}
$conn->set_charset('utf8mb4');

/* تأكيد وجود عمود payer_name إن لم يكن مدعومًا في CREATE السابق */
$col = $conn->query("SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME='insurance_invoices' AND COLUMN_NAME='payer_name'");
if ($col && !$col->num_rows) {
  $conn->query("ALTER TABLE insurance_invoices ADD COLUMN payer_name VARCHAR(255) NULL AFTER payer_nphies_id");
}


/* ===== مدخلات GET ===== */
echo $orderid            = trim($_GET['orderid'] ?? '');
echo $customerid         = trim($_GET['customerid'] ?? '');        // BENEFICIARYID أو DOCUMENTID
echo $insurancecompanyid = trim($_GET['insurancecompanyid'] ?? ''); // فلتر الخدمات (اختياري)

/* ===== جلب بيانات المستفيد ===== */
$B = [];
if ($customerid !== '') {
  $sql = "SELECT * FROM NPHIES_BENEFICIARY WHERE BENEFICIARYID = ? OR DOCUMENTID = ? LIMIT 1";
  $st = $conn->prepare($sql);
  $st->bind_param("ss", $customerid, $customerid);
  $st->execute();
  $B = $st->get_result()->fetch_assoc() ?: [];
  $st->close();
}

/* إن لم تُمرّر شركة التأمين: استنتجها من أحدث تغطية */
if ($insurancecompanyid === '' && !empty($B['BENEFICIARYID'])) {
  $sql = "SELECT PAYERNPHIESID FROM NPHIES_COVERAGE
          WHERE BENEFICIARYID = ?
          ORDER BY IFNULL(EXPIRYDATE,'2999-12-31') DESC, COVERAGEID DESC
          LIMIT 1";
  $st = $conn->prepare($sql);
  $st->bind_param("s", $B['BENEFICIARYID']);
  $st->execute();
  if ($r = $st->get_result()->fetch_assoc()) $insurancecompanyid = (string)$r['PAYERNPHIESID'];
  $st->close();
}

/* ===== حفظ الفاتورة ===== */
$msg = '';
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['save_invoice'])) {

  // رؤوس الفاتورة
   $invoice_no    = trim($_POST['invoice_no'] ?? gen_invoice_no($conn));
   $invoice_date  = trim($_POST['invoice_date'] ?? date('Y-m-d'));
   $issue_date    = trim($_POST['issue_date'] ?? $invoice_date);
   $payment_terms = (int)($_POST['payment_terms'] ?? 0);
   $due_date      = trim($_POST['due_date'] ?? $invoice_date);
   $currency      = trim($_POST['currency'] ?? 'SAR');

   $beneficiaryid = trim($_POST['beneficiaryid'] ?? '');
   $CONTACTNUMBER = trim($_POST['CONTACTNUMBER'] ?? '');
   $documentid    = trim($_POST['documentid'] ?? '');
   $patient_name  = trim($_POST['patient_name'] ?? '');
   $orderid_post  = trim($_POST['orderid'] ?? '');

   $payer_nphies  = trim($_POST['payer_nphies_id'] ?? '');
   $payer_name    = trim($_POST['company'] ?? ''); // اسم الشركة من القائمة
   $notes         = trim($_POST['notes'] ?? '');

  // مصفوفات البنود
   $service_id   = $_POST['service_id']   ?? [];
   $item_desc    = $_POST['item_desc']    ?? [];
   $item_note    = $_POST['item_note']    ?? [];
   $qty          = $_POST['qty']          ?? [];
   $unit_price   = $_POST['unit_price']   ?? [];
   $discount_pct = $_POST['discount_pct'] ?? [];
   $tax_pct      = $_POST['tax_pct']      ?? [];
   $copayment    = $_POST['copayment']    ?? [];

  // بناء البنود + الحسابات
   $subtotal=0; $discount_total=0; $tax_total=0; $grand_total=0; $copayment_total=0;
  $lines = []; $valid_rows=0;

   $n = max(count($item_desc), count($qty));
  for ($i=0; $i<$n; $i++) {
     $desc = trim($item_desc[$i] ?? '');
    if ($desc==='') continue;

     $sid   = (int)($service_id[$i] ?? 0);
     $note  = trim($item_note[$i] ?? '');

     $q     = (float)str_replace(',','',$qty[$i] ?? 1);
     $price = (float)str_replace(',','',$unit_price[$i] ?? 0);
     $discP = (float)str_replace(',','',$discount_pct[$i] ?? 0);
     $taxP  = (float)str_replace(',','',$tax_pct[$i] ?? 0);
     $cop   = (float)str_replace(',','',$copayment[$i] ?? 0);

    if ($q<=0 && $price<=0) continue;

     $line_gross = $q * $price;
     $line_disc  = $line_gross * ($discP/100);
     $line_net   = $line_gross - $line_disc;
     $line_tax   = $line_net * ($taxP/100);
     $line_total = $line_net + $line_tax;

     $subtotal        += $line_net;
     $discount_total  += $line_disc;
     '<br>';
     $tax_total       += $line_tax;
     '<br>';
     $grand_total     += $line_total;
     $copayment_total += $cop;

    $lines[] = compact('sid','desc','note','q','price','discP','taxP','line_net','line_tax','line_total','cop');
     $valid_rows++;
  }

  if ($valid_rows===0) {
    $msg = '<span style="color:#c00">لا يوجد بنود صالحة للحفظ</span>';
  } else {
     echo '';
  }
}
  ?>

  <form method="post" action="invoicefinance.php"> 
	
	  <!--<p>الشركه البايع</p>--><input type="text" name="sellername" font size="20" face="@Arial Unicode MS" value="<?php echo $sellername='Autism Center Of Excellence مركزالتميزللتوحد&nbsp';?>" hidden>
	  <span class="error"> <?php //echo $sellernameErr;?></span>

	  <!--<p>الرقم الضريبي</p>--><input type="text" name="vatreg" value="<?php echo $vatreg = '310475033200003' ;?>" hidden>
	  <span class="error"> <?php //echo $vatregErr;?></span>

	  <!--<p>التاريخ و الوقت</p>--><input type="text" name="timestamp" value="<?php echo $invoice_date; ?>" hidden>
	  <span class="error"><?php //echo $timestampErr;?></span>
	  
	  <!--<p>المبلغ شامل الضريبه</p>--> <input type="text" name="totalamountwvat" value="<?php echo $totalamountwvat = $grand_total; ?>" hidden>

	  <span class="error"><?php //echo //$totalamountwvatErr;?></span>
	  <!--<p>الضريبه</p>--> <input type="text" name="totalamountvat" value="<?php echo $totalamountvat = htmlspecialchars($grand_total/115*15); ?>" hidden>
	  <span class="error"><?php //echo //$totalamountvatErr;?></span>

	  <span class="error"><?php //echo //$totalamountwvatErr;?></span>
	  <!--<p>رقم ملف العميل</p>--> <input type="text" name="id" value="<?php echo  $idqrcode; ?>" hidden>
	  <span class="error"><?php //echo //$totalamountvatErr;?></span>

	  <span class="error"><?php //echo $totalamountwvatErr;?></span>
	  <!--<p>رقم الفاتورة</p>--> <input type="text" name="invoiceid" value="<?php echo $invoiceid = htmlspecialchars($grand_total/115*15); ?>" hidden>
	  <span class="error"><?php //echo $totalamountvatErr;?></span>

	   <span class="error"></span>
	  <!--<p>رقم الفاتورة</p>--> <input type="text" name="customerid" value="<?php echo $customerid = htmlspecialchars($_POST['beneficiaryid']); ?>" hidden>
	  <span class="error"><?php //echo $idErr;?></span> 
	  
    <input type="text" name="fullname" value="<?php echo $patient_name; ?>" hidden> 
	  
    <input type="text" name="mobile" value="<?php echo $mobile; ?>" hidden>

    <input type="text" name="paymentmethode" value="<?php echo $payer_name = trim(htmlspecialchars($_POST['payer_name'])); ?>" hidden> 

    <input type="text" name="typeservice" value="<?php echo $servicename = mb_substr(implode(', ', array_slice(array_unique($service_names),0,6)), 0, 500); ?>" hidden> 

    <input type="text" name="q" value="<?php echo $q = (float)str_replace(',','',$qty[$i] ?? 1); ?>" hidden> 

    <input type="text" name="unitprice" value="<?php echo $unit_price; ?>" hidden> 

    <input type="text" name="payer_name" value="<?php echo $payer_name; ?>" hidden> 

    <br><br>
	  <input type="submit" name="button1" value="Confirme VAT Invoice" class="btn btn-primary"/>
	 </form>

</body>
</html>
