<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$host = "localhost:3306";
$dbname = "acesaudi_site";
$username = "acesaudi_usr";
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("فشل الاتصال بقاعدة البيانات: " . $e->getMessage());
}

$selected_dates = $_POST['dates'] ?? [];
$room_id = $_POST['room_id'] ?? '';
$service_type = $_POST['service_type'] ?? '';
$spclistsname = $_POST['spclistsname'] ?? '';
$period = $_POST['period'] ?? '';
$session_duration = $_POST['session_duration'] ?? 45;
$spesilstid = $_POST['spesilstid'] ?? '';
$userupsated = $_POST['userupsated'] ?? '';

if ($_SERVER["REQUEST_METHOD"] === "POST" && !empty($selected_dates)) {
    $days_ar = [
        'Saturday' => 'السبت',
        'Sunday' => 'الأحد',
        'Monday' => 'الإثنين',
        'Tuesday' => 'الثلاثاء',
        'Wednesday' => 'الأربعاء',
        'Thursday' => 'الخميس',
        'Friday' => 'الجمعة',
    ];

    $slots = [
        //['12:00:00', '13:00:00'],
        //['13:00:00', '14:00:00'],
          ['14:00:00', '15:30:00'],
      //  ['14:30:00', '15:15:00'],
      //  ['15:15:00', '16:00:00'],
       // ['16:00:00', '16:45:00'],
       // ['16:45:00', '17:30:00'],
       // ['17:30:00', '18:15:00'],
       // ['18:15:00', '19:00:00'],
       // ['19:00:00', '19:45:00'],
    ];

    $count = 0;
    foreach ($selected_dates as $date_str) {
        $day_name_en = date("l", strtotime($date_str));
        $day_name_ar = $days_ar[$day_name_en] ?? $day_name_en;

        foreach ($slots as $slot) {
            $stmt = $pdo->prepare("INSERT INTO bookings 
                (booking_date, dayname, time_slot, end_time, bookingstatus, room_id, typeservice, spclistsname, period, session_duration, spesilstid, userupsated)
                VALUES 
                (:booking_date, :dayname, :time_slot, :end_time, 'متوفر', :room_id, :typeservice, :spclistsname, :period, :session_duration, :spesilstid, :userupsated)");
            $stmt->execute([
                ':booking_date' => $date_str,
                ':dayname' => $day_name_ar,
                ':time_slot' => $slot[0],
                ':end_time' => $slot[1],
                ':room_id' => $room_id,
                ':typeservice' => $service_type,
                ':spclistsname' => $spclistsname,
                ':period' => $period,
                ':session_duration' => $session_duration,
                ':spesilstid' => $spesilstid,
                ':userupsated' => $userupsated,
            ]);
            $count++;
        }
    }

    echo "✅ تم إدخال {$count} فترة بنجاح للتواريخ المحددة.";
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>توليد الفترات المسائية لأيام محددة</title>
</head>
<body style="direction: rtl; font-family: Tahoma;">
    <h2>توليد الفترات المسائية لأيام مختارة</h2>
    <form method="POST">
        <label>تواريخ الجلسات (اختر أكثر من تاريخ):<br>
            <input type="date" name="dates[]" multiple required>
        </label><br><br>
        <label>رقم الغرفة: <input type="text" name="room_id" value="3211" required></label><br><br>
        <label>كود الجلسة: <input type="text" name="service_type" value="SLP" required></label><br><br>
        <label>الأخصائي: <input type="text" name="spclistsname" value="سما حلواني" required></label><br><br>
        <label>نوع الخدمة: <input type="text" name="period" value="OP1" required></label><br><br>
        <label>مدة الفترة: <input type="text" name="session_duration" value="60" readonly required></label><br><br>
        <label>رقم الأخصائي: <input type="text" name="spesilstid" value="14" required></label><br><br>
        <label>رقم مستخدم النظام: <input type="text" name="userupsated" value="1" readonly required></label><br><br>
        <button type="submit">توليد الفترات</button>
    </form>
</body>
</html>
