<?php
$host = "localhost:3306";
$dbname = "acesaudi_site";
$username = "acesaudi_usr";
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("فشل الاتصال بقاعدة البيانات: " . $e->getMessage());
}

$from = $_GET['from'] ?? date('Y-m-d');
$to = $_GET['to'] ?? date('Y-m-d', strtotime('+7 days'));
$total_session = intval($_GET['total_session'] ?? 1);
$roomno = $_GET['roomno'] ?? '';
$patientname = $_GET['patient_name'] ?? '';
$serviceedid = $_GET['serviceedid'] ?? '';
$patient = $_GET['patient_id'] ?? '';
$typeservice = $_GET['typeservice'] ?? '';
$spesilstid = $_GET['spesilstid'] ?? '';

$startTime = '12:00:00';
$endTime = '15:00:00';
$stmt = $pdo->prepare("SELECT * FROM bookings WHERE bookingstatus = 'متوفر' AND booking_date BETWEEN :from AND :to AND room_id = :roomno AND time_slot BETWEEN :start_time AND :end_time ORDER BY booking_date, time_slot");
$stmt->execute([
    ':from' => $from,
    ':to' => $to,
    ':roomno' => $roomno,
    ':start_time' => $startTime,
    ':end_time' => $endTime
]);
$slots = $stmt->fetchAll(PDO::FETCH_ASSOC);

$grouped_slots = [];
foreach ($slots as $slot) {
    $grouped_slots[$slot['booking_date']][] = $slot;
}
?>
<?php include 'sessionheaderrecption.php'; ?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
  <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">
      <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <title>تحديد الفترات</title>
    <style>
        body { font-family: Tahoma; background: #f0f0f0; }
        label, input { display: block; margin: 5px 0; direction: rtl; font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease; font-size: large; }
        .slots { margin: 15px 0; }
        .slot { background: #d4edda; padding: 10px; margin: 5px; border-radius: 5px; border: 1px solid #28a745; display: inline-block; }
        .slot input { margin-left: 5px; font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease; font-size: large; }
        button { padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; margin-top: 20px; }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">

<div class="wrapper">


<?php include 'receptionheader.php'; ?>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'receptionsidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenureception.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains ppatient_name content -->
  <div class="content-wrapper">
    <!-- Content Header (Ppatient_name header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="receptiondashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Search By Appoiment</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title" style="font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease;">Filtiration Appoiments Info - فلترة الفترات حسب التاريخ وعدد الجلسات</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">

            <div class="col-md-12" style="text-align: center;">

<h3 style="font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease;">فلترة الفترات حسب التاريخ وعدد الجلسات</h3>
<form method="GET">
     
    
     <div class="col-md-6">
      
      <div class="form-group">
          <label>  تاريخ الحجز إلى   </label>
  <input type="date" name="to" value="<?= htmlspecialchars($to) ?>" required class="form-control">
          </div>

     <div class="form-group">
          <label> المستفيد  </label>
  <input type="text" name="patient_name" value="<?= htmlspecialchars($patientname) ?>" required class="form-control" readonly>
          </div>

     <div class="form-group">
          <label> رقم ملف المستفيد  </label>
  <input type="text" name="patient_id" value="<?= htmlspecialchars($patient) ?>" required class="form-control" readonly>
          </div>

         <div class="form-group">
          <label> رقم الأخصائي  </label>
  <input type="text" name="spesilstid" value="<?= htmlspecialchars($spesilstid) ?>" required class="form-control" readonly>
          </div>

     </div>

     <div class="col-md-6">

          <div class="form-group">
          <label>  تاريخ الحجز من  </label>
  <input type="date" name="from" value="<?= htmlspecialchars($from) ?>" required class="form-control"> 
          </div>

          <div class="form-group">
          <label>  رقم الغرفة التي سوف يتم الحجز بها </label>
  <input type="text" name="roomno" value="<?= htmlspecialchars($roomno) ?>" required class="form-control" readonly> 
          </div>

           <div class="form-group">
          <label> رقم الخدمة  </label>
  <input type="text" name="serviceedid" value="<?= htmlspecialchars($serviceedid) ?>" required class="form-control" readonly>
          </div>

           <div class="form-group">
          <label> نوع الخدمة  </label>
  <input type="text" name="typeservice" value="<?= htmlspecialchars($typeservice) ?>" required class="form-control" readonly>
          </div>
     
     </div>

     <div class="col-md-12">
     <div class="from-group">
            <label> عدد الجلسات المطلوبة في نفس اليوم </label>
             <input type="number" name="total_session" value="<?= htmlspecialchars($total_session) ?>" min="1" required onchange="this.form.submit();" class="form-control">
     </div>
     </div>

</form>

<br>
<?php if ($total_session > 0 && !empty($grouped_slots)): ?>
<form method="POST" action="updatebookeavalutaion.php">
    <!-- معلومات مخفية لإرسالها -->
    <input type="hidden" name="session_duration" value="60">
    <input type="hidden" name="roomno" value="<?= htmlspecialchars($roomno) ?>">
    <input type="hidden" name="patient_name" value="<?= htmlspecialchars($patientname) ?>">
    <input type="hidden" name="serviceedid" value="<?= htmlspecialchars($serviceedid) ?>">
    <input type="hidden" name="patient_id" value="<?= htmlspecialchars($patient) ?>">
    <input type="hidden" name="typeservice" value="<?= htmlspecialchars($typeservice) ?>">
    <input type="hidden" name="spesilstid" value="<?= htmlspecialchars($spesilstid) ?>">

    <!-- جديد: إلى تاريخ لتكرار المواعيد -->
    <div class="form-group">
        <label>إلى تاريخ (تكرار المواعيد أسبوعيًا حتى هذا التاريخ)</label>
        <input type="date" name="to" required class="form-control" value="<?= htmlspecialchars($to) ?>">
    </div>

    <!-- عرض الفترات المتاحة -->
    <?php foreach ($grouped_slots as $date => $day_slots): ?>
        <?php if (count($day_slots) >= $total_session): ?>
            <br>
            <h4>📅 تاريخ: <?= $date ?> (عدد الفترات: <?= count($day_slots) ?>)</h4>
            <div class="slots">
                <?php for ($i = 0; $i < $total_session; $i++): 
                    $slot = $day_slots[$i]; ?>
                    <label class="slot">
                        <input type="checkbox" name="selected_slots[]" value="<?= $slot['id'] ?>">
                        ⏰ من <?= $slot['time_slot'] ?> إلى <?= $slot['end_time'] ?> |
                        🧑‍⚕️ الأخصائي: <?= htmlspecialchars($slot['spclistsname'] ?? '---') ?> |
                        🛠️ نوع الخدمة: <?= htmlspecialchars($slot['typeservice'] ?? '---') ?> |
                        🕐 نوع الفترة: <?= htmlspecialchars($slot['period'] ?? '---') ?>
                        
                        <!-- تمرير بيانات إضافية -->
                        <input type="hidden" name="slot_types[]" value="<?= htmlspecialchars($slot['typeservice'] ?? '') ?>">
                    </label>
                <?php endfor; ?>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>

    <button type="submit" class="btn btn-primary">✅ تأكيد الحجز وتكراره</button>
</form>


<?php else: ?>
    <p style="color:red;">⚠️ لا توجد فترات كافية متاحة حسب الفلترة المحددة</p>
<?php endif; ?>

</div>
</body>
</html>
