<?php
require 'vendor/autoload.php'; // استدعاء مكتبة PhpSpreadsheet
include('conn.php');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// إنشاء كائن ملف Excel
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// إعداد عنوان الأعمدة
$sheet->setCellValue('A1', 'رقم الموعد');
$sheet->setCellValue('B1', 'اسم المستفيد');
$sheet->setCellValue('C1', 'رقم الهوية');
$sheet->setCellValue('D1', 'الخدمة');
$sheet->setCellValue('E1', 'تاريخ الموعد');
$sheet->setCellValue('F1', 'الحالة');

// بناء شروط الفلترة
$where = [];

if (!empty($_GET['bookingid'])) {
    $bookingid = $conn->real_escape_string($_GET['bookingid']);
    $where[] = "`id` = '$bookingid'";
}

if (!empty($_GET['patient_name'])) {
    $patient_name = $conn->real_escape_string($_GET['patient_name']);
    $where[] = "`patient_name` LIKE '%$patient_name%'";
}

if (!empty($_GET['patient_id'])) {
    $patient_id = $conn->real_escape_string($_GET['patient_id']);
    $where[] = "`patient_id` = '$patient_id'";
}

if (!empty($_GET['typeservice'])) {
    $typeservice = $conn->real_escape_string($_GET['typeservice']);
    $where[] = "`typeservice` = '$typeservice'";
}

if (!empty($_GET['bookingstatus'])) {
    $bookingstatus = $conn->real_escape_string($_GET['bookingstatus']);
    $where[] = "`bookingstatus` = '$bookingstatus'";
}

if (!empty($_GET['from_date']) && !empty($_GET['to_date'])) {
    $from_date = $conn->real_escape_string($_GET['from_date']);
    $to_date = $conn->real_escape_string($_GET['to_date']);
    $where[] = "`booking_date` BETWEEN '$from_date' AND '$to_date'";
}

$where_sql = "";
if (!empty($where)) {
    $where_sql = "WHERE " . implode(" AND ", $where);
}

// جلب البيانات من قاعدة البيانات
$sql = "SELECT * FROM `bookings` $where_sql";
$result = mysqli_query($conn, $sql);

// تعبئة البيانات في الملف
$rowNumber = 2; // بدءاً من الصف الثاني لأن الأول للعناوين
while ($row = mysqli_fetch_assoc($result)) {
    $sheet->setCellValue('A' . $rowNumber, $row['id']);
    $sheet->setCellValue('B' . $rowNumber, $row['patient_name']);
    $sheet->setCellValue('C' . $rowNumber, $row['patient_id']);
    $sheet->setCellValue('D' . $rowNumber, $row['typeservice']);
    $sheet->setCellValue('E' . $rowNumber, $row['booking_date']);
    $sheet->setCellValue('F' . $rowNumber, $row['bookingstatus']);
    $rowNumber++;
}

// تنسيقات إضافية (اختياري لجعل الملف شكله أجمل)
$sheet->getStyle('A1:F1')->getFont()->setBold(true);
$sheet->getColumnDimension('B')->setWidth(20);
$sheet->getColumnDimension('D')->setWidth(15);
$sheet->getColumnDimension('E')->setWidth(15);
$sheet->getColumnDimension('F')->setWidth(15);

// تجهيز الملف للتحميل
$filename = 'bookings_export_' . date('Y-m-d_H-i-s') . '.xlsx';

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment;filename=\"$filename\"");
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');

mysqli_close($conn);
exit;
?>
