<?php
/**
 * export_insurance_companies.php
 * تصدير شركات التأمين إلى Excel (XLSX إن وُجد PhpSpreadsheet، وإلا XLS كـ HTML)
 * ضع هذا الملف منفصلاً واستدعه برابط/زر من صفحتك.
 * تأكد أن الملف محفوظ بصيغة UTF-8 "بدون BOM".
 */

mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
ob_start(); // منع أي إخراج مبكر

/* ===== إعدادات الاتصال ===== */
$DB_HOST = 'localhost:3306';
$DB_NAME = 'acesaudi_site';
$DB_USER = 'acesaudi_usr';
$DB_PASS = 'tabfyv-6xiFry-noczak';

$mysqli = @new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
if ($mysqli->connect_error) {
    // لا نطبع HTML؛ نُخرِج ملف نصي كرسالة خطأ قابلة للتحميل
    if (ob_get_length()) ob_end_clean();
    header('Content-Type: text/plain; charset=utf-8');
    header('Content-Disposition: attachment; filename="export_error.txt"');
    echo "DB connection error: " . $mysqli->connect_error;
    exit;
}
$mysqli->set_charset('utf8mb4');

/* ===== جلب البيانات ===== */
$sql = "SELECT 
            insurancecompanyid,
            insurancecompanyname,
            insurancecomarname,
            discount,
            regectedpercentage,
            earlypaypers,
            sizeworkpers,
            registreddate
        FROM insurancecompanies
        ORDER BY registreddate DESC";
$res = $mysqli->query($sql);
$data = [];
if ($res) {
    while ($r = $res->fetch_assoc()) $data[] = $r;
}
$mysqli->close();

/* ===== ترويسات الاسم ===== */
$filenameBase = 'insurance_companies_' . date('Y-m-d_His');

/* ===== محاولة استخدام PhpSpreadsheet ===== */
$hasPhpSpreadsheet = false;
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    require_once __DIR__ . '/vendor/autoload.php';
    $hasPhpSpreadsheet = class_exists(\PhpOffice\PhpSpreadsheet\Spreadsheet::class);
}

/* ===== أعمدة التصدير (العناوين) ===== */
$headers = [
    '#',
    'اسم الشركة بالإنجليزي',
    'اسم الشركة بالعربي',
    'نسبة الخصم',
    'نسبة الرفض',
    'نسبة الدفع المبكر',
    'نسبة حجم العمل',
    'تاريخ التسجيل',
];

/* =========================================================
 *            خيار 1: XLSX عبر PhpSpreadsheet
 * ========================================================= */
if ($hasPhpSpreadsheet) {
    if (ob_get_length()) ob_end_clean();

    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setTitle('Insurance Companies');

    // كتابة العناوين
    $col = 1;
    foreach ($headers as $h) {
        $sheet->setCellValueByColumnAndRow($col, 1, $h);
        $col++;
    }
    $sheet->getStyle('A1:H1')->getFont()->setBold(true);

    // كتابة البيانات
    $rowIndex = 2;
    foreach ($data as $row) {
        $c = 1;
        $sheet->setCellValueByColumnAndRow($c++, $rowIndex, (int)$row['insurancecompanyid']);
        $sheet->setCellValueByColumnAndRow($c++, $rowIndex, (string)$row['insurancecompanyname']);
        $sheet->setCellValueByColumnAndRow($c++, $rowIndex, (string)$row['insurancecomarname']);
        // القيم الرقمية تُكتب كأرقام
        $sheet->setCellValueByColumnAndRow($c++, $rowIndex, is_numeric($row['discount']) ? (float)$row['discount'] : $row['discount']);
        $sheet->setCellValueByColumnAndRow($c++, $rowIndex, is_numeric($row['regectedpercentage']) ? (float)$row['regectedpercentage'] : $row['regectedpercentage']);
        $sheet->setCellValueByColumnAndRow($c++, $rowIndex, is_numeric($row['earlypaypers']) ? (float)$row['earlypaypers'] : $row['earlypaypers']);
        $sheet->setCellValueByColumnAndRow($c++, $rowIndex, is_numeric($row['sizeworkpers']) ? (float)$row['sizeworkpers'] : $row['sizeworkpers']);
        $sheet->setCellValueByColumnAndRow($c++, $rowIndex, (string)$row['registreddate']);
        $rowIndex++;
    }

    // عرض الأعمدة تلقائياً
    foreach (range('A','H') as $colLtr) {
        $sheet->getColumnDimension($colLtr)->setAutoSize(true);
    }

    // إخراج الملف
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; charset=utf-8');
    header('Content-Disposition: attachment; filename="'. $filenameBase .'.xlsx"');
    header('Cache-Control: max-age=0');

    $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
    $writer->save('php://output');
    exit;
}

/* =========================================================
 *          خيار 2: Fallback — XLS كجدول HTML
 * ========================================================= */
if (ob_get_length()) ob_end_clean();
header('Content-Type: application/vnd.ms-excel; charset=utf-8');
header('Content-Disposition: attachment; filename="'. $filenameBase .'.xls"');

echo "<meta http-equiv='Content-Type' content='text/html; charset=utf-8' />";
echo "<table border='1' style='text-align:center; font-family:Tahoma; border-collapse:collapse;'>";

// العناوين
echo "<tr>";
foreach ($headers as $h) {
    echo "<th style='font-weight:bold; padding:6px;'>", htmlspecialchars($h, ENT_QUOTES, 'UTF-8') ,"</th>";
}
echo "</tr>";

// البيانات
foreach ($data as $row) {
    echo "<tr>";
    echo "<td>", (int)$row['insurancecompanyid'] ,"</td>";
    echo "<td>", htmlspecialchars($row['insurancecompanyname'] ?? '', ENT_QUOTES, 'UTF-8') ,"</td>";
    echo "<td>", htmlspecialchars($row['insurancecomarname'] ?? '', ENT_QUOTES, 'UTF-8') ,"</td>";
    echo "<td>", htmlspecialchars((string)$row['discount'] ?? '', ENT_QUOTES, 'UTF-8') ,"</td>";
    echo "<td>", htmlspecialchars((string)$row['regectedpercentage'] ?? '', ENT_QUOTES, 'UTF-8') ,"</td>";
    echo "<td>", htmlspecialchars((string)$row['earlypaypers'] ?? '', ENT_QUOTES, 'UTF-8') ,"</td>";
    echo "<td>", htmlspecialchars((string)$row['sizeworkpers'] ?? '', ENT_QUOTES, 'UTF-8') ,"</td>";
    echo "<td>", htmlspecialchars($row['registreddate'] ?? '', ENT_QUOTES, 'UTF-8') ,"</td>";
    echo "</tr>";
}
echo "</table>";
exit;
