<?php
header('Content-Type: application/json');

// إعداد الاتصال بقاعدة البيانات
$host = 'localhost:3306';
$db   = 'acesaudi_site';
$user = 'acesaudi_usr';
$pass = 'tabfyv-6xiFry-noczak';
$charset = 'utf8mb4';

// الاتصال
$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    echo json_encode(['error' => 'فشل الاتصال بقاعدة البيانات']);
    exit;
}

// جلب المواعيد
$patient_id = isset($_GET['patient_id']) ? $_GET['patient_id'] : '';

$sql = "SELECT * FROM bookings";
$params = [];

if (!empty($patient_id)) {
    $sql .= " WHERE patient_id = ?";
    $params[] = $patient_id;
}

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$appointments = $stmt->fetchAll();

$events = [];

foreach ($appointments as $app) {
    // تحويل التاريخ والوقت إلى تنسيق datetime لـ FullCalendar
    $start = $app['booking_date'] . ' ' . $app['time_slot'];
    $end = $app['booking_date'] . ' ' . $app['end_time'];

    $events[] = [
        'id' => $app['id'],
        'title' => $app['id'],
        'start' => $start,
        'end' => $end,
        'room_id' => $app['room_id'],
        'patient_id' => $app['patient_id'],
        'typeservice' => $app['typeservice']
    ];
}

echo json_encode($events);