<?php
// ====== إعدادات الاتصال ======
$host     = 'localhost:3306';
$dbname   = 'acesaudi_site';
$username = 'acesaudi_usr';
$password = 'tabfyv-6xiFry-noczak';
$prefix   = 'uiUJBF2e_'; // غيّره لو اختلف

// اتصال PDO
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
} catch (PDOException $e) {
    die("فشل الاتصال: " . $e->getMessage());
}

// ====== Helpers ======
function h($v){ return htmlspecialchars((string)($v ?? ''), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }

function mapStatusAr($st){
    static $m = [
        'wc-pending'    => 'بانتظار الدفع',
        'wc-processing' => 'تحت المعالجة',
        'wc-on-hold'    => 'قيد الانتظار',
        'wc-completed'  => 'مكتمل',
        'wc-cancelled'  => 'ملغي',
        'wc-refunded'   => 'مسترد',
        'wc-failed'     => 'فشل',
    ];
    return $m[$st] ?? $st;
}

// تجميع تفاصيل المنتجات (اسم، SKU، كمية، إجماليات)
function getProductDetails(PDO $pdo, $prefix, $order_id){
    $sql = "
        SELECT oi.order_item_id, oi.order_item_name,
               MAX(CASE WHEN oim.meta_key = '_product_id' THEN oim.meta_value END)    AS product_id,
               MAX(CASE WHEN oim.meta_key = '_variation_id' THEN oim.meta_value END)  AS variation_id,
               MAX(CASE WHEN oim.meta_key = '_qty' THEN oim.meta_value END)           AS quantity,
               MAX(CASE WHEN oim.meta_key = '_line_total' THEN oim.meta_value END)    AS line_total,
               MAX(CASE WHEN oim.meta_key = '_line_tax' THEN oim.meta_value END)      AS line_tax,
               MAX(CASE WHEN oim.meta_key = '_line_subtotal' THEN oim.meta_value END) AS line_subtotal
        FROM {$prefix}woocommerce_order_items oi
        LEFT JOIN {$prefix}woocommerce_order_itemmeta oim
               ON oi.order_item_id = oim.order_item_id
        WHERE oi.order_id = ?
          AND oi.order_item_type = 'line_item'
        GROUP BY oi.order_item_id
        ORDER BY oi.order_item_id ASC
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$order_id]);
    $items = $stmt->fetchAll();

    $out = '';
    foreach ($items as $it) {
        $pid = (int)$it['product_id'];
        $vid = (int)$it['variation_id'];
        $sku = '';

        if ($vid > 0) {
            $skuStmt = $pdo->prepare("SELECT meta_value FROM {$prefix}postmeta WHERE post_id = ? AND meta_key = '_sku' LIMIT 1");
            $skuStmt->execute([$vid]);
            $sku = (string)$skuStmt->fetchColumn();
        }
        if ($sku === '' && $pid > 0) {
            $skuStmt = $pdo->prepare("SELECT meta_value FROM {$prefix}postmeta WHERE post_id = ? AND meta_key = '_sku' LIMIT 1");
            $skuStmt->execute([$pid]);
            $sku = (string)$skuStmt->fetchColumn();
        }

        $name     = $it['order_item_name'];
        $qty      = (int)$it['quantity'];
        $lt       = (float)$it['line_total'];
        $ltax     = (float)$it['line_tax'];
        $subtotal = (float)$it['line_subtotal'];

        $out .= h($name) .
                ($sku ? " <small>(SKU: ".h($sku).")</small>" : "") .
                " × " . h($qty) .
                " — صافي: " . number_format($subtotal, 2) .
                " — إجمالي: " . number_format($lt + $ltax, 2) .
                " ريال<br>";
    }
    return $out ?: '—';
}

function getCoupons(PDO $pdo, $prefix, $order_id){
    $sql = "
        SELECT oi.order_item_name AS coupon_code,
               MAX(CASE WHEN oim.meta_key = 'discount_amount' OR oim.meta_key = '_discount_amount'
                        THEN oim.meta_value END) AS amount
        FROM {$prefix}woocommerce_order_items oi
        LEFT JOIN {$prefix}woocommerce_order_itemmeta oim
               ON oi.order_item_id = oim.order_item_id
        WHERE oi.order_id = ? AND oi.order_item_type = 'coupon'
        GROUP BY oi.order_item_id
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$order_id]);
    $rows = $stmt->fetchAll();

    if (!$rows) return '—';
    $parts = [];
    foreach ($rows as $r) {
        $parts[] = h($r['coupon_code']) . ': ' . number_format((float)$r['amount'], 2) . ' ريال';
    }
    return implode('<br>', $parts);
}

function getShippingMethod(PDO $pdo, $prefix, $order_id){
    $sql = "
        SELECT oi.order_item_name AS method_title,
               MAX(CASE WHEN oim.meta_key = 'cost' OR oim.meta_key = 'total' OR oim.meta_key = '_cost'
                        THEN oim.meta_value END) AS cost
        FROM {$prefix}woocommerce_order_items oi
        LEFT JOIN {$prefix}woocommerce_order_itemmeta oim
               ON oi.order_item_id = oim.order_item_id
        WHERE oi.order_id = ? AND oi.order_item_type = 'shipping'
        GROUP BY oi.order_item_id
        ORDER BY oi.order_item_id ASC
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$order_id]);
    $rows = $stmt->fetchAll();

    if (!$rows) return '—';
    $parts = [];
    foreach ($rows as $r) {
        $label = h($r['method_title']);
        $cost  = number_format((float)$r['cost'], 2);
        $parts[] = "{$label} — {$cost} ريال";
    }
    return implode('<br>', $parts);
}

// ====== قراءة فلاتر الطلب ======
$date_from    = $_GET['date_from'] ?? '';
$date_to      = $_GET['date_to']   ?? '';
$order_status = $_GET['status']    ?? '';
$search       = trim($_GET['search'] ?? '');
$export       = isset($_GET['export']);

// ====== بناء شرط WHERE ديناميكي ======
$where  = "WHERE p.post_type = 'shop_order'";
$params = [];

// التاريخ
if ($date_from && $date_to) {
    $where   .= " AND DATE(p.post_date) BETWEEN ? AND ?";
    $params[] = $date_from;
    $params[] = $date_to;
}

// الحالة
if ($order_status) {
    $where   .= " AND p.post_status = ?";
    $params[] = $order_status;
}

// البحث العام
if ($search !== '') {
    $clauses = [];
    if (ctype_digit($search)) {
        $clauses[] = "p.ID = ?";
        $params[]  = (int)$search;
    }
    $clauses[] = "EXISTS (
        SELECT 1 FROM {$prefix}postmeta pm1
        WHERE pm1.post_id = p.ID
          AND pm1.meta_key IN ('_billing_first_name','_billing_last_name','_billing_email','_billing_phone','_transaction_id')
          AND pm1.meta_value LIKE ?
    )";
    $params[] = "%{$search}%";

    $clauses[] = "EXISTS (
        SELECT 1 FROM {$prefix}woocommerce_order_items oi
        WHERE oi.order_id = p.ID
          AND oi.order_item_type = 'line_item'
          AND oi.order_item_name LIKE ?
    )";
    $params[] = "%{$search}%";

    $where .= " AND (" . implode(" OR ", $clauses) . ")";
}

/* ====== الاستعلام الرئيسي مع عمودين جديدين ======
   before_tax: SUM(_line_total) — سلع قبل الضريبة (وبعد الخصم)
   items_tax : SUM(_line_tax)   — ضريبة السلع فقط
*/
$sql = "
SELECT
    p.ID AS order_id,
    p.post_date,
    p.post_status,

    MAX(CASE WHEN pm.meta_key = '_customer_user'          THEN pm.meta_value END) AS customer_id,

    MAX(CASE WHEN pm.meta_key = '_billing_first_name'     THEN pm.meta_value END) AS billing_first_name,
    MAX(CASE WHEN pm.meta_key = '_billing_last_name'      THEN pm.meta_value END) AS billing_last_name,
    MAX(CASE WHEN pm.meta_key = '_billing_email'          THEN pm.meta_value END) AS billing_email,
    MAX(CASE WHEN pm.meta_key = '_billing_phone'          THEN pm.meta_value END) AS billing_phone,
    MAX(CASE WHEN pm.meta_key = '_billing_company'        THEN pm.meta_value END) AS billing_company,
    MAX(CASE WHEN pm.meta_key = '_billing_address_1'      THEN pm.meta_value END) AS billing_address_1,
    MAX(CASE WHEN pm.meta_key = '_billing_address_2'      THEN pm.meta_value END) AS billing_address_2,
    MAX(CASE WHEN pm.meta_key = '_billing_city'           THEN pm.meta_value END) AS billing_city,
    MAX(CASE WHEN pm.meta_key = '_billing_state'          THEN pm.meta_value END) AS billing_state,
    MAX(CASE WHEN pm.meta_key = '_billing_postcode'       THEN pm.meta_value END) AS billing_postcode,
    MAX(CASE WHEN pm.meta_key = '_billing_country'        THEN pm.meta_value END) AS billing_country,

    MAX(CASE WHEN pm.meta_key = '_shipping_first_name'    THEN pm.meta_value END) AS shipping_first_name,
    MAX(CASE WHEN pm.meta_key = '_shipping_last_name'     THEN pm.meta_value END) AS shipping_last_name,
    MAX(CASE WHEN pm.meta_key = '_shipping_company'       THEN pm.meta_value END) AS shipping_company,
    MAX(CASE WHEN pm.meta_key = '_shipping_address_1'     THEN pm.meta_value END) AS shipping_address_1,
    MAX(CASE WHEN pm.meta_key = '_shipping_address_2'     THEN pm.meta_value END) AS shipping_address_2,
    MAX(CASE WHEN pm.meta_key = '_shipping_city'          THEN pm.meta_value END) AS shipping_city,
    MAX(CASE WHEN pm.meta_key = '_shipping_state'         THEN pm.meta_value END) AS shipping_state,
    MAX(CASE WHEN pm.meta_key = '_shipping_postcode'      THEN pm.meta_value END) AS shipping_postcode,
    MAX(CASE WHEN pm.meta_key = '_shipping_country'       THEN pm.meta_value END) AS shipping_country,

    MAX(CASE WHEN pm.meta_key = '_payment_method'         THEN pm.meta_value END) AS payment_method,
    MAX(CASE WHEN pm.meta_key = '_payment_method_title'   THEN pm.meta_value END) AS payment_method_title,
    MAX(CASE WHEN pm.meta_key = '_transaction_id'         THEN pm.meta_value END) AS transaction_id,

    MAX(CASE WHEN pm.meta_key = '_order_currency'         THEN pm.meta_value END) AS currency,
    MAX(CASE WHEN pm.meta_key = '_cart_discount'          THEN pm.meta_value END) AS discount_total,
    MAX(CASE WHEN pm.meta_key = '_cart_discount_tax'      THEN pm.meta_value END) AS discount_tax,
    MAX(CASE WHEN pm.meta_key = '_order_tax'              THEN pm.meta_value END) AS tax_total,
    MAX(CASE WHEN pm.meta_key = '_order_shipping'         THEN pm.meta_value END) AS shipping_total,
    MAX(CASE WHEN pm.meta_key = '_order_shipping_tax'     THEN pm.meta_value END) AS shipping_tax,
    MAX(CASE WHEN pm.meta_key = '_order_total'            THEN pm.meta_value END) AS order_total,

    COALESCE(items.before_tax, 0) AS amount_before_tax,  -- (جديد) المبلغ قبل الضريبة للسلع
    COALESCE(items.items_tax, 0)  AS items_tax           -- (جديد) ضريبة السلع فقط

FROM {$prefix}posts p
LEFT JOIN {$prefix}postmeta pm ON p.ID = pm.post_id

/* تجميع بنود الطلب لحساب المبالغ قبل الضريبة وضريبة السلع */
LEFT JOIN (
    SELECT 
        oi.order_id,
        SUM(
            CASE WHEN oim.meta_key = '_line_total' 
            THEN CAST(oim.meta_value AS DECIMAL(20,6)) ELSE 0 END
        ) AS before_tax,
        SUM(
            CASE WHEN oim.meta_key = '_line_tax' 
            THEN CAST(oim.meta_value AS DECIMAL(20,6)) ELSE 0 END
        ) AS items_tax
    FROM {$prefix}woocommerce_order_items oi
    LEFT JOIN {$prefix}woocommerce_order_itemmeta oim
           ON oi.order_item_id = oim.order_item_id
    WHERE oi.order_item_type = 'line_item'
    GROUP BY oi.order_id
) AS items ON items.order_id = p.ID

{$where}
GROUP BY p.ID
ORDER BY p.ID DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$orders = $stmt->fetchAll();

// ====== تصدير Excel (HTML table) ======
if ($export) {
    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
    header('Content-Disposition: attachment; filename="orders_export.xls"');

    echo "<table border='1' style='text-align:center; font-family:Tahoma;'>";
    echo "<tr>
            <th>رقم الطلب</th>
            <th>تاريخ الطلب</th>
            <th>الحالة</th>
            <th>العميل</th>
            <th>الإيميل</th>
            <th>الجوال</th>
            <th>وسيلة الدفع</th>

            <th>المبلغ قبل الضريبة (سلع)</th>   <!-- جديد -->
            <th>الضريبة (سلع + شحن)</th>        <!-- جديد -->

            <th>الخصم</th>
            <th>ضريبة الشحن</th>
            <th>الضريبة</th>
            <th>الشحن</th>
            <th>الإجمالي</th>
            <th>طريقة الشحن</th>
            <th>الكوبونات</th>
            <th>تفاصيل المنتجات</th>
            <th>رابط الفاتورة</th>
          </tr>";

    foreach ($orders as $o) {
        $order_id = (int)$o['order_id'];
        $products = getProductDetails($pdo, $prefix, $order_id);
        $coupons  = getCoupons($pdo, $prefix, $order_id);
        $shipMet  = getShippingMethod($pdo, $prefix, $order_id);

        $amount_before_tax = (float)$o['amount_before_tax'];       // SUM(_line_total)
        $tax_sum           = (float)$o['items_tax'] + (float)$o['shipping_tax']; // ضريبة السلع + الشحن

        $host = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'];
        $invoice_link = "<a href='{$host}/wp-admin/post.php?post={$order_id}&action=edit' target='_blank'>عرض</a>";

        echo "<tr>
                <td>".h($order_id)."</td>
                <td>".h($o['post_date'])."</td>
                <td>".h(mapStatusAr($o['post_status']))."</td>
                <td>".h($o['billing_first_name'].' '.$o['billing_last_name'])."</td>
                <td>".h($o['billing_email'])."</td>
                <td>".h($o['billing_phone'])."</td>
                <td>".h($o['payment_method_title'] ?: $o['payment_method'])."</td>

                <td>".number_format($amount_before_tax, 2)."</td>
                <td>".number_format($tax_sum, 2)."</td>

                <td>".number_format((float)$o['discount_total'], 2)."</td>
                <td>".number_format((float)$o['shipping_tax'], 2)."</td>
                <td>".number_format((float)$o['tax_total'], 2)."</td>
                <td>".number_format((float)$o['shipping_total'], 2)."</td>
                <td>".number_format((float)$o['order_total'], 2)."</td>
                <td>{$shipMet}</td>
                <td>{$coupons}</td>
                <td>{$products}</td>
                <td>{$invoice_link}</td>
              </tr>";
    }
    echo "</table>";
    exit;
}

// ====== عرض HTML عادي (بدون تصدير) ======
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | Dashboard</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <?php include 'financeheader.php'; ?>
  <aside class="main-sidebar">
    <section class="sidebar">
      <?php include 'financesidepanle.php'; ?>
      <?php include 'searchform.php'; ?>
      <?php include 'navemenufinance.php'; ?>
    </section>
  </aside>

  <div class="content-wrapper">
    <section class="content-header">
      <h1><small></small></h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Websites Report Payment</a></li>
      </ol>
    </section>

    <section class="content">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Websites Report Payment Info Center</h3>
          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" title="Collapse"><i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" title="Remove"><i class="fa fa-times"></i></button>
          </div>
        </div>

        <div class="box-body">
          <div class="box">
            <div class="box-header"><h3 class="box-title"></h3></div>
            <div class="box-body">

<form method="get" style="margin-bottom:15px;text-align:center;">
  <label>من</label> <input type="date" name="date_from" value="<?= h($date_from) ?>" class="form-control">
  <label>إلى</label> <input type="date" name="date_to" value="<?= h($date_to) ?>" class="form-control">
  <label>الحالة</label>
  <select name="status" class="form-control">
      <option value="">الكل</option>
      <option value="wc-pending"    <?= $order_status==='wc-pending'?'selected':''; ?>>بانتظار الدفع</option>
      <option value="wc-processing" <?= $order_status==='wc-processing'?'selected':''; ?>>تحت المعالجة</option>
      <option value="wc-on-hold"    <?= $order_status==='wc-on-hold'?'selected':''; ?>>قيد الانتظار</option>
      <option value="wc-completed"  <?= $order_status==='wc-completed'?'selected':''; ?>>مكتمل</option>
      <option value="wc-cancelled"  <?= $order_status==='wc-cancelled'?'selected':''; ?>>ملغي</option>
      <option value="wc-refunded"   <?= $order_status==='wc-refunded'?'selected':''; ?>>مسترد</option>
      <option value="wc-failed"     <?= $order_status==='wc-failed'?'selected':''; ?>>فشل</option>
  </select>
  <label>بحث</label> <input type="text" name="search" placeholder="رقم الطلب / اسم / إيميل / منتج / Transaction" value="<?= h($search) ?>" class="form-control"><br>
  <button type="submit" class="btn btn-block btn-primary">تصفية</button> <br>
  <button type="submit" name="export" value="1" class="btn btn-block btn-success">تصدير Excel</button>
</form>

<table class="table table-bordered" style="text-align:center;">
  <thead>
    <tr>
      <th>رقم</th>
      <th>تاريخ</th>
      <th>الحالة</th>
      <th>العميل</th>
      <th>الإيميل</th>
      <th>الجوال</th>
      <th>الدفع</th>

      <th>المبلغ قبل الضريبة</th>  <!-- جديد -->
      <th>الضريبة</th>       <!-- جديد -->

      <th>الخصم</th>
      <th>ضريبة الشحن</th>
      <th>الضريبة</th>
      <th>الإجمالي</th>
      <th>كود الخصم</th>
      <th>المنتج</th>
    </tr>
  </thead>
  <tbody>
  <?php if(!$orders): ?>
    <tr><td colspan="15" style="text-align:center;">لا توجد نتائج.</td></tr>
  <?php else: foreach($orders as $o):
        $order_id          = (int)$o['order_id'];
        $products          = getProductDetails($pdo, $prefix, $order_id);
        $coupons           = getCoupons($pdo, $prefix, $order_id);
        $amount_before_tax = (float)$o['amount_before_tax'];                   // SUM(_line_total)
        $tax_sum           = (float)$o['items_tax'] + (float)$o['shipping_tax']; // ضريبة السلع + الشحن
  ?>
    <tr>
      <td><?= h($order_id) ?></td>
      <td><?= h($o['post_date']) ?></td>
      <td><?= h(mapStatusAr($o['post_status'])) ?></td>
      <td><?= h($o['billing_first_name'].' '.$o['billing_last_name']) ?></td>
      <td><?= h($o['billing_email']) ?></td>
      <td><?= h($o['billing_phone']) ?></td>
      <td><?= h($o['payment_method_title'] ?: $o['payment_method']) ?></td>

      <td><?= number_format($amount_before_tax, 2) ?></td>
      <td><?= number_format($tax_sum, 2) ?></td>

      <td><?= number_format((float)$o['discount_total'], 2) ?></td>
      <td><?= number_format((float)$o['shipping_tax'], 2) ?></td>
      <td><?= number_format((float)$o['tax_total'], 2) ?></td>
      <td><?= number_format((float)$o['order_total'], 2) ?></td>
      <td><?= $coupons ?></td>
      <td><?= $products ?></td>
    </tr>
  <?php endforeach; endif; ?>
  </tbody>
</table>

</div></div></div>
        <div class="box-footer"></div>
      </div>
    </section>
  </div>

  <?php include 'footer.php'; ?>

  <aside class="control-sidebar control-sidebar-dark">
    <div class="tab-content">
      <div class="tab-pane" id="control-sidebar-home-tab"></div>
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <div class="tab-pane" id="control-sidebar-settings-tab"></div>
    </div>
  </aside>
  <div class="control-sidebar-bg"></div>
</div>

<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<script src="bootstrap/js/bootstrap.min.js"></script>
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<script src="plugins/fastclick/fastclick.js"></script>
<script src="dist/js/app.min.js"></script>
<script src="dist/js/demo.js"></script>
</body>
</html>
