<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | CRM</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

<?php include 'financeheader.php'; ?>
 
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'financesidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenufinance.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Customers</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Filter Payments Transctions</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
             
            <?php
// ====== اتصال PDO (يُنشأ فقط إذا لم يكن موجودًا) ======
if (!isset($pdo) || !($pdo instanceof PDO)) {
    $db_host = 'localhost:3306';
    $db_name = 'acesaudi_site';   // ← غيّرها عند الحاجة
    $db_user = 'acesaudi_usr';
    $db_pass = 'tabfyv-6xiFry-noczak';
    $charset = 'utf8mb4';

    $dsn = "mysql:host=$db_host;dbname=$db_name;charset=$charset";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];
    try { $pdo = new PDO($dsn, $db_user, $db_pass, $options); }
    catch (PDOException $e) { die('خطأ اتصال: '.htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8')); }
}

// ====== التقاط مدخلات الفلترة ======
$customerid = isset($_GET['customerid']) ? trim($_GET['customerid']) : '';
$from       = isset($_GET['from'])       ? trim($_GET['from'])       : '';
$to         = isset($_GET['to'])         ? trim($_GET['to'])         : '';
$status     = isset($_GET['status'])     ? trim($_GET['status'])     : ''; // NEW

$where  = [];
$params = [];

// رقم الهوية (تطابق تام؛ لو تريده جزئيًا استخدم LIKE كما هو موضح أدناه)
if ($customerid !== '') {
    $where[] = 'customerid = :customerid';
    $params[':customerid'] = $customerid;
}

// التاريخ
if ($from !== '' && $to !== '') {
    $where[] = 'dateschauled BETWEEN :from AND :to';
    $params[':from'] = $from;
    $params[':to']   = $to;
} elseif ($from !== '') {
    $where[] = 'dateschauled >= :from';
    $params[':from'] = $from;
} elseif ($to !== '') {
    $where[] = 'dateschauled <= :to';
    $params[':to'] = $to;
}

// حالة الدفع (تجاهل لو "all" أو فارغة)
if ($status !== '' && $status !== 'all') {
    $where[] = 'payment_status = :status';
    $params[':status'] = $status;
}

$whereSql = $where ? 'WHERE '.implode(' AND ', $where) : '';

// جلب الحالات المتاحة لبناء القائمة ديناميكيًا
$statuses = [];
try {
    $statuses = $pdo->query("SELECT DISTINCT payment_status FROM installments ORDER BY payment_status")
                    ->fetchAll(PDO::FETCH_COLUMN);
} catch (Throwable $e) {
    // تجاهل الخطأ؛ سيتم إظهار القائمة بثلاثة خيارات أساسية
}

// ====== الاستعلام ======
$sql = "
    SELECT id, customerid, serviceid, typeservice, installmentamount, userschauled, dateschauled, payment_status, fileid
    FROM installments
    $whereSql
    ORDER BY dateschauled DESC, id DESC
";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

// مجموع المبالغ
$sum = 0.0;
foreach ($rows as $r) { $sum += (float)$r['installmentamount']; }

// دالة هروب
function e($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
?>

<!-- ====== نموذج الفلترة ====== -->
<form method="get" class="form-inline" style="padding:15px; gap:10px;">
  <div class="form-group" style="margin-inline-end:10px">
    <label>رقم هوية المستفيد</label>
    <input type="text" name="customerid" value="<?= e($customerid) ?>" class="form-control" style="margin:0 10px;">
  </div>

  <div class="form-group" style="margin-inline-end:10px">
    <label>من تاريخ</label>
    <input type="date" name="from" value="<?= e($from) ?>" class="form-control" style="margin:0 10px;">
  </div>

  <div class="form-group" style="margin-inline-end:10px">
    <label>إلى تاريخ</label>
    <input type="date" name="to" value="<?= e($to) ?>" class="form-control" style="margin:0 10px;">
  </div>

  <div class="form-group" style="margin-inline-end:10px">
    <label>حالة الدفع</label>
    <select name="status" class="form-control" style="margin:0 10px; min-width:160px">
      <option value="all" <?= ($status==='' || $status==='all') ? 'selected' : '' ?>>جميع الحالات</option>
      <?php if ($statuses): ?>
        <?php foreach ($statuses as $st): ?>
          <option value="<?= e($st) ?>" <?= ($status === $st) ? 'selected' : '' ?>><?= e($st) ?></option>
        <?php endforeach; ?>
      <?php else: ?>
        <!-- fallback افتراضي لو فشل جلب الحالات -->
        <option value="مدفوع" <?= ($status==='مدفوع') ? 'selected' : '' ?>>مدفوع</option>
        <option value="غير مدفوع" <?= ($status==='غير مدفوع') ? 'selected' : '' ?>>غير مدفوع</option>
      <?php endif; ?>
    </select>
  </div>

  <button type="submit" class="btn btn-primary">بحث</button>
  <a href="<?= e(strtok($_SERVER['REQUEST_URI'],'?')) ?>" class="btn btn-default">تفريغ</a>
</form>

<?php if (empty($rows)): ?>
  <div class="callout callout-info" style="margin:15px">لا توجد نتائج مطابقة</div>
<?php else: ?>
  <div class="box-body table-responsive no-padding">
    <table class="table table-hover table-striped">
      <thead>
        <tr>
          <th>#</th>
          <th>customerid</th>
          <th>serviceid</th>
          <th>type service</th>
          <th style="text-align:right">installmentamount</th>
          <th>userschauled</th>
          <th>dateschauled</th>
          <th>payment status</th>
          <th>fileid</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $i => $r): ?>
          <tr>
            <td><?= $i+1 ?></td>
            <td><?= e($r['customerid']) ?></td>
            <td><?= e($r['serviceid']) ?></td>
            <td><?= e($r['typeservice']) ?></td>
            <td style="text-align:right"><?= number_format((float)$r['installmentamount'], 2) ?></td>
            <td><?= e($r['userschauled']) ?></td>
            <td><?= e($r['dateschauled']) ?></td>
            <td><?= e($r['payment_status']) ?></td>
            <td><?= e($r['fileid']) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
      <tfoot>
        <tr>
          <td colspan="3" style="text-align:left"><b>الإجمالي</b></td>
          <td style="text-align:right"><b><?= number_format($sum, 2) ?></b></td>
          <td colspan="4"></td>
        </tr>
      </tfoot>
    </table>
  </div>
<?php endif; ?>
           
            <!-- /.box-body -->
          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
