<?php
require_once('tcpdf/tcpdf.php');
include('conn.php');

if (!isset($_GET['idinvoice'])) {
    die("رقم الفاتورة غير موجود");
}

$idinvoice = $_GET['idinvoice'];

// استعلام الفاتورة
$sql = "SELECT * FROM qrcode WHERE idinvoice = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $idinvoice);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("الفاتورة غير موجودة");
}

$row = $result->fetch_assoc();

// تعيين بعض القيم الافتراضية
$customer_name = $row['userconfirmed'] ?? 'غير معروف';
$idcustomer = $row['idcustomer'] ??  'غير معروف';
$mobile = '966555814481'; // مثال
$branch_address_ar = "مدينة الرياض - حي العريجاء - شارع عمر بن العاص";
$branch_address_en = "Riyadh City - Olisha Area - Amro Ibn AlAas Street";
$tel = "920011452";
$vat_no = "310475033200003";
$product = "خدمة البرامج التأهيلية المكثفة";
$register_date = date("Y-m-d", strtotime($row['timeadded']));

// إنشاء PDF
$pdf = new TCPDF();
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetTitle("فاتورة رقم {$row['idinvoice']}");
$pdf->SetHeaderMargin(0);
$pdf->SetTopMargin(10);
$pdf->SetFooterMargin(0);
$pdf->SetAutoPageBreak(TRUE, 10);
$pdf->AddPage();
$pdf->SetFont('aealarabiya', '', 14);

// HTML تصميم الفاتورة
$html = '
<style>
body{ height: 10in; }
td { border: 1px solid #ccc; padding: 6px; }
th { background-color: #eee; padding: 6px; }
</style>

<table border="0" width="100%">
<tr>
  <td colspan="2" align="left" style="text-align:center;">
  <h6>Autism Center Of Excellence</h6>
  <h6>Kingdom of Saudi Arabia</h6>
  <h6> TEL: 920011452</h6>
  <h6>Web site : www.acesaudi.org</h6>
  <h6>E-mail : info@acesaudi.org</h6>
  </td>
  <td colspan="2"><img src="invoicelogo.png" width="150" /></td>
  <td colspan="2" align="right">
    <h6>مركز التميز للتوحد</h6>
    <h6>المملكة العربية السعودية</h6>
    <h6> هاتف : 920011452</h6>
  <h6>الموقع الألكتروني : www.acesaudi.org</h6>
  <h6>الأيميل: info@acesaudi.org</h6>
  </td>
</tr>
<tr style="text-align:center;"><td colspan="6" align="center"><h5 style="text-align:center;">الفاتورة الإلكترونية للضريبة - E-Invoice VAT</h5></td></tr>

<tr>
  <td colspan="2"><strong>العميل - Customer Name</strong></td><td colspan="2">' . $customer_name . '</td>
  <td colspan="2"><strong>رقم هوية العميل - Customer ID</strong></td><td colspan="2">' . $idcustomer . '</td>
</tr>
<tr>
  <td colspan="2"><strong>رقم الجوال - Mobile</strong></td><td>' . $mobile . '</td>
  <td colspan="2"><strong>رقم الفاتورة - Invoice NO</strong></td><td>' . $row['idinvoice'] . '</td>
</tr>
<tr>
  <td colspan="2"><strong>تاريخ ووقت الفاتورة - Date Of Invoice</strong></td><td>' . $register_date . '</td>
  <td colspan="2"><strong>عنوان الفرع - Address Branch</strong></td><td>' . $branch_address_en . '</td>
</tr>
<tr>
  <td><strong>الهاتف - TEL</strong></td><td>' . $tel . '</td>
  <td><strong>الرقم الضريبي - VAT NO</strong></td><td>' . $vat_no . '</td>
</tr>
<tr>
  <td><strong>الخدمة  Product or Service</strong></td><td>' . $product . '</td>
  <td><strong>تاريخ التسجيل - Register Date</strong></td><td>' . $register_date . '</td>
</tr>
<tr>
  <td colspan="4" align="center"><strong>المبالغ والضريبة</strong></td>
</tr>
<tr>
  <td><strong>Payment Without VAT</strong></td><td>' . $row['amountwvat'] . '</td>
  <td><strong>VAT %</strong></td><td>0</td>
</tr>
<tr>
  <td><strong>VAT Amount</strong></td><td>0</td>
  <td><strong>Payment With VAT</strong></td><td>' . $row['totalamountvat'] . '</td>
</tr>
<tr>
  <td><strong>اسم العميل - Customer Name</strong></td><td>' . $customer_name . '</td>
  <td><strong>اسم المسؤول - Responsible Name</strong></td><td>' . $customer_name . '</td>
</tr>
<tr><td colspan="4"><strong>Note:</strong> Please use the following communication for your payment : INV/2024/' . $row['idinvoice'] . '</td></tr>
<tr><td colspan="4" align="center">';

// صورة QR Code حسب المسار المخزن في قاعدة البيانات
$qrcode_path = 'qrcodes/' . $row['idqrcode']; // تأكد من أن هذا هو اسم الملف مع الامتداد
if (file_exists($qrcode_path)) {
    $html .= '<img src="' . $qrcode_path . '" width="150" />';
} else {
    $html .= '<p>QR Code غير متوفر</p>';
}

$html .= '</td></tr></table>';

// عرض الفاتورة
$pdf->writeHTML($html, true, false, true, false, '');
$pdf->Output("invoice_{$row['idinvoice']}.pdf", 'I');
?>
