<?php
ob_start();
require_once('tcpdf/tcpdf.php');

$conn = new mysqli("localhost:3306", "acesaudi_usr", 'tabfyv-6xiFry-noczak', "acesaudi_site");
$conn->set_charset("utf8");

function getArabicDayName($date) {
    $daysArabic = [
        'Saturday'  => 'السبت',
        'Sunday'    => 'الأحد',
        'Monday'    => 'الاثنين',
        'Tuesday'   => 'الثلاثاء',
        'Wednesday' => 'الأربعاء',
        'Thursday'  => 'الخميس',
        'Friday'    => 'الجمعة',
    ];
    $englishDay = date('l', strtotime($date));
    return $daysArabic[$englishDay] ?? 'غير معروف';
}

function getWeekRange($date) {
    $dt = new DateTime($date);
    $week = $dt->format("W");
    $year = $dt->format("o");
    $dt->setISODate($year, $week);
    $start = $dt->format("Y-m-d");
    $dt->modify('+6 days');
    $end = $dt->format("Y-m-d");
    return [$week, $start, $end];
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['idcustomer'])) {
    $id = $_POST['idcustomer'];
    $stmt = $conn->prepare("SELECT patient_name FROM bookings WHERE patient_id = ? LIMIT 1");
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $patientResult = $stmt->get_result();
    $patientName = '---';
    if ($row = $patientResult->fetch_assoc()) {
        $patientName = $row['patient_name'];
    }

    $stmt = $conn->prepare("SELECT booking_date, time_slot, end_time, typeservice, room_id FROM bookings WHERE patient_id = ? ORDER BY booking_date ASC");
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    $weeklyAppointments = [];

    while ($row = $result->fetch_assoc()) {
        $day = getArabicDayName($row['booking_date']);
        $timeLabel = $row['time_slot'] . ' - ' . $row['end_time'];
        $info = $row['typeservice'] . ' - ' . $row['room_id'];
        [$week, $start, $end] = getWeekRange($row['booking_date']);
        $weekKey = "$week|$start|$end";
        $weeklyAppointments[$weekKey][$day][$timeLabel] = $info;
    }

    $dayOrder = ['الأحد','الاثنين','الثلاثاء','الأربعاء','الخميس','الجمعة','السبت'];

    $pdf = new TCPDF();
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('ACE Clinic System');
    $pdf->SetTitle('جدول مواعيد المستفيد');
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    $pdf->SetFont('aealarabiya', '', 13);
    $pdf->AddPage();

    foreach ($weeklyAppointments as $weekKey => $appointments) {
        [$weekNum, $startDate, $endDate] = explode('|', $weekKey);

        $allTimes = [];
        foreach ($appointments as $dayAppointments) {
            foreach ($dayAppointments as $time => $val) {
                $allTimes[$time] = strtotime(explode(' - ', $time)[0]);
            }
        }

        // ترتيب الفترات الزمنية تصاعديًا
        asort($allTimes);
        $sortedTimes = array_keys($allTimes);

        $html = "<style>
            table { border-collapse: collapse; width: 100%; direction: rtl; font-size: 12px; }
            th, td { border: 1px solid #999; padding: 5px; text-align: center; }
            th { background-color: #d3e0ea; font-weight: bold; }
        </style>";

        $html .= "<h3 style='text-align:center;'>اسم المستفيد: $patientName | رقم الملف: $id</h3>";
        $html .= "<h4 style='text-align:center;'>الأسبوع رقم $weekNum : من $startDate إلى $endDate</h4>";

        $html .= "<table><thead><tr><th>اليوم</th><th>التاريخ</th>";
foreach ($sortedTimes as $time) {
    $html .= "<th>$time</th>";
}
$html .= "</tr></thead><tbody>";

foreach ($dayOrder as $day) {
    if (isset($appointments[$day])) {
        // نحاول إيجاد أول تاريخ مطابق لهذا اليوم من المواعيد
        $foundDate = '';
        foreach ($weeklyAppointments[$weekKey][$day] as $timeSlot => $info) {
            foreach ($result as $row) {
                if (getArabicDayName($row['booking_date']) === $day && 
                    ($row['time_slot'] . ' - ' . $row['end_time']) === $timeSlot) {
                    $foundDate = $row['booking_date'];
                    break 2;
                }
            }
        }

        $html .= "<tr><td>$day</td><td>$foundDate</td>";
        foreach ($sortedTimes as $time) {
            $val = $appointments[$day][$time] ?? '';
            $html .= "<td>$val</td>";
        }
        $html .= "</tr>";
    }
}

        $html .= "</tbody></table><br><br>";
        $pdf->writeHTML($html, true, false, true, false, '');
    }

    ob_end_clean();
    $pdf->Output("weekly_schedule_$id.pdf", 'I');
} else {
    echo "<p style='color:red;'>يرجى إدخال رقم هوية صحيح.</p>";
}
?>
