<?php
ob_start();
require_once('tcpdf/tcpdf.php');

$conn = new mysqli("localhost:3306", "acesaudi_usr", 'tabfyv-6xiFry-noczak', "acesaudi_site");
$conn->set_charset("utf8");

function getArabicDayName($date) {
    $daysArabic = [
        'Saturday'  => 'السبت',
        'Sunday'    => 'الأحد',
        'Monday'    => 'الاثنين',
        'Tuesday'   => 'الثلاثاء',
        'Wednesday' => 'الأربعاء',
        'Thursday'  => 'الخميس',
        'Friday'    => 'الجمعة',
    ];
    $englishDay = date('l', strtotime($date));
    return $daysArabic[$englishDay] ?? 'غير معروف';
}

function getWeekStartEnd($year, $week) {
    $dto = new DateTime();
    $dto->setISODate($year, $week);
    $start = $dto->format('Y-m-d');
    $dto->modify('+6 days');
    $end = $dto->format('Y-m-d');
    return [$start, $end];
}

if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($_POST['idcustomer'])) {
    $id = $_POST['idcustomer'];

    $stmt = $conn->prepare("
        SELECT 
            id, patient_name, patient_id, typeservice, room_id, booking_date, 
            time_slot, end_time, bookingstatus, notes, spclistsname
        FROM bookings
        WHERE patient_id = ?
        ORDER BY booking_date ASC
    ");
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $firstRow = $result->fetch_assoc();
        $patientName = $firstRow['patient_name'] ?? '---';
        $patientID = $firstRow['patient_id'] ?? '---';
        $result->data_seek(0);

        $appointments = [];
        while ($row = $result->fetch_assoc()) {
            $date = $row['booking_date'];
            $day = getArabicDayName($date);
            $timeKey = $row['time_slot'] . ' - ' . $row['end_time'];
            $weekKey = date('o', strtotime($date)) . '-W' . date('W', strtotime($date));

            $appointments[$weekKey][$day][$timeKey] = 
                $row['typeservice'] . "<br>" .
                "غرفة: " . $row['room_id'] . "<br>" .
                "أخصائي: " . ($row['spclistsname'] ?? '---') . "<br>" .
                "الحالة: " . $row['bookingstatus'];

            $appointments[$weekKey][$day . '_date'] = $date;
        }

        $pdf = new TCPDF();
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('ACE Clinic System');
        $pdf->SetTitle('جدول المواعيد الأسبوعي');
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);
        $pdf->SetFont('aealarabiya', '', 13);
        $pdf->AddPage();

        $pdf->writeHTML("<h3 style='text-align:center;'>اسم المستفيد: $patientName | رقم الملف: $patientID</h3>", true, false, true, false, '');

        $dayOrder = ['الأحد', 'الاثنين', 'الثلاثاء', 'الأربعاء', 'الخميس', 'الجمعة', 'السبت'];

        foreach ($appointments as $weekKey => $weeklyData) {
            $parts = explode('-W', $weekKey);
            [$start, $end] = getWeekStartEnd($parts[0], $parts[1]);

            $allTimes = [];
            foreach ($weeklyData as $day => $slots) {
                if (strpos($day, '_date') === false) {
                    $allTimes = array_merge($allTimes, array_keys($slots));
                }
            }
            $allTimes = array_unique($allTimes);
            sort($allTimes);

            $html = "<style>
                table { border-collapse: collapse; width: 100%; direction: rtl; font-size: 13px; text-align: center; }
                th, td { border: 1px solid #999; padding: 6px; }
                th { background-color: #d3e0ea; font-weight: bold; }
            </style>";

            $html .= "<div style='background-color:#f0f0f0; padding:5px; font-size:16px; font-weight:bold; text-align:center;'>الأسبوع رقم: {$parts[1]} (من $start إلى $end)</div>";
            $html .= "<table><thead><tr style='background-color:#d3e0ea;'>
                <th>اليوم</th>
                <th>التاريخ</th>";

            foreach ($allTimes as $time) {
                $html .= "<th>$time</th>";
            }
            $html .= "</tr></thead><tbody>";

            foreach ($dayOrder as $day) {
                if (isset($weeklyData[$day])) {
                    $html .= "<tr>
                        <td style='background-color:#f0f0f0; font-weight:bold;'>$day</td>
                        <td style='background-color:#f0f0f0;'>" . ($weeklyData[$day . '_date'] ?? '') . "</td>";

                    foreach ($allTimes as $time) {
                        $val = $weeklyData[$day][$time] ?? '';
                        $color = "#ffffff";
                        if (stripos($val, 'slp') !== false) {
                            $color = "#d1e7dd";
                        } elseif (stripos($val, 'aba') !== false) {
                            $color = "#fde2e2";
                        } elseif (stripos($val, 'ot') !== false || stripos($val, 'العلاج الوظيفي') !== false) {
                            $color = "#fff3cd";
                        } elseif (stripos($val, 'vr') !== false) {
                            $color = "#e0e7ff";
                        }
                        $html .= "<td style='background-color:$color;'>$val</td>";
                    }

                    $html .= "</tr>";
                }
            }

            $html .= "</tbody></table><br><br>";
            $pdf->writeHTML($html, true, false, true, false, '');
        }

        ob_end_clean();
        $pdf->Output("weekly_schedule_$id.pdf", 'I');
    } else {
        echo "<p style='color:red;'>لا توجد مواعيد متاحة لهذا الرقم.</p>";
    }
} else {
    echo "<p style='color:red;'>يرجى إدخال رقم هوية صحيح.</p>";
}
?>
