<?php
include 'conni.php';

// التحقق من البيانات المستلمة
if (!isset($_GET['date']) || !isset($_GET['period'])) {
    echo json_encode(["error" => "بيانات غير مكتملة"]);
    exit;
}

$date = $_GET['date'];
$period = $_GET['period'];

// استعلام لجلب الأوقات والغرف المتاحة بناءً على التاريخ والفترة
$query = "
    SELECT room_id, time_slot
    FROM bookings
    WHERE booking_date = ? AND period = ? AND bookingstatus != 'مؤكد';
";

$stmt = $conn->prepare($query);
$stmt->bind_param("ss", $date, $period);
$stmt->execute();
$result = $stmt->get_result();

$slots = [];
while ($row = $result->fetch_assoc()) {
    $slots[] = [
        "room" => $row['room_id'],
        "time" => $row['time_slot']
    ];
}

$stmt->close();
$conn->close();

echo json_encode(["slots" => $slots]);
?>
