
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
 <?php include 'financeheader.php'; ?>
 
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'financesidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenufinance.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Aggregate account statement Report</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Aggregate account statement Report</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
<?php
ini_set('display_errors', 0);
error_reporting(E_ALL & ~E_WARNING);
/********* DB *********/
$host     = 'localhost:3306';
$dbname   = 'acesaudi_site';
$username = 'acesaudi_usr';
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username, $password, [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
} catch (PDOException $e) { die("فشل الاتصال: " . $e->getMessage()); }

function h($v){ return htmlspecialchars((string)($v ?? ''), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }

/********* Inputs *********/
$date_from      = $_GET['date_from']   ?? '';    // YYYY-MM-DD
$date_to        = $_GET['date_to']     ?? '';
$customer_id_in = trim($_GET['customerid'] ?? '');
$paid_only      = isset($_GET['paid_only']);     // يقيّد photo بالحالات المدفوعة
$export         = isset($_GET['export']);        // تصدير الملخص

/********* Filters builder *********/
/* installments */
$instWhere  = [];
$instParams = [];
if ($date_from !== '') { $instWhere[] = "i.`dateschauled` >= ?"; $instParams[] = $date_from; }
if ($date_to   !== '') { $instWhere[] = "i.`dateschauled` <= ?"; $instParams[] = $date_to; }

if ($customer_id_in !== '') {
    if (ctype_digit($customer_id_in)) { $instWhere[] = "i.`customerid` = ?"; $instParams[] = $customer_id_in; }
    else { $instWhere[] = "i.`customerid` LIKE ?"; $instParams[] = "%{$customer_id_in}%"; }
}
$instWhereSql = $instWhere ? ('WHERE ' . implode(' AND ', $instWhere)) : '';

/* photo (payments) */
$payWhere  = [];
$payParams = [];
if ($date_from !== '') { $payWhere[] = "p.`creatdate` >= ?"; $payParams[] = $date_from; }
if ($date_to   !== '') { $payWhere[] = "p.`creatdate` <= ?"; $payParams[] = $date_to; }
if ($customer_id_in !== '') {
    if (ctype_digit($customer_id_in)) { $payWhere[] = "p.`idcustomer` = ?"; $payParams[] = $customer_id_in; }
    else { $payWhere[] = "p.`idcustomer` LIKE ?"; $payParams[] = "%{$customer_id_in}%"; }
}
if ($paid_only) {
    // وسّع القائمة لو عندك قيم أخرى للنجاح
    $payWhere[] = "TRIM(COALESCE(p.`paymentstatus`, '')) IN ('مدفوع','Paid','paid','تم الدفع','succeeded')";
}
$payWhereSql = $payWhere ? ('WHERE ' . implode(' AND ', $payWhere)) : '';

/********* Aggregations *********/
/* 1) تجميع الأقساط حسب (المستفيد+الخدمة) */
$sqlInst = "
    SELECT
        i.`customerid`,
        i.`serviceid`,
        COUNT(*) AS total_count,
        SUM(i.`installmentamount`) AS total_amount,
        SUM(CASE WHEN TRIM(COALESCE(i.`payment_status`, '')) = 'مدفوع'     THEN 1 ELSE 0 END) AS paid_count,
        SUM(CASE WHEN TRIM(COALESCE(i.`payment_status`, '')) = 'مدفوع'     THEN i.`installmentamount` ELSE 0 END) AS paid_amount,
        SUM(CASE WHEN TRIM(COALESCE(i.`payment_status`, '')) <> 'مدفوع'    THEN 1 ELSE 0 END) AS unpaid_count,
        SUM(CASE WHEN TRIM(COALESCE(i.`payment_status`, '')) <> 'مدفوع'    THEN i.`installmentamount` ELSE 0 END) AS unpaid_amount
    FROM `installments` i
    {$instWhereSql}
    GROUP BY i.`customerid`, i.`serviceid`
";
$st = $pdo->prepare($sqlInst);
$st->execute($instParams);
$instAgg = $st->fetchAll();

/* 2) تجميع المدفوعات من photo (amount) + جلب الاسم/نوع الخدمة من أحدث سجل */
$sqlPay = "
    SELECT
        t.`idcustomer`      AS customerid,
        t.`proudctid`       AS serviceid,
        t.`paid_amount`,
        t.`payments_count`,
        p2.`fullname`,
        p2.`typeservice`
    FROM (
        SELECT p.`idcustomer`, p.`proudctid`,
               SUM(p.`amount`) AS paid_amount,
               COUNT(*)        AS payments_count,
               MAX(p.`photoid`) AS maxpid
        FROM `photo` p
        {$payWhereSql}
        GROUP BY p.`idcustomer`, p.`proudctid`
    ) t
    JOIN `photo` p2 ON p2.`photoid` = t.`maxpid`
";
$sp = $pdo->prepare($sqlPay);
$sp->execute($payParams);
$payAgg = $sp->fetchAll();

/********* دمج النتائج في خريطة واحدة *********/
$map = [];   // key = customerid|serviceid
$totals = ['sched'=>0.0, 'paid_sched'=>0.0, 'unpaid_sched'=>0.0, 'paid_actual'=>0.0];

foreach ($instAgg as $r) {
    $key = $r['customerid'].'|'.$r['serviceid'];
    $map[$key] = [
        'customerid'     => $r['customerid'],
        'serviceid'      => $r['serviceid'],
        'fullname'       => '',
        'typeservice'    => '',
        'total_count'    => (int)$r['total_count'],
        'total_amount'   => (float)$r['total_amount'],
        'paid_count'     => (int)$r['paid_count'],
        'paid_amount'    => (float)$r['paid_amount'],
        'unpaid_count'   => (int)$r['unpaid_count'],
        'unpaid_amount'  => (float)$r['unpaid_amount'],
        'paid_actual'    => 0.0,     // من photo.amount
        'payments_count' => 0,
    ];
    $totals['sched']       += (float)$r['total_amount'];
    $totals['paid_sched']  += (float)$r['paid_amount'];
    $totals['unpaid_sched']+= (float)$r['unpaid_amount'];
}

foreach ($payAgg as $p) {
    $key = $p['customerid'].'|'.$p['serviceid'];
    if (!isset($map[$key])) {
        $map[$key] = [
            'customerid'     => $p['customerid'],
            'serviceid'      => $p['serviceid'],
            'fullname'       => '',
            'typeservice'    => '',
            'total_count'    => 0,
            'total_amount'   => 0.0,
            'paid_count'     => 0,
            'paid_amount'    => 0.0,
            'unpaid_count'   => 0,
            'unpaid_amount'  => 0.0,
            'paid_actual'    => 0.0,
            'payments_count' => 0,
        ];
    }
    $map[$key]['paid_actual']    = (float)$p['paid_amount'];
    $map[$key]['payments_count'] = (int)$p['payments_count'];
    $map[$key]['fullname']       = (string)$p['fullname'];
    $map[$key]['typeservice']    = (string)$p['typeservice'];

    $totals['paid_actual']      += (float)$p['paid_amount'];
}

/* تحويل الخريطة لمصفوفة مرتبة حسب الرصيد تنازلي */
$data = array_values($map);
usort($data, function($a,$b){
    $balA = $a['total_amount'] - $a['paid_actual'];
    $balB = $b['total_amount'] - $b['paid_actual'];
    return $balB <=> $balA; // الأكبر أولاً
});

/********* Export (Grouped Income) *********/
if ($export) {
    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
    header('Content-Disposition: attachment; filename="income_installments_vs_payments.xls"');
    echo "<table border='1' style='text-align:center; font-family:Tahoma;' class='table table-hover table-striped'>";
    echo "<tr>
            <th>#</th>
            <th>رقم المستفيد</th>
            <th>اسم المستفيد</th>
            <th>رقم الخدمة</th>
            <th>نوع الخدمة</th>
            <th>عدد الأقساط</th>
            <th>إجمالي الأقساط</th>
            <th>مدفوع (حسب الأقساط)</th>
            <th>غير مدفوع (حسب الأقساط)</th>
            <th>عدد عمليات الدفع</th>
            <th>المدفوع الفعلي</th>
            <th>الرصيد = الأقساط − المدفوع الفعلي</th>
          </tr>";
    $i=1;
    foreach ($data as $row) {
        $balance = $row['total_amount'] - $row['paid_actual'];
        echo "<tr>
                <td>".($i++)."</td>
                <td>".h($row['customerid'])."</td>
                <td>".h($row['fullname'])."</td>
                <td>".h($row['serviceid'])."</td>
                <td>".h($row['typeservice'])."</td>
                <td>".h($row['total_count'])."</td>
                <td>".number_format($row['total_amount'], 2)."</td>
                <td>".number_format($row['paid_amount'], 2)."</td>
                <td>".number_format($row['unpaid_amount'], 2)."</td>
                <td>".h($row['payments_count'])."</td>
                <td>".number_format($row['paid_actual'], 2)."</td>
                <td>".number_format($balance, 2)."</td>
              </tr>";
    }
    echo "<tr style='font-weight:bold;background:#f3f5fb'>
            <td colspan='6'>إجماليات عامة</td>
            <td>".number_format($totals['sched'], 2)."</td>
            <td>".number_format($totals['paid_sched'], 2)."</td>
            <td>".number_format($totals['unpaid_sched'], 2)."</td>
            <td></td>
            <td>".number_format($totals['paid_actual'], 2)."</td>
            <td>".number_format($totals['sched'] - $totals['paid_actual'], 2)."</td>
          </tr>";
    echo "</table>";
    exit;
}
?>

<form method="get" class="form" style="text-align: center;">
  <div class="form-row">
   <label style="text-align: center;">  من</label> <input type="date" name="date_from" value="<?= h($date_from) ?>" class="form-control">
    <label style="text-align: center;">  إلى</label> <input type="date" name="date_to"   value="<?= h($date_to) ?>" class="form-control">
    <label style="text-align: center;">  رقم المستفيد</label> <br> <input type="text" name="customerid" value="<?= h($customer_id_in) ?>" placeholder="مثال: 1179240682" class="form-control"><br>
    <label style="margin:0 8px;text-align: center;">
      <input type="checkbox" name="paid_only" value="1" <?= $paid_only?'checked':''; ?>> احتساب المدفوعات المدفوعة و المؤكدة فقط
    </label><br><br>
    <button type="submit" class="btn btn-block btn-primary"> تصفية فلترة</button>
    <button type="submit" name="export" value="1" class="btn btn-block btn-success">تصدير ملف إكسل</button>
  </div>
</form>
<br>
<table class='table table-hover table-striped'>
  <thead>
    <tr>
      <th>#</th>
      <th>رقم المستفيد</th>
      <th>اسم المستفيد</th>
      <th>رقم الخدمة</th>
      <th>نوع الخدمة</th>
      <th>عدد الأقساط</th>
      <th>إجمالي الأقساط</th>
      <th>مدفوع (حسب الأقساط)</th>
      <th>غير مدفوع (حسب الأقساط)</th>
      <th>عدد عمليات الدفع</th>
      <th>المدفوع الفعلي (photo.amount)</th>
      <th>الرصيد = الأقساط − المدفوع الفعلي</th>
    </tr>
  </thead>
  <tbody>
  <?php if(!$data): ?>
    <tr><td colspan="12">لا توجد بيانات.</td></tr>
  <?php else: $i=1; foreach($data as $row): 
        $balance = $row['total_amount'] - $row['paid_actual'];
  ?>
    <tr>
      <td><?= $i++ ?></td>
      <td><?= h($row['customerid']) ?></td>
      <td><?= h($row['fullname']) ?></td>
      <td><?= h($row['serviceid']) ?></td>
      <td><?= h($row['typeservice']) ?></td>
      <td><?= h($row['total_count']) ?></td>
      <td><?= number_format($row['total_amount'], 2) ?></td>
      <td><?= number_format($row['paid_amount'], 2) ?></td>
      <td><?= number_format($row['unpaid_amount'], 2) ?></td>
      <td><?= h($row['payments_count']) ?></td>
      <td><?= number_format($row['paid_actual'], 2) ?></td>
      <td><?= number_format($balance, 2) ?></td>
    </tr>
  <?php endforeach; endif; ?>
  </tbody>
  <tfoot>
    <tr style="font-weight:bold;background:#f3f5fb">
      <td colspan="6">إجماليات عامة</td>
      <td><?= number_format($totals['sched'], 2) ?></td>
      <td><?= number_format($totals['paid_sched'], 2) ?></td>
      <td><?= number_format($totals['unpaid_sched'], 2) ?></td>
      <td></td>
      <td><?= number_format($totals['paid_actual'], 2) ?></td>
      <td><?= number_format($totals['sched'] - $totals['paid_actual'], 2) ?></td>
    </tr>
  </tfoot>
</table>



            </div>
            <!-- /.box-body -->
          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>

