<?php
$host = "localhost:3306";
$dbname = "acesaudi_site"; // <-- اسم قاعدة البيانات
$username = "acesaudi_usr"; // <-- غيّر هذا
$password = 'tabfyv-6xiFry-noczak';   // <-- غيّره

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // إعدادات المدة والتاريخ
    $startDate = new DateTime('2025-06-30');
    $endDate = (clone $startDate)->modify('+31 days'); // لمدة شهر
    $startTime = new DateTime('07:00:00');
    $interval = new DateInterval('PT45M'); // فترة 45 دقيقة

    // ترجمة أيام الأسبوع للعربية
    $arabicDays = [
        'Saturday' => 'السبت',
        'Sunday' => 'الأحد',
        'Monday' => 'الإثنين',
        'Tuesday' => 'الثلاثاء',
        'Wednesday' => 'الأربعاء',
        'Thursday' => 'الخميس',
        'Friday' => 'الجمعة'
    ];

    // إعداد الاستعلام
    $insertStmt = $pdo->prepare("
        INSERT INTO bookings (booking_date, time_slot, end_time, bookingstatus, dayname, room_id)
        VALUES (:booking_date, :time_slot, :end_time, :bookingstatus, :dayname, :room_id)
    ");

    $roomNumber = 'B203'; // ← رقم الغرفة الثابت

    $count = 0;

    for ($date = clone $startDate; $date <= $endDate; $date->modify('+1 day')) {
        $dayEnglish = $date->format('l'); // مثل Monday
        $dayArabic = $arabicDays[$dayEnglish] ?? $dayEnglish;

        $time = clone $startTime;

        while ((int)$time->format('H') < 22) {
            $startSlot = $time->format('H:i:s');
            $endSlot = $time->add($interval)->format('H:i:s');

            $insertStmt->execute([
                ':booking_date' => $date->format('Y-m-d'),
                ':time_slot' => $startSlot,
                ':end_time' => $endSlot,
                ':bookingstatus' => 'متوفر',
                ':dayname' => $dayArabic,
                ':room_id' => $roomNumber,
            ]);

            $count++;
        }
    }

    echo "✅ تم إنشاء $count موعدًا بنجاح لجميع الأيام مع اسم اليوم بالعربية ورقم الغرفة.";

} catch (PDOException $e) {
    echo "❌ خطأ: " . $e->getMessage();
}
?>
