<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
// إعداد الاتصال بقاعدة البيانات
$host = 'localhost:3306';
$db   = 'acesaudi_site';     // <-- غيّر اسم قاعدة البيانات هنا
$user = 'acesaudi_usr';          // <-- غيّر اسم المستخدم هنا
$pass = 'tabfyv-6xiFry-noczak';          // <-- غيّر كلمة المرور هنا
$charset = 'utf8mb4';

// الاتصال عبر PDO
$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    die("خطأ في الاتصال: " . $e->getMessage());
}

// استقبال التواريخ (إن وُجدت)
$fromDate = isset($_GET['from']) ? $_GET['from'] : null;
$toDate = isset($_GET['to']) ? $_GET['to'] : null;

// فلترة حسب التاريخ
$where = '';
$params = [];

if ($fromDate && $toDate) {
    $where = "WHERE ci.BILLABLEPERIODSTART >= :fromDate AND ci.BILLABLEPERIODEND <= :toDate";
    $params = [
        ':fromDate' => $fromDate,
        ':toDate' => $toDate
    ];
}


$sql = "
SELECT 
    ci.PROVCLAIMNO,
    ci.BENEFICIARYID,
    b.FULLNAME,
    ci.COVERAGEID,
    c.POLICYNUMBER,
    c.POLICYHOLDER,
    cc1.COVERAGE_CLASS,
    ci.BILLABLEPERIODSTART,
    ci.BILLABLEPERIODEND,
    it.INVOICENO,
    it.CLAIM_TOTAL
FROM NPHIES_CLAIMINFO ci
JOIN (
    SELECT PROVCLAIMNO, INVOICENO, SUM(NET) AS CLAIM_TOTAL
    FROM NPHIES_CLAIMITEM
    GROUP BY PROVCLAIMNO, INVOICENO
) it  ON it.PROVCLAIMNO = ci.PROVCLAIMNO
LEFT JOIN NPHIES_BENEFICIARY b ON b.BENEFICIARYID = ci.BENEFICIARYID
LEFT JOIN NPHIES_COVERAGE    c ON c.COVERAGEID    = ci.COVERAGEID
LEFT JOIN (
    SELECT COVERAGEID, MIN(VALUE) AS COVERAGE_CLASS
    FROM NPHIES_COVERAGE_CLASS
    GROUP BY COVERAGEID
) cc1 ON cc1.COVERAGEID = c.COVERAGEID
$where
ORDER BY ci.PROVCLAIMNO, it.INVOICENO
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$results = $stmt->fetchAll();
$totalSum = array_sum(array_column($results, 'CLAIM_TOTAL'));

?>


<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
    <style>
        body { font-family: Arial; background: #f8f8f8; }
        table { width: 100%; direction: rtl; border-collapse: collapse; background: white; }
        th, td { padding: 10px; border: 1px solid #ccc; text-align: center; }
        th { background: #eee; }
        .form-container, .buttons { margin-bottom: 20px; background: white; padding: 20px; border-radius: 10px; direction: rtl; }
        input[type="date"], button { padding: 10px; margin: 5px 0; width: 100%; }
        .buttons form { display: inline-block; margin-left: 10px; }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
 <?php include 'financeheader.php'; ?>
 
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'financesidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenufinance.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Claims</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Calims Info Center</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <div id="example1_wrapper" class="dataTables_wrapper form-inline dt-bootstrap"><div class="row"><div class="col-sm-10"><div class="dataTables_length" id="example1_length"><label>Show <select name="example1_length" aria-controls="example1" class="form-control input-sm"><option value="10">10</option><option value="25">25</option><option value="50">50</option><option value="100">100</option></select> entries</label></div></div>
              
              <div class="col-sm-2"><div id="example1_filter" class="dataTables_filter"><label>Search:<input type="search" class="form-control input-sm" placeholder="" aria-controls="example1"></label></div></div></div>
              
              <div class="row">
               <div class="col-sm-12">
              
              <div class="from-group">
  <br>
</div>
 
<h2 style="text-align: center;"> Claims Report by Service Period - تقرير المطالبات حسب فترة الخدمة</h2>

<div class="form-container">
    <form method="get">
        <label>من تاريخ  From Date</label>
        <input type="date" name="from" value="<?= htmlspecialchars($fromDate) ?>">
        <label>إلى تاريخ Untile Date</label>
        <input type="date" name="to" value="<?= htmlspecialchars($toDate) ?>">
        <button type="submit" class="btn btn-block btn-primary" style="background-color: #3c8dbc;color:white;">  عرض التقرير View Report </button>
    </form>
</div>

<div class="buttons">
    <?php if ($fromDate && $toDate): ?>
        <form method="get" action="export_excel.php">
            <input type="hidden" name="from" value="<?= $fromDate ?>">
            <input type="hidden" name="to" value="<?= $toDate ?>">
            <button type="submit" class="btn btn-block btn-success">تصدير إلى Excel</button>
        </form>
        <form method="get" action="export_pdf.php">
            <input type="hidden" name="from" value="<?= $fromDate ?>">
            <input type="hidden" name="to" value="<?= $toDate ?>">
            <button type="submit" class="btn btn-block btn-warning">تصدير إلى PDF</button>
        </form>
    <?php endif; ?>
</div>

<?php if ($results): ?>
    <table>
        <thead>
            <tr>
                <th>رقم المطالبة <br> Claim No </th>
                <th> اسم المستفيد <br> Beneficiary Name</th>
                <th> رقم الفاتورة  <br> Invoice NO</th>
                <th>رقم المستفيد <br> Beneficiary NO</th>
                <th>رقم الوثيقة <br> Doc NO</th>
                <th>اسم صاحب العمل شركة التأمين<br> Work & Insurance Com</th>
                <th>نوع التغطية <br> Cover Type</th>
                <th>من تاريخ <br> Date From</th>
                <th>إلى تاريخ<br> Daate To</th>
                <th>إجمالي المبلغ<br> Total Amount</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($results as $row): ?>
                <tr>
                    <td><?= $row['PROVCLAIMNO'] ?></td>
                    <td><?= $row['FULLNAME'] ?></td>
                    <td><?= $row['BENEFICIARYID'] ?></td>
                    <td><?= $row['INVOICENO'] ?></td>
                    <td><?= $row['POLICYNUMBER'] ?></td>
                    <td><?= $row['POLICYHOLDER'] ?></td>
                    <td><?= $row['COVERAGE_CLASS'] ?></td>
                    <td><?= $row['BILLABLEPERIODSTART'] ?></td>
                    <td><?= $row['BILLABLEPERIODEND'] ?></td>
                    <td><?= number_format($row['CLAIM_TOTAL'], 2) ?> ريال</td>
                </tr>
            <?php endforeach; ?>
            <tr style="background-color: #f0f0f0; font-weight: bold;">
                <td colspan="9" style="text-align: left;">الإجمالي الكلي Total Amounts</td>
                <td><?= number_format($totalSum, 2) ?> ريال SAR</td>
            </tr>
        </tbody>
    </table>
<?php else: ?>
    <p>لا توجد نتائج لهذه الفترة.</p>
<?php endif; ?>
              
              </div>
            </div>
            <!-- /.box-body -->
          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
