<?php
/************ أعلى الصفحة: منطق PHP قبل أي HTML ************/
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
ob_start(); // لتجميع أي خرج قبل إرسال الهيدرز

// ====== اتصال PDO ======
$host = 'localhost:3306';
$dbname = 'acesaudi_site';
$username = 'acesaudi_usr';
$password = 'tabfyv-6xiFry-noczak';
$prefix = 'uiUJBF2e_';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
} catch (PDOException $e) {
    while (ob_get_level() > 0) ob_end_clean();
    header('Content-Type: text/plain; charset=utf-8');
    echo "فشل الاتصال: " . $e->getMessage();
    exit;
}

// PhpSpreadsheet (اختياري)
$hasPhpSpreadsheet = false;
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    require_once __DIR__ . '/vendor/autoload.php';
    if (class_exists(\PhpOffice\PhpSpreadsheet\Spreadsheet::class)) $hasPhpSpreadsheet = true;
}

// ====== مدخلات الفلاتر ======
$date_from    = $_GET['date_from'] ?? '';
$date_to      = $_GET['date_to'] ?? '';
$order_status = $_GET['status'] ?? '';
$search       = trim($_GET['search'] ?? '');
$export       = $_GET['export'] ?? ''; // '' | 'excel' | 'pdf'

// ====== الشرط ======
$where = "WHERE p.post_type = 'shop_order'";
$params = [];

// التاريخ
if ($date_from && $date_to) {
    $where .= " AND DATE(p.post_date) BETWEEN ? AND ?";
    $params[] = $date_from; $params[] = $date_to;
} elseif ($date_from) {
    $where .= " AND DATE(p.post_date) >= ?";
    $params[] = $date_from;
} elseif ($date_to) {
    $where .= " AND DATE(p.post_date) <= ?";
    $params[] = $date_to;
}

// الحالة
if ($order_status) {
    $where .= " AND p.post_status = ?";
    $params[] = $order_status;
}

// البحث العام
if ($search) {
    $where .= " AND EXISTS (
        SELECT 1 FROM {$prefix}postmeta pm1
        WHERE pm1.post_id = p.ID
          AND pm1.meta_key IN ('_billing_first_name','_billing_last_name','_billing_email','_billing_phone')
          AND pm1.meta_value LIKE ?
    )";
    $params[] = "%$search%";
}

/* ====== الاستعلام ======
   - نجلب before_tax عبر تجميع _line_total لكل عناصر الطلب.
*/
$sql = "
    SELECT 
        p.ID AS order_id, 
        p.post_date, 
        p.post_status,
        MAX(CASE WHEN pm.meta_key = '_billing_first_name' THEN pm.meta_value END) AS first_name,
        MAX(CASE WHEN pm.meta_key = '_billing_last_name' THEN pm.meta_value END)  AS last_name,
        MAX(CASE WHEN pm.meta_key = '_billing_email' THEN pm.meta_value END)      AS email,
        MAX(CASE WHEN pm.meta_key = '_billing_phone' THEN pm.meta_value END)      AS phone,
        MAX(CASE WHEN pm.meta_key = '_payment_method_title' THEN pm.meta_value END) AS payment_method,
        MAX(CASE WHEN pm.meta_key = '_order_total' THEN pm.meta_value END)        AS order_total,
        COALESCE(oi_sum.before_tax, 0)                                            AS before_tax
    FROM {$prefix}posts p
    LEFT JOIN {$prefix}postmeta pm ON p.ID = pm.post_id
    /* تجميع عناصر الطلب لحساب السعر قبل الضريبة */
    LEFT JOIN (
        SELECT 
            oi.order_id,
            SUM(CASE WHEN oim.meta_key = '_line_total' 
                     THEN CAST(oim.meta_value AS DECIMAL(20,6)) ELSE 0 END) AS before_tax
        FROM {$prefix}woocommerce_order_items oi
        LEFT JOIN {$prefix}woocommerce_order_itemmeta oim 
               ON oi.order_item_id = oim.order_item_id
        WHERE oi.order_item_type = 'line_item'
        GROUP BY oi.order_id
    ) AS oi_sum ON oi_sum.order_id = p.ID
    $where
    GROUP BY p.ID
    ORDER BY p.ID DESC
";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$orders = $stmt->fetchAll();

// ====== تفاصيل المنتجات (للعرض والملف) ======
function getProductDetails($pdo, $prefix, $order_id) {
    $sql = "
        SELECT oi.order_item_name,
               MAX(CASE WHEN oim.meta_key = '_qty' THEN oim.meta_value END)        AS quantity,
               MAX(CASE WHEN oim.meta_key = '_line_total' THEN oim.meta_value END) AS line_total
        FROM {$prefix}woocommerce_order_items oi
        LEFT JOIN {$prefix}woocommerce_order_itemmeta oim ON oi.order_item_id = oim.order_item_id
        WHERE oi.order_id = ? AND oi.order_item_type = 'line_item'
        GROUP BY oi.order_item_id
    ";
    $st = $pdo->prepare($sql);
    $st->execute([$order_id]);
    $items = $st->fetchAll();

    $result = '';
    foreach ($items as $it) {
        $name = $it['order_item_name'] ?? '';
        $qty  = (int)($it['quantity'] ?? 0);
        $tot  = number_format((float)($it['line_total'] ?? 0), 2);
        $result .= "{$name} × {$qty} = {$tot} ريال\n";
    }
    return $result;
}

// ====== التصدير ======
if ($export === 'excel') {
    // حضّر الصفوف (مع الأعمدة الجديدة)
    $rows = [];
    $rows[] = [
        'رقم الطلب','تاريخ الطلب','الحالة','اسم العميل','الإيميل','رقم الجوال',
        'طريقة الدفع', 'السعر قبل الضريبة', 'الضريبة (15%)', 'إجمالي الطلب',
        'تفاصيل المنتجات','رابط الفاتورة'
    ];
    foreach ($orders as $o) {
        $beforeTax = (float)$o['before_tax'];
        $vat15     = round($beforeTax * 0.15, 2);
        $detailsText    = getProductDetails($pdo, $prefix, $o['order_id']);
        $detailsOneLine = preg_replace('/\s+/', ' ', trim($detailsText));
        $invoice_link   = ($o['post_status'] === 'wc-completed')
            ? "https://yourdomain.com/wp-admin/post.php?post={$o['order_id']}&action=edit"
            : '—';
        $rows[] = [
            (int)$o['order_id'],
            $o['post_date'],
            $o['post_status'],
            trim(($o['first_name'] ?? '') . ' ' . ($o['last_name'] ?? '')),
            $o['email'],
            $o['phone'],
            $o['payment_method'],
            $beforeTax,
            $vat15,
            (float)$o['order_total'],
            $detailsOneLine,
            $invoice_link
        ];
    }

    $old_display_errors = ini_get('display_errors');
    ini_set('display_errors', 0);
    while (ob_get_level() > 0) ob_end_clean();

    if ($hasPhpSpreadsheet) {
        $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet()->setTitle('Orders');

        $r = 1;
        foreach ($rows as $row) {
            $c = 1;
            foreach ($row as $cell) {
                $sheet->setCellValueByColumnAndRow($c, $r, $cell);
                $c++;
            }
            $r++;
        }
        // عناوين عريضة وتوسيع أعمدة (A..L لأن لدينا 12 عمودًا)
        $sheet->getStyle('A1:L1')->getFont()->setBold(true);
        foreach (range('A','L') as $col) $sheet->getColumnDimension($col)->setAutoSize(true);

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; charset=utf-8');
        header('Content-Disposition: attachment; filename="orders_export.xlsx"');
        header('Cache-Control: max-age=0');
        $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
        $writer->save('php://output');
        ini_set('display_errors', $old_display_errors);
        exit;
    } else {
        header('Content-Type: application/vnd.ms-excel; charset=utf-8');
        header('Content-Disposition: attachment; filename="orders_export.xls"');
        echo "<table border='1' style='text-align:center;'><tr>";
        foreach ($rows[0] as $th) echo "<th>".htmlspecialchars($th, ENT_QUOTES, 'UTF-8')."</th>";
        echo "</tr>";
        for ($i=1; $i<count($rows); $i++) {
            echo "<tr>";
            foreach ($rows[$i] as $cell) echo "<td>".htmlspecialchars((string)$cell, ENT_QUOTES, 'UTF-8')."</td>";
            echo "</tr>";
        }
        echo "</table>";
        ini_set('display_errors', $old_display_errors);
        exit;
    }
}
elseif ($export === 'pdf') {
    while (ob_get_level() > 0) ob_end_clean();
    header('Content-Type: text/plain; charset=utf-8');
    echo "تصدير PDF غير مفعّل حالياً. فعّل DomPDF/TCPDF ثم أضف المنطق هنا.";
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | Dashboard</title>
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <style>
    .filters .form-control{display:inline-block;max-width:260px;margin:4px 6px;}
    .filters .btn{margin:4px 6px;}
    table td, table th{text-align:center;}
    td.details-cell{white-space:pre-line;text-align:left;direction:ltr;}
  </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <?php include 'financeheader.php'; ?>

  <aside class="main-sidebar">
    <section class="sidebar">
      <?php include 'financesidepanle.php'; ?>
      <?php include 'searchform.php'; ?>
      <?php include 'navemenufinance.php'; ?>
    </section>
  </aside>

  <div class="content-wrapper">
    <section class="content-header">
      <h1><small></small></h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Website Invoices</a></li>
      </ol>
    </section>

    <section class="content">
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Website Invoices Information</h3>
        </div>

        <div class="box-body">
          <!-- نموذج الفلاتر + أزرار التصدير -->
          <form method="get" class="filters text-center">
            <label>من تاريخ</label>
            <input type="date" class="form-control" name="date_from" value="<?= htmlspecialchars($date_from, ENT_QUOTES, 'UTF-8') ?>">

            <label>إلى تاريخ</label>
            <input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($date_to, ENT_QUOTES, 'UTF-8') ?>">

            <label>بحث (اسم / بريد / جوال)</label>
            <input type="text" class="form-control" name="search" value="<?= htmlspecialchars($search, ENT_QUOTES, 'UTF-8') ?>" placeholder="مثال: أحمد أو example@email.com">

            <label>حالة الطلب</label>
            <select name="status" class="form-control">
              <option value="">-- الكل --</option>
              <option value="wc-completed"  <?= $order_status=='wc-completed'  ? 'selected' : '' ?>>مكتمل</option>
              <option value="wc-processing" <?= $order_status=='wc-processing' ? 'selected' : '' ?>>قيد التنفيذ</option>
              <option value="wc-pending"    <?= $order_status=='wc-pending'    ? 'selected' : '' ?>>معلق</option>
              <option value="wc-cancelled"  <?= $order_status=='wc-cancelled'  ? 'selected' : '' ?>>ملغي</option>
            </select>

            <button type="submit" class="btn btn-primary"><i class="fa fa-filter"></i> بحث</button>
            <a href="?" class="btn btn-default"><i class="fa fa-undo"></i> إعادة الضبط</a>

            <!-- تصدير -->
            <button type="submit" class="btn btn-success" name="export" value="excel">
              <i class="fa fa-file-excel-o"></i> تصدير إلى Excel
            </button>
            <button type="submit" class="btn btn-danger" name="export" value="pdf">
              <i class="fa fa-file-pdf-o"></i> تصدير إلى PDF
            </button>
          </form>

          <div class="table-responsive">
            <table class="table table-bordered table-striped">
              <thead>
                <tr>
                  <th>رقم الطلب</th>
                  <th>تاريخ الطلب</th>
                  <th>الحالة</th>
                  <th>اسم العميل</th>
                  <th>الإيميل</th>
                  <th>رقم الجوال</th>
                  <th>طريقة الدفع</th>
                  <th>السعر قبل الضريبة</th>
                  <th>الضريبة (15%)</th>
                  <th>إجمالي الطلب</th>
                  <th>تفاصيل المنتجات</th>
                  <th>رابط الفاتورة</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach ($orders as $order): 
                    $beforeTax = (float)$order['before_tax'];
                    $vat15     = round($beforeTax * 0.15, 2);
              ?>
                <tr>
                  <td><?= (int)$order['order_id'] ?></td>
                  <td><?= htmlspecialchars($order['post_date'], ENT_QUOTES, 'UTF-8') ?></td>
                  <td><?= htmlspecialchars($order['post_status'], ENT_QUOTES, 'UTF-8') ?></td>
                  <td><?= htmlspecialchars(trim(($order['first_name'] ?? '').' '.($order['last_name'] ?? '')), ENT_QUOTES, 'UTF-8') ?></td>
                  <td><?= htmlspecialchars($order['email'] ?? '', ENT_QUOTES, 'UTF-8') ?></td>
                  <td><?= htmlspecialchars($order['phone'] ?? '', ENT_QUOTES, 'UTF-8') ?></td>
                  <td><?= htmlspecialchars($order['payment_method'] ?? '', ENT_QUOTES, 'UTF-8') ?></td>
                  <td><?= number_format($beforeTax, 2) ?> ريال</td>
                  <td><?= number_format($vat15, 2) ?> ريال</td>
                  <td><?= number_format((float)$order['order_total'], 2) ?> ريال</td>
                  <td class="details-cell">
                    <?= nl2br(htmlspecialchars(getProductDetails($pdo, $prefix, $order['order_id']), ENT_QUOTES, 'UTF-8')) ?>
                  </td>
                  <td>
                    <?php if ($order['post_status'] === 'wc-completed'): ?>
                      <a href="posfinance.php?customerid=<?= (int)$order['order_id'] ?>&firstname=<?= urlencode($order['first_name']) ?>&lastname=<?= urlencode($order['last_name']) ?>&email=<?= urlencode($order['email']) ?>&phone=<?= urlencode($order['phone']) ?>&paymentmethode=<?= urlencode($order['payment_method']) ?>&ordertotal=<?= urlencode($order['order_total']) ?>&date=<?= urlencode($order['post_date']) ?>&typeservice=<?= urlencode(getProductDetails($pdo, $prefix, $order['order_id'])) ?>"
                         target="_blank" class="btn bg-navy margin" style="background-color:#605ca8!important;color:#fff;">
                        <i class="fa fa-file-pdf-o"></i> إنشاء فاتورة
                      </a>
                    <?php else: ?>
                      <p style="color:red;margin:0;">الطلب غير مكتمل الدفع ولايمكن فوترته</p>
                    <?php endif; ?>
                  </td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>

        </div><!-- /.box-body -->

        <div class="box-footer"></div>
      </div><!-- /.box -->
    </section>
  </div><!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <aside class="control-sidebar control-sidebar-dark">
    <div class="tab-content">
      <div class="tab-pane" id="control-sidebar-home-tab"></div>
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <div class="tab-pane" id="control-sidebar-settings-tab"></div>
    </div>
  </aside>
  <div class="control-sidebar-bg"></div>
</div><!-- /.wrapper -->

<!-- سكربتات -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<script src="bootstrap/js/bootstrap.min.js"></script>
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<script src="plugins/fastclick/fastclick.js"></script>
<script src="dist/js/app.min.js"></script>
<script src="dist/js/demo.js"></script>
</body>
</html>
