<?php
// بدء الجلسة
session_start();

// التحقق مما إذا كان المستخدم مسجلاً للدخول
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: superadminlogin.php");
    exit;
}
// جلب معرف المستخدم من الجلسة
 $iduser = $_SESSION["iduser"];
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>تقويم المواعيد</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/fullcalendar.min.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/fullcalendar.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/locale/ar.js"></script>
    
    <style>
        #tooltip {
            display: none;
            position: absolute;
            z-index: 1000;
            background: #ffffff;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            font-size: 14px;
            line-height: 1.6;
            max-width: 660px;
            direction: rtl;
        }

        #calendar {
            max-width: 1860px;
            margin: 50px auto;
        }

        .fc-content{
        text-align: center;
        }
        
        /* إضافة مؤشر السحب */
        .fc-event {
            cursor: move;
            text-align: center;
            line-height: 2.3;
        }
        
        /* تنسيق رسائل الإشعارات */
        .notification {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 15px 20px;
            border-radius: 5px;
            color: white;
            font-weight: bold;
            z-index: 9999;
            display: none;
        }
        
        .success-notification {
            background-color: #4CAF50;
        }
        
        .error-notification {
            background-color: #f44336;
        }
        
        .loading-notification {
            background-color: #2196F3;
        }
    </style>
</head>
<body style="text-align: center;">
    <br><br>
    <input type="text" id="patient_id_input" value="<? echo $iduser = $_SESSION["iduser"]; ?>" placeholder="أدخل رقم الأخصائي" readonly style="height: 33px;border-radius: 5px;width: 150px;">
    <button onclick="filterAppointments()" style="background-color: #3c8dbc;height: 41px;border-radius: 5px;width: 150px;color: white;">رقم الأخصائي</button>

    <div id="calendar"></div>
    <div id="tooltip"></div>
    
    <!-- إضافة عناصر الإشعارات -->
    <div id="success-notification" class="notification success-notification"></div>
    <div id="error-notification" class="notification error-notification"></div>
    <div id="loading-notification" class="notification loading-notification"></div>

    <script>
        $(document).ready(function() {
            loadCalendar();
        });
        
        // دالة لعرض الإشعارات
        function showNotification(type, message, duration = 3000) {
            var notificationElement = $('#' + type + '-notification');
            notificationElement.text(message);
            notificationElement.fadeIn(300);
            
            setTimeout(function() {
                notificationElement.fadeOut(300);
            }, duration);
        }

        function loadCalendar(patient_id = "") {
            $('#calendar').fullCalendar('destroy');
            $('#calendar').fullCalendar({
                editable: true,
                droppable: true,
                locale: "ar",
                timeFormat: 'H:mm', // تنسيق 24 ساعة للوقت
                header: {
                    left: "prev,next today",
                    center: "title",
                    right: "month,agendaWeek,agendaDay"
                },
                events: function(start, end, timezone, callback) {
                    showNotification('loading', '⏳ جاري تحميل المواعيد...');
                    
                    $.ajax({
                        url: 'fetchs_spliestappoiments.php',
                        type: 'GET',
                        data: { 
                            patient_id: patient_id,
                            start: start.format('YYYY-MM-DD'),
                            end: end.format('YYYY-MM-DD')
                        },
                        dataType: 'json',
                        success: function(response) {
                            callback(response);
                            $('#loading-notification').fadeOut(300);
                        },
                        error: function(xhr, status, error) {
                            showNotification('error', '❌ حدث خطأ أثناء تحميل المواعيد: ' + error);
                            callback([]);
                        }
                    });
                },
                eventRender: function(event, element) {
                    // تخزين البيانات في عنصر الحدث
                    element.attr("data-id", event.id);
                    element.attr("data-room", event.room_id);
                    element.attr("data-patient", event.patient_id);
                    element.attr("data-service", event.typeservice);
                    element.attr("data-start", moment(event.start).format("YYYY-MM-DD HH:mm"));
                    element.attr("data-end", moment(event.end).format("YYYY-MM-DD HH:mm"));

                    // إضافة معلومات التلميح عند تمرير الماوس
                    element.on("mouseenter", function(e) {
                        var tooltip = $("#tooltip");
                        tooltip.html(
                            "<strong>🗓️ رقم الموعد:</strong> " + event.id + "<br>" +
                            "<strong>🏥 الغرفة:</strong> " + event.room_id + "<br>" +
                            "<strong>📅 التاريخ:</strong> " + moment(event.start).format("YYYY-MM-DD") + "<br>" +
                            "<strong>⏰ الوقت:</strong> " + moment(event.start).format("HH:mm") + " - " + moment(event.end).format("HH:mm") + "<br>" +
                            "<strong>🧑‍⚕️ هوية المريض:</strong> " + event.patient_id + "<br>" +
                            "<strong>💼 الخدمة:</strong> " + event.typeservice
                        );
                        tooltip.css({ top: e.pageY + 15, left: e.pageX + 15 }).fadeIn(200);
                    });

                    element.on("mousemove", function(e) {
                        $("#tooltip").css({ top: e.pageY + 15, left: e.pageX + 15 });
                    });

                    element.on("mouseleave", function() {
                        $("#tooltip").fadeOut(200);
                    });
                },
                eventDrop: function(event, delta, revertFunc, jsEvent, ui, view) {
                    // عرض إشعار التحميل
                    showNotification('loading', '⏳ جاري تحديث الموعد...');
                    
                    var id = event.id;
                    var start = moment(event.start).format("YYYY-MM-DD HH:mm:ss");
                    
                    // التأكد من وجود وقت نهاية صالح
                    var end;
                    if (event.end) {
                        end = moment(event.end).format("YYYY-MM-DD HH:mm:ss");
                    } else {
                        // إذا لم يكن هناك وقت نهاية، نضيف ساعة واحدة إلى وقت البداية
                        end = moment(event.start).add(1, 'hours').format("YYYY-MM-DD HH:mm:ss");
                    }
                    
                    // إضافة بيانات إضافية للتحديث
                    var updateData = { 
                        id: id, 
                        start: start, 
                        end: end,
                        patient_id: event.patient_id,
                        room_id: event.room_id,
                        typeservice: event.typeservice
                    };
                    
                    // إرسال طلب التحديث
                    $.ajax({
                        url: 'update_appoiments.php',
                        type: 'POST',
                        data: updateData,
                        dataType: 'json', // توقع استجابة JSON
                        success: function(response) {
                            // إخفاء إشعار التحميل
                            $('#loading-notification').fadeOut(300);
                            
                            if (response.status === 'success') {
                                showNotification('success', '✅ تم تحديث الموعد بنجاح!');
                                
                                // تحديث بيانات الحدث في التقويم
                                $('#calendar').fullCalendar('updateEvent', event);
                            } else {
                                showNotification('error', '❌ حدث خطأ أثناء التحديث: ' + response.message);
                                revertFunc(); // إعادة الحدث إلى موقعه الأصلي
                            }
                        },
                        error: function(xhr, status, error) {
                            // إخفاء إشعار التحميل
                            $('#loading-notification').fadeOut(300);
                            
                            // عرض رسالة الخطأ
                            showNotification('error', '❌ فشل الاتصال بالخادم: ' + error);
                            console.error("خطأ AJAX:", xhr.responseText);
                            revertFunc(); // إعادة الحدث إلى موقعه الأصلي
                        }
                    });
                },
                // إضافة دعم تغيير حجم الأحداث
                eventResize: function(event, delta, revertFunc) {
                    // عرض إشعار التحميل
                    showNotification('loading', '⏳ جاري تحديث مدة الموعد...');
                    
                    var id = event.id;
                    var start = moment(event.start).format("YYYY-MM-DD HH:mm:ss");
                    var end = moment(event.end).format("YYYY-MM-DD HH:mm:ss");
                    
                    $.ajax({
                        url: 'update_appoiments.php',
                        type: 'POST',
                        data: { 
                            id: id, 
                            start: start, 
                            end: end,
                            patient_id: event.patient_id,
                            room_id: event.room_id,
                            typeservice: event.typeservice
                        },
                        dataType: 'json',
                        success: function(response) {
                            // إخفاء إشعار التحميل
                            $('#loading-notification').fadeOut(300);
                            
                            if (response.status === 'success') {
                                showNotification('success', '✅ تم تحديث مدة الموعد بنجاح!');
                            } else {
                                showNotification('error', '❌ حدث خطأ أثناء تحديث المدة: ' + response.message);
                                revertFunc();
                            }
                        },
                        error: function(xhr, status, error) {
                            // إخفاء إشعار التحميل
                            $('#loading-notification').fadeOut(300);
                            
                            showNotification('error', '❌ فشل الاتصال بالخادم: ' + error);
                            console.error("خطأ AJAX:", xhr.responseText);
                            revertFunc();
                        }
                    });
                }
            });
        }

        function filterAppointments() {
            var patient_id = $("#patient_id_input").val();
            loadCalendar(patient_id);
        }
    </script>

</body>
</html>
