<?php
mb_internal_encoding('UTF-8');
date_default_timezone_set('Asia/Riyadh');
include 'conn.php';

// التقاط فلاتر التاريخ
$date_from = isset($_GET['date_from']) ? trim($_GET['date_from']) : '';
$date_to   = isset($_GET['date_to'])   ? trim($_GET['date_to'])   : '';

// دالة لإرجاع نفس الاستعلام مستخدمًا في الجدول والتصدير
function get_invoices_stmt(mysqli $conn, string $date_from, string $date_to): mysqli_stmt {
    $where = " WHERE 1=1 ";
    $types = "";
    $params = [];

    // تحجيم على أساس تاريخ/وقت timeadded (التاريخ فقط)
    if ($date_from !== '') { $where .= " AND DATE(`timeadded`) >= ? "; $types .= "s"; $params[] = $date_from; }
    if ($date_to   !== '') { $where .= " AND DATE(`timeadded`) <= ? "; $types .= "s"; $params[] = $date_to; }

    $sql = "SELECT `idinvoice`,`customername`,`customerid`,`vat`,
                   `totalamountwvat`,`invoicestatus`,`userconfirmed`,
                   `idcustomer`,`timeadded`
            FROM `qrcode` {$where}
            ORDER BY `timeadded` DESC";

    $stmt = $conn->prepare($sql);
    if ($types !== "") { $stmt->bind_param($types, ...$params); }
    $stmt->execute();
    return $stmt;
}

// تصدير CSV من الخادم (اختياري)
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    $stmt = get_invoices_stmt($conn, $date_from, $date_to);
    $result = $stmt->get_result();

    header('Content-Type: text/csv; charset=utf-8');
    $fname = 'invoices_' . date('Y-m-d_H-i-s') . '.csv';
    header('Content-Disposition: attachment; filename="'.$fname.'"');

    $out = fopen('php://output', 'w');
    // رأس الأعمدة
    fputcsv($out, ['Invoice NO','Name','Issuied User','Total Amount','Status','Time & Date','View','Download','Bill Collection']);
    while ($row = $result->fetch_assoc()) {
        $id = (int)$row['idinvoice'];
        $viewUrl = "digitalinvoice/digitalqrcode/invoices/invoice_{$id}.pdf";
        $confirmUrl = "confirmincome.php?idinvoice=" . urlencode($id);
        fputcsv($out, [
            $row['idinvoice'],
            $row['customername'],
            $row['userconfirmed'],
            $row['totalamountwvat'],
            $row['invoicestatus'],
            $row['timeadded'],
            $viewUrl,
            $viewUrl,
            $confirmUrl
        ]);
    }
    fclose($out);
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>فواتير</title>

<!-- jQuery + DataTables + Buttons (CDN) -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.8/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.8/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>

<style>
  body { font-family: Tahoma, Arial, sans-serif; }
  .filters { display:flex; gap:10px; align-items:end; flex-wrap:wrap; margin:10px 0 20px; }
  .filters .form-group { display:flex; flex-direction:column; }
  .dt-buttons { margin-bottom:10px; }
  table.dataTable thead th { text-align:center; }
  td { text-align:center; }
</style>
</head>
<body>

<!-- نموذج الفلترة -->
<form method="get" class="filters">
  <div class="form-group">
    <label>من تاريخ</label>
    <input type="date" name="date_from" value="<?= htmlspecialchars($date_from, ENT_QUOTES, 'UTF-8') ?>">
  </div>
  <div class="form-group">
    <label>إلى تاريخ</label>
    <input type="date" name="date_to" value="<?= htmlspecialchars($date_to, ENT_QUOTES, 'UTF-8') ?>">
  </div>
  <div class="form-group" style="gap:8px; flex-direction:row;">
    <button type="submit">تطبيق الفلتر</button>
    <a href="?">إزالة الفلتر</a>
    <!-- تصدير CSV (خادم) مع الحفاظ على الفلاتر -->
    <button type="submit" name="export" value="csv">تصدير CSV</button>
  </div>
</form>

<table id="example1" class="display stripe hover" style="width:100%">
  <thead>
    <tr>
      <th>Invoice NO.<br>رقم الفاتورة</th>
      <th>Name<br>المستفيد</th>
      <th>Issuied User<br>مصدر الفاتورة</th>
      <th>Total Amount<br>اجمالي المبلغ</th>
      <th>Status<br>حالة الفاتورة</th>
      <th>Time & Date<br>الوقت و التاريخ</th>
      <th>View<br>عرض</th>
      <th>Download<br>تحميل الفاتورة</th>
      <th>Bill Collection<br>تحصيل الفاتورة</th>
    </tr>
  </thead>
  <tbody>
<?php
$stmt = get_invoices_stmt($conn, $date_from, $date_to);
$res  = $stmt->get_result();
while ($row = $res->fetch_assoc()):
    $idinvoice = (int)$row['idinvoice'];
    $pdfPath   = "digitalinvoice/digitalqrcode/invoices/invoice_{$idinvoice}.pdf";
    $confirmUrl = "confirmincome.php?idinvoice=" . urlencode($idinvoice);
?>
    <tr>
      <td><?= $idinvoice ?></td>
      <td><?= htmlspecialchars($row['customername'], ENT_QUOTES, 'UTF-8') ?></td>
      <td><?= htmlspecialchars($row['userconfirmed'], ENT_QUOTES, 'UTF-8') ?></td>
      <td><?= htmlspecialchars($row['totalamountwvat'], ENT_QUOTES, 'UTF-8') ?></td>
      <td><span class="label label-success"><?= htmlspecialchars($row['invoicestatus'], ENT_QUOTES, 'UTF-8') ?></span></td>
      <td><?= htmlspecialchars($row['timeadded'], ENT_QUOTES, 'UTF-8') ?></td>
      <td>
        <a href="<?= $pdfPath ?>" target="_blank" class="btn bg-navy margin">
          <i class="fa fa-folder-open"></i> View PDF
        </a>
      </td>
      <td>
        <a href="<?= $pdfPath ?>" class="btn bg-navy margin" style="background-color:#605ca8!important;color:white;" download="invoice_<?= $idinvoice ?>.pdf">
          <i class="fa fa-file-pdf-o"></i> Download PDF
        </a>
      </td>
      <td>
        <a href="<?= $confirmUrl ?>" class="btn bg-navy margin" style="background-color:rgb(17,172,133)!important;color:white;">
          <i class="fa fa-check-circle"></i> Confirm Income
        </a>
      </td>
    </tr>
<?php endwhile; ?>
  </tbody>
</table>

<script>
$(function(){
  // تهيئة DataTable مع زر تصدير Excel (عميل)
  $('#example1').DataTable({
    order: [[5, 'desc']], // يعتمد على عمود التاريخ
    dom: 'Bfrtip',
    buttons: [
      {
        extend: 'excelHtml5',
        title: 'invoices_' + new Date().toISOString().slice(0,10),
        exportOptions: { columns: ':visible' }
      }
    ],
    language: {
      url: 'https://cdn.datatables.net/plug-ins/1.13.8/i18n/ar.json'
    }
  });
});
</script>

</body>
</html>
