<?php
// استدعاء ملفات PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php'; // ← أو المسار المناسب للمكتبة

// إعداد الاتصال بقاعدة البيانات
$host = "localhost:3306";
$dbname = "acesaudi_site2";
$username = "acesaudi_usr";
$password = '1^v0c7tQAA3#$s5g'; // ← غيّرها

$conn = new mysqli($host, $username, $password, $dbname);
$conn->set_charset("utf8");
if ($conn->connect_error) {
    die("فشل الاتصال: " . $conn->connect_error);
}

// معلومات الأخصائي (يمكنك تحديد ID أو اسمه أو إيميله)
$specialist_id = '123'; // ← غيّره حسب الأخصائي المطلوب
$today = date('Y-m-d');

// جلب مواعيد الأخصائي لليوم
$sql = "SELECT patient_name, typeservice, booking_date, time_slot, end_time, bookingstatus
        FROM bookings
        WHERE spesilstid = ?
          AND booking_date = ?
        ORDER BY time_slot ASC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $specialist_id, $today);
$stmt->execute();
$result = $stmt->get_result();

// بناء محتوى الجدول
$html = "<h3>جدول مواعيد الأخصائي بتاريخ $today</h3>";
$html .= "<table border='1' cellpadding='5' cellspacing='0'>
<thead><tr>
<th>الاسم</th>
<th>الخدمة</th>
<th>من</th>
<th>إلى</th>
<th>الحالة</th>
</tr></thead><tbody>";

while ($row = $result->fetch_assoc()) {
    $html .= "<tr>
        <td>{$row['patient_name']}</td>
        <td>{$row['typeservice']}</td>
        <td>{$row['time_slot']}</td>
        <td>{$row['end_time']}</td>
        <td>{$row['bookingstatus']}</td>
    </tr>";
}
$html .= "</tbody></table>";

$stmt->close();
$conn->close();

// إرسال الإيميل باستخدام PHPMailer
$mail = new PHPMailer(true);
try {
    // إعداد SMTP
    $mail->isSMTP();
    $mail->Host       = 'smtp.example.com'; // ← سيرفر الإيميل مثل smtp.office365.com
    $mail->SMTPAuth   = true;
    $mail->Username   = 'you@example.com';  // ← إيميل المرسل
    $mail->Password   = 'yourpassword';     // ← كلمة المرور
    $mail->SMTPSecure = 'tls';
    $mail->Port       = 587;

    // معلومات الإرسال
    $mail->setFrom('you@example.com', 'اسم العيادة');
    $mail->addAddress('specialist@example.com', 'اسم الأخصائي'); // ← بريد الأخصائي

    $mail->isHTML(true);
    $mail->Subject = "جدول مواعيدك - $today";
    $mail->Body    = $html;

    $mail->send();
    echo "✅ تم إرسال جدول المواعيد بنجاح إلى الأخصائي.";
} catch (Exception $e) {
    echo "❌ خطأ في الإرسال: {$mail->ErrorInfo}";
}
?>
