<?php
function odoo_post_json($url, $apiKey, $payload) {
    $ch = curl_init($url);
    $json = json_encode($payload, JSON_UNESCAPED_UNICODE);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'X-API-Key: ' . $apiKey
        ],
        CURLOPT_POSTFIELDS => $json,
        CURLOPT_TIMEOUT => 30,
    ]);
    $resp = curl_exec($ch);
    $errno = curl_errno($ch);
    $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($errno) {
        throw new Exception("cURL error #$errno");
    }
    $data = json_decode($resp, true);
    if ($status >= 400) {
        throw new Exception("Odoo HTTP $status: " . $resp);
    }
    return $data;
}

// ===== أمثلة استخدام =====
$odoo_base = 'https://your-odoo.example.com'; // غيّرها
$apiKey = 'PUT_YOUR_SECRET_HERE';             // طابق قيمة ace.api_key

try {
    // 1) رفع/تحديث مستفيدين (res.partner عبر ref)
    $partners = [
        [
            'external_id' => 'PAT-0001',
            'name'        => 'محمد علي',
            'email'       => 'm.ali@example.com',
            'mobile'      => '+966500000001',
            'street'      => 'شارع الملك',
            'city'        => 'الرياض',
        ],
        [
            'external_id' => 'PAT-0002',
            'name'        => 'فاطمة سالم',
            'mobile'      => '+966500000002',
        ],
    ];
    $r1 = odoo_post_json("$odoo_base/ace/v1/partners/upsert", $apiKey, ['items' => $partners]);

    // 2) رفع/تحديث حجوزات (ace.booking)
    $bookings = [
        [
            'external_id'         => 'BKG-2025-00001',
            'name'                => 'حجز 1',
            'partner_external_id' => 'PAT-0001',
            'typeservice'         => 'SLP',
            'booking_date'        => '2025-11-03 10:30:00',
            'room'                => 'R-01',
            'status'              => 'reserved',
            'notes'               => 'جلسة تقييم أولية',
        ]
    ];
    $r2 = odoo_post_json("$odoo_base/ace/v1/bookings/upsert", $apiKey, ['items' => $bookings]);

    // 3) رفع/تحديث فواتير (account.move = out_invoice)
    $invoices = [
        [
            'external_id'         => 'INV-ACE-1001',
            'partner_external_id' => 'PAT-0001',
            'invoice_date'        => '2025-11-01',
            'post'                => true, // يرحّل الفاتورة مباشرة
            'lines'               => [
                ['name' => 'جلسة تخاطب', 'quantity' => 1, 'price_unit' => 250.00, 'tax_ids' => []],
                ['name' => 'جلسة OT',   'quantity' => 1, 'price_unit' => 220.00, 'tax_ids' => []],
            ]
        ]
    ];
    $r3 = odoo_post_json("$odoo_base/ace/v1/invoices/upsert", $apiKey, ['items' => $invoices]);

    echo "Partners: ".json_encode($r1, JSON_UNESCAPED_UNICODE).PHP_EOL;
    echo "Bookings: ".json_encode($r2, JSON_UNESCAPED_UNICODE).PHP_EOL;
    echo "Invoices: ".json_encode($r3, JSON_UNESCAPED_UNICODE).PHP_EOL;

} catch (Exception $e) {
    http_response_code(500);
    echo "Error: ".$e->getMessage();
}
