<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام الحجوزات</title>
    <style>
        button {
            margin: 5px;
            padding: 10px 20px;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <h1>حجوزات العيادة</h1>
    <div id="appointments-container">
        <!-- الأزرار ستظهر هنا -->
    </div>

    <script>
        // جلب الحجوزات المتوفرة باستخدام AJAX
        function fetchAvailableAppointments() {
            const xhr = new XMLHttpRequest();
            xhr.open('GET', 'fetchappointments.php', true);
            xhr.onload = function () {
                if (xhr.status === 200) {
                    document.getElementById('appointments-container').innerHTML = xhr.responseText;
                }
            };
            xhr.send();
        }

        // حجز موعد معين
        function bookAppointment(appointmentId) {
            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'book_appointment.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onload = function () {
                if (xhr.status === 200) {
                    alert(xhr.responseText);
                    fetchAvailableAppointments(); // تحديث القائمة بعد الحجز
                }
            };
            xhr.send('id=' + appointmentId);
        }

        // تحميل القائمة عند فتح الصفحة
        window.onload = fetchAvailableAppointments;
    </script>
</body>
</html>