
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
 <?php include 'financeheader.php'; ?>
 
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'financesidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenufinance.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Installmant Report</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Installmant Report</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">

<?php
/********* DB *********/
$host     = 'localhost:3306';
$dbname   = 'acesaudi_site';
$username = 'acesaudi_usr';
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username, $password, [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
} catch (PDOException $e) {
    die("فشل الاتصال: " . $e->getMessage());
}

/********* Inputs *********/
function h($v){ return htmlspecialchars((string)($v ?? ''), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }

$date_from = $_GET['date_from'] ?? '';   // YYYY-MM-DD
$date_to   = $_GET['date_to']   ?? '';   // YYYY-MM-DD
$status    = $_GET['status']    ?? '';   // مدفوع / غير مدفوع / فارغ = الكل
$export    = isset($_GET['export']);

/********* Build WHERE *********/
$where  = [];
$params = [];

// ملاحظة: الحقل هو dateschauled
if ($date_from !== '') { $where[] = "`dateschauled` >= ?"; $params[] = $date_from; }
if ($date_to   !== '') { $where[] = "`dateschauled` <= ?"; $params[] = $date_to; }

if ($status !== '') {
    // لو عندك اختلاف مسافات في القيم احفظها موحّدة أو استعمل TRIM
    $where[] = "`payment_status` = ?";
    $params[] = $status;
}

$where_sql = $where ? ('WHERE ' . implode(' AND ', $where)) : '';

/********* Query *********/
$sql = "
    SELECT `id`, `customerid`, `serviceid`, `installmentamount`,
           `userschauled`, `dateschauled`, `payment_status`, `fileid`
    FROM `installments`
    $where_sql
    ORDER BY `dateschauled` DESC, `id` DESC
";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

/********* Totals *********/
$total_amount = 0.0;
foreach ($rows as $r) { $total_amount += (float)$r['installmentamount']; }

/********* Export *********/
if ($export) {
    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
    header('Content-Disposition: attachment; filename="installments_export.xls"');
    echo "<table border='1' style='text-align:center; font-family:Tahoma;'>";
    echo "<tr>
            <th style='text-align:center;'>#</th>
            <th style='text-align:center;'>رقم المستفيد</th>
            <th style='text-align:center;'>رقم الخدمة</th>
            <th style='text-align:center;'>مبلغ القسط</th>
            <th style='text-align:center;'>المستخدم المجدول</th>
            <th style='text-align:center;'>تاريخ الجدولة</th>
            <th style='text-align:center;'>حالة الدفع</th>
            <th style='text-align:center;'>رقم الملف</th>
          </tr>";
    $i=1;
    foreach ($rows as $r) {
        echo "<tr>
                <td style='text-align:center;'>".($i++)."</td>
                <td style='text-align:center;'>".h($r['customerid'])."</td>
                <td style='text-align:center;'>".h($r['serviceid'])."</td>
                <td style='text-align:center;'>".number_format((float)$r['installmentamount'], 2)."</td>
                <td style='text-align:center;'>".h($r['userschauled'])."</td>
                <td style='text-align:center;'>".h($r['dateschauled'])."</td>
                <td style='text-align:center;'>".h($r['payment_status'])."</td>
                <td style='text-align:center;'>".h($r['fileid'])."</td>
              </tr>";
    }
    echo "<tr style='font-weight:bold;background:#f3f5fb'>
            <td colspan='3'>الإجمالي</td>
            <td>".number_format($total_amount, 2)."</td>
            <td colspan='4'></td>
          </tr>";
    echo "</table>";
    exit;
}
?>

<form method="get" class="form" style="text-align: center;">
  <div class="form-row">
    <label style="text-align: center;">  من</label> <input type="date" name="date_from" value="<?= h($date_from) ?>" class="form-control">
    <label style="text-align: center;">  إلى</label><input type="date" name="date_to"   value="<?= h($date_to) ?>" class="form-control">
    الحالة:
    <select name="status" class="form-control">
        <option value="">الكل</option>
        <option value="مدفوع"     <?= $status==='مدفوع'?'selected':''; ?>>مدفوع</option>
        <option value="غير مدفوع" <?= $status==='غير مدفوع'?'selected':''; ?>>غير مدفوع</option>
    </select>
    <br>
    <button type="submit" class="btn btn-block btn-primary">تصفية</button>
    <button type="submit" name="export" value="1" class="btn btn-block btn-success">تصدير كملف إكسل</button>
  </div>
</form>
<br>

<table class="table table-bordered" style="text-align: center;">
  <thead>
    <tr>
      <th style="text-align: center;">#</th>
      <th style="text-align: center;">رقم المستفيد</th>
      <th style="text-align: center;">رقم الخدمة</th>
      <th style="text-align: center;">مبلغ القسط</th>
      <th style="text-align: center;">المستخدم المجدول</th>
      <th style="text-align: center;">تاريخ الجدولة</th>
      <th style="text-align: center;">حالة الدفع</th>
      <th style="text-align: center;">رقم الملف</th>
    </tr>
  </thead>
  <tbody>
  <?php if(!$rows): ?>
    <tr><td colspan="8">لا توجد نتائج</td></tr>
  <?php else: $i=1; foreach($rows as $r): ?>
    <tr>
      <td><?= $i++ ?></td>
      <td><?= h($r['customerid']) ?></td>
      <td><?= h($r['serviceid']) ?></td>
      <td><?= number_format((float)$r['installmentamount'], 2) ?></td>
      <td><?= h($r['userschauled']) ?></td>
      <td><?= h($r['dateschauled']) ?></td>
      <td><?= h($r['payment_status']) ?></td>
      <td><?= h($r['fileid']) ?></td>
    </tr>
  <?php endforeach; endif; ?>
  </tbody>
  <tfoot>
    <tr style="font-weight:bold;background:#f3f5fb">
      <td colspan="3">الإجمالي</td>
      <td><?= number_format($total_amount, 2) ?></td>
      <td colspan="4"></td>
    </tr>
  </tfoot>
</table>



            </div>
            <!-- /.box-body -->
          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>

