<?php
include('conn.php');
date_default_timezone_set('Asia/Riyadh');

$roomno = isset($_POST['roomno']) ? trim($_POST['roomno']) : '';
$period = isset($_POST['period']) ? trim($_POST['period']) : '';
$date = isset($_POST['date']) ? trim($_POST['date']) : date('Y-m-d');

$periods = [
    '12-22' => ['start' => '12:00:00', 'end' => '22:00:00'],
    '12:30-22' => ['start' => '12:30:00', 'end' => '22:00:00'],
    '18-22' => ['start' => '18:00:00', 'end' => '22:00:00'],
];

if (empty($period) || !array_key_exists($period, $periods)) {
    echo "<div class='alert alert-danger'>الرجاء اختيار فترة صحيحة.</div>";
    exit;
}

$start = $periods[$period]['start'];
$end = $periods[$period]['end'];

$stmt = $conn->prepare("SELECT idroom, coderoom FROM rooms WHERE available_from <= ? AND available_to >= ? AND status = 'available' AND coderoom LIKE ?");
$likeRoom = "%$roomno%";
$stmt->bind_param("sss", $start, $end, $likeRoom);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    echo "<div class='row'>";
    while ($row = $result->fetch_assoc()) {
        $roomCode = $row["coderoom"];
        $startDateTime = "$date $start";
        $endDateTime = "$date $end";

        $checkStmt = $conn->prepare("SELECT COUNT(*) as count FROM bookings WHERE coderoom = ? AND date(start_time) = ? AND ((start_time < ? AND end_time > ?) OR (start_time >= ? AND start_time < ?))");
        $checkStmt->bind_param("ssssss", $roomCode, $date, $endDateTime, $startDateTime, $startDateTime, $endDateTime);
        $checkStmt->execute();
        $checkResult = $checkStmt->get_result();
        $count = $checkResult->fetch_assoc()['count'];
        $checkStmt->close();

        if ($count == 0) {
            echo '<div class="col-md-3 mb-3">';
            echo '<a href="newappointmentsuperaba.php?roomno=' . urlencode($roomCode) . '&date=' . urlencode($date) . '&start=' . urlencode($start) . '&end=' . urlencode($end) . '" class="btn btn-success btn-block">';
            echo '<i class="fa fa-calendar-plus-o"></i> الغرفة ' . htmlspecialchars($roomCode) . '<br>الفترة: ' . $start . ' - ' . $end;
            echo '</a>';
            echo '</div>';
        }
    }
    echo "</div>";
} else {
    echo "<div class='alert alert-warning text-center'>لا توجد غرف متاحة في هذه الفترة والتاريخ المختار.</div>";
}

$stmt->close();
$conn->close();
?>
