<?php
header('Content-Type: application/json');
session_start(); // بدء الجلسة

// ✅ تحقق من وجود متغير الجلسة iduser
if (!isset($_SESSION['iduser'])) {
    echo json_encode(['error' => 'لم يتم تسجيل الدخول.']);
    exit;
}

echo $iduser = $_GET['patient_id'] ?? ''; // رقم الأخصائي من الجلسة

// إعداد الاتصال بقاعدة البيانات
$host = 'localhost:3306';
$db   = 'acesaudi_site';
$user = 'acesaudi_usr';
$pass = 'tabfyv-6xiFry-noczak';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    echo json_encode(['error' => 'فشل الاتصال: ' . $e->getMessage()]);
    exit;
}

// ✅ استعلام لجلب المواعيد الخاصة بالأخصائي الحالي
$sql = "SELECT * FROM bookings WHERE spesilstid = ?";
$stmt = $pdo->prepare($sql);

try {
    $stmt->execute([$iduser]);
} catch (PDOException $e) {
    echo json_encode(['error' => 'فشل تنفيذ الاستعلام: ' . $e->getMessage()]);
    exit;
}

$appointments = $stmt->fetchAll();

// ✅ تجهيز النتائج للتنسيق المناسب
$events = [];

foreach ($appointments as $app) {
    $start = $app['booking_date'] . ' ' . $app['time_slot'];
    $end   = $app['booking_date'] . ' ' . $app['end_time'];

    $events[] = [
        'id'          => $app['id'],
        'title'       => $app['patient_name'] . " - " . $app['typeservice'],
        'start'       => $start,
        'end'         => $end,
        'room_id'     => $app['room_id'],
        'patient_id'  => $app['patient_id'],
        'typeservice' => $app['typeservice']
    ];
}

echo json_encode($events);
