<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
 <title>Reception ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
<header class="main-header">
    <!-- Logo -->
    <a href="../../index2.html" class="logo">
      <!-- mini logo for sidebar mini 50x50 pixels -->
      <span class="logo-mini"><b>C</b>RM</span>
      <!-- logo for regular state and mobile devices -->
      <span class="logo-lg"><b>Reception</b> ACE</span>
    </a>
    <!-- Header Navbar: style can be found in header.less -->
    <nav class="navbar navbar-static-top">
      <!-- Sidebar toggle button-->
      <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </a>

      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <!-- Messages: style can be found in dropdown.less-->
          <li class="dropdown messages-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <i class="fa fa-envelope-o"></i>
              <span class="label label-success">4</span>
            </a>
            <ul class="dropdown-menu">
              <li class="header">You have 4 messages</li>
              <li>
                <!-- inner menu: contains the actual data -->
                <ul class="menu">
                  <li><!-- start message -->
                    <a href="#">
                      <div class="pull-left">
                        <img src="dist/img/user2-160x160.jpg" class="img-circle" alt="User Image">
                      </div>
                      <h4>
                        Support Team
                        <small><i class="fa fa-clock-o"></i> 5 mins</small>
                      </h4>
                      <p>Why not buy a new awesome theme?</p>
                    </a>
                  </li>
                  <!-- end message -->
                </ul>
              </li>
              <li class="footer"><a href="#">See All Messages</a></li>
            </ul>
          </li>
          <!-- Notifications: style can be found in dropdown.less -->
          <li class="dropdown notifications-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <i class="fa fa-bell-o"></i>
              <span class="label label-warning">10</span>
            </a>
            <ul class="dropdown-menu">
              <li class="header">You have 10 notifications</li>
              <li>
                <!-- inner menu: contains the actual data -->
                <ul class="menu">
                  <li>
                    <a href="#">
                      <i class="fa fa-users text-aqua"></i> 5 new members joined today
                    </a>
                  </li>
                </ul>
              </li>
              <li class="footer"><a href="#">View all</a></li>
            </ul>
          </li>
          <!-- Tasks: style can be found in dropdown.less -->
          <li class="dropdown tasks-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <i class="fa fa-flag-o"></i>
              <span class="label label-danger">9</span>
            </a>
            <ul class="dropdown-menu">
              <li class="header">You have 9 tasks</li>
              <li>
                <!-- inner menu: contains the actual data -->
                <ul class="menu">
                  <li><!-- Task item -->
                    <a href="#">
                      <h3>
                        Design some buttons
                        <small class="pull-right">20%</small>
                      </h3>
                      <div class="progress xs">
                        <div class="progress-bar progress-bar-aqua" style="width: 20%" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100">
                          <span class="sr-only">20% Complete</span>
                        </div>
                      </div>
                    </a>
                  </li>
                  <!-- end task item -->
                </ul>
              </li>
              <li class="footer">
                <a href="#">View all tasks</a>
              </li>
            </ul>
          </li>
          <!-- User Account: style can be found in dropdown.less -->
          <li class="dropdown user user-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <img src="dist/img/user4-128x128.jpg" class="user-image" alt="User Image">
              <span class="hidden-xs"></span>
            </a>
            <ul class="dropdown-menu">
              <!-- User image -->
              <li class="user-header">
                <img src="dist/img/user4-128x128.jpg" class="img-circle" alt="User Image">

                <p>
                   - Admission & Registration
                  <small>Member since Nov. 2024</small>
                </p>
              </li>
              <!-- Menu Body -->
              <li class="user-body">
                <div class="row">
                  <div class="col-xs-4 text-center">
                    <a href="#">Members</a>
                  </div>
                  <div class="col-xs-4 text-center">
                    <a href="#">Tasks</a>
                  </div>
                  <div class="col-xs-4 text-center">
                    <a href="#">Tickets</a>
                  </div>
                </div>
                <!-- /.row -->
              </li>
              <!-- Menu Footer-->
              <li class="user-footer">
                <div class="pull-left">
                  <a href="#" class="btn btn-default btn-flat">Profile</a>
                </div>
                <div class="pull-right">
                  <a href="logoutreception.php" class="btn btn-default btn-flat">Sign out</a>
                </div>
              </li>
            </ul>
          </li>
          <!-- Control Sidebar Toggle Button -->
          <li>
            <a href="#" data-toggle="control-sidebar"><i class="fa fa-gears"></i></a>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
       <!-- Sidebar user panel -->
     <div class="user-panel">
        <div class="pull-left image">
          <img src="dist/img/user4-128x128.jpg" class="img-circle" alt="User Image">
        </div>
        <div class="pull-left info">
          <p>Reception</p>
          <a href="#"><i class="fa fa-circle text-success"></i> Online</a>
        </div>
      </div>      <!-- search form -->
          <form action="#" method="get" class="sidebar-form">
        <div class="input-group">
          <input type="text" name="q" class="form-control" placeholder="Search...">
              <span class="input-group-btn">
                <button type="submit" name="search" id="search-btn" class="btn btn-flat"><i class="fa fa-search"></i>
                </button>
              </span>
        </div>
      </form>      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
      <ul class="sidebar-menu">
        <li class="header">MAIN NAVIGATION</li>
        <li class="active treeview">
          <a href="#">
            <i class="fa fa-dashboard"></i> <span>Reception Dashboard</span>
            <span class="pull-right-container">
              <i class="fa fa-angle-left pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu">
             <li class="active"><a href="receptiondashboard.php"><i class="fa fa-circle-o"></i> Home الرئيسية</a></li>
               <li class="active"><a href="customerreception.php"><i class="fa fa-circle-o"></i>Customers المستفيدين</a></li>
               <li class="active"><a href="typecustomer.php"><i class="fa fa-circle-o"></i>New Customer تسجيل مستفيد جديد</a></li> 
               <li class="active"><a href="receptionsearchcustomer.php"><i class="fa fa-circle-o"></i>Search Customer   بحث عن مستفيد </a></li> 
               <li class="active"><a href="recallappointments.php"><i class="fa fa-circle-o"></i>ALL Appointments جميع المواعيد</a></li>
               <li class="active"><a href="allreceptionappointments.php"><i class="fa fa-circle-o"></i>Search Appoin بحث عن موعد</a></li>
               <li class="active"><a href="customerreception.php"><i class="fa fa-circle-o"></i>New Appointment موعد جديد</a></li>
               <li class="active"><a href="calendarsuper.php"><i class="fa fa-circle-o"></i>Reschedule اعادة جدولة موعد</a></li>
               <li class="active"><a href="allbeneficiary.php"><i class="fa fa-circle-o"></i>Beneficiary List عملاء التأمين</a></li>
               <li class="active"><a href="patientdetails.php"><i class="fa fa-circle-o"></i>Search Patient بحث عن عميل تأمين</a></li> 
               <li class="active"><a href="allclaims.php"><i class="fa fa-circle-o"></i>All Claims المطالبات التأمينية</a></li>
               <li class="active"><a href="NewEligibilityRequest.php"><i class="fa fa-circle-o"></i>Request Eligibility طلب أحقية جديد</a></li>
               <li class="active"><a href="eligibility.php"><i class="fa fa-circle-o"></i>Eligibility List طلبات الأحقية</a></li>
               <li class="active"><a href="preAuthorization.php"><i class="fa fa-circle-o"></i>Pre Authorization ماقبل التحقق</a></li>
               <li class="active"><a href="customerchat.php"><i class="fa fa-circle-o"></i>Online Chat شات العملاء </a></li>
               <li class="active"><a href="KPISdaily.php"><i class="fa fa-circle-o"></i>KPIS مؤشر الأداء</a></li>
               <li class="active"><a href="#"><i class="fa fa-circle-o"></i>Request الدعم الفني</a></li>
               <li class="active"><a href="teamworkchat.php"><i class="fa fa-circle-o"></i>Team Chat شات فريق العمل </a></li>
               <li class="active"><a href="logoutreception.php"><i class="fa fa-circle-o"></i>Logout خروج</a></li>
          </ul>
        </li>
      </ul>    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Add A New Beneficiary Insurance </a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">A New Add Insurance Customer Request Status </h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              
            <h3>Received Add A New Beneficiary Insurance Request :</h3>
            
            <?php

if ($_SERVER["REQUEST_METHOD"] == "POST") {
try {
        // الاتصال بقاعدة البيانات
        $pdo = new PDO("mysql:host=localhost:3306;dbname=acesaudi_site;charset=utf8mb4", "acesaudi_usr", 'tabfyv-6xiFry-noczak');
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$beneficiaryId = $_POST['documentId']; // هذا يمثل BENEFICIARYID و DOCUMENTID في نفس الوقت

// التحقق من وجود المستفيد مسبقًا
$checkStmt = $pdo->prepare("SELECT COUNT(*) FROM NPHIES_BENEFICIARY WHERE DOCUMENTID = ?");
$checkStmt->execute([$beneficiaryId]);
$exists = $checkStmt->fetchColumn();

if ($exists > 0) {
    echo "<h3 style='color:orange;text-align:center;'>⚠️ المستفيد برقم الهوية ($beneficiaryId) موجود مسبقًا، تم تجاهل الإدخال</h3>";
} else {
    // تنفيذ الإدخال
    $stmt_beneficiary = $pdo->prepare("
        INSERT INTO `NPHIES_BENEFICIARY` (
            `BENEFICIARYID`, `PATIENTFILENO`, `FIRSTNAME`, `MIDDLENAME`, `LASTNAME`, `FULLNAME`,
            `DOB`, `GENDER`, `NATIONALITY`, `DOCUMENTTYPE`, `DOCUMENTID`,
            `CONTACTNUMBER`, `EHEALTHID`, `RESIDENCYTYPE`, `MARITALSTATUS`, `BLOODGROUP`,
            `PREFERREDLANGUAGE`, `EMAIL`, `ADDRESSLINE`, `ADDRESSSTREETNAME`, `ADDRESSCITY`,
            `ADDRESSDISTRICT`, `ADDRESSSTATE`, `ADDRESSPOSTALCODE`, `ADDRESSCOUNTRY`,
            `OCCUPATION`, `RELIGION`
        ) VALUES (
            :beneficiary_id, :patient_file_no, :first_name, :middle_name, :last_name, :full_name,
            :dob, :gender, :nationality, :document_type, :document_id,
            :contact_number, NULL, :document_type, :marital_status, :blood_group,
            :preferred_language, :email, NULL, NULL, NULL,
            NULL, NULL, NULL, NULL,
            :occupation, :religion
        )
    ");

    $stmt_beneficiary->execute([
        ':beneficiary_id'      => $beneficiaryId,
        ':patient_file_no'     => $_POST['documentId'],
        ':first_name'          => $_POST['firstName'],
        ':middle_name'         => $_POST['middleName'],
        ':last_name'           => $_POST['lastName'],
        ':full_name'           => $_POST['fullName'],
        ':dob'                 => date('Y-m-d H:i:s', strtotime($_POST['dob'])),
        ':gender'              => $_POST['gender'],
        ':nationality'         => $_POST['nationality'],
        ':document_type'       => $_POST['documentType'],
        ':document_id'         => $beneficiaryId,
        ':contact_number'      => $_POST['contactNumber'],
        ':marital_status'      => $_POST['maritalStatus'],
        ':blood_group'         => $_POST['bloodGroup'],
        ':preferred_language'  => $_POST['preferredLanguage'],
        ':email'               => $_POST['email'],
        ':occupation'          => $_POST['occupation'],
        ':religion'            => $_POST['religion'],
    ]);

    echo "<h3 style='color:green;text-align:center;'>✅ تم إدراج المستفيد بنجاح</h3>";
}




function generateUniqueCoverageId($pdo) {
    do {
        // مثال على توليد COVERAGEID (تقدر تغيّر النمط حسب رغبتك)
        $coverageId =  rand(1000, 9999);

        // التحقق من عدم وجوده مسبقًا
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM NPHIES_COVERAGE WHERE COVERAGEID = ?");
        $stmt->execute([$coverageId]);
        $exists = $stmt->fetchColumn();
    } while ($exists > 0);

    return $coverageId;
}

    // إعداد جملة إدخال خطط التأمين
    $stmt_coverage = $pdo->prepare("
    INSERT INTO `NPHIES_COVERAGE` (
        `COVERAGEID`, `MEMBERID`, `EXPIRYDATE`, `PAYERNPHIESID`, `TPANPHIESID`,
        `RELATIONWITHSUBSCRIBER`, `POLICYHOLDER`, `POLICYNUMBER`,
        `COVERAGETYPE`, `BENEFICIARYID`
    ) VALUES (
        :coverage_id, :member_card_id, :expiry_date, :payer_nphies_id, :tpa_nphies_id,
        :relation, :policy_holder, :policy_number,
        :coverage_type, :beneficiary_id
    )
");

        foreach ($_POST['payer'] as $index => $payer) {
    $coverageId     = generateUniqueCoverageId($pdo);
    $policyNumber   = $_POST['policy_number'][$index];
    $beneficiaryId  = $_POST['documentId'];
    $payerNphiesId  = $_POST['payerNphiesId'];

    // التحقق من وجود نفس المستفيد والبوليصة مسبقًا
    $checkStmt = $pdo->prepare("SELECT COUNT(*) FROM NPHIES_COVERAGE WHERE POLICYNUMBER = ? AND BENEFICIARYID = ?");
    $checkStmt->execute([$policyNumber, $beneficiaryId]);
    $exists = $checkStmt->fetchColumn();

    if ($exists > 0) {
        echo "<h3 style='color:orange;text-align:center;'>⚠️ تم تجاهل التكرار: المستفيد ($beneficiaryId) لديه بالفعل بوليصة رقم ($policyNumber)</h3>";
        continue; // تجاهل هذا الإدخال
    }

    // تنفيذ الإدخال
    $stmt_coverage->execute([
        ':coverage_id'         => $coverageId,
        ':member_card_id'      => $_POST['member_card_id'][$index],
        ':expiry_date'         => date('Y-m-d H:i:s', strtotime($_POST['expiry_date'][$index])),
        ':payer_nphies_id'     => $_POST['payerNphiesId'][$index],
        ':tpa_nphies_id'       => NULL,
        ':relation'            => $_POST['relation'][$index],
        ':policy_holder'       => $_POST['policy_holder'][$index] . ' - ' . $_POST['payer'][$index],
        ':policy_number'       => $policyNumber,
        ':coverage_type'       => $_POST['coverage_type'][$index] ?? 'EHCPOL', // لم تعد تُستخدم
        ':beneficiary_id'      => $beneficiaryId,
    ]);

    function generateCoverageClassId($pdo) {
    $stmt = $pdo->query("SELECT MAX(COVERAGECLASSID) FROM NPHIES_COVERAGE_CLASS");
    $max = $stmt->fetchColumn();
    return $max ? $max + 1 : 1;
}

    $value = 'CLASS'; 
    $coverageClassId = generateCoverageClassId($pdo);

$stmt_coverage_class = $pdo->prepare("
    INSERT INTO `NPHIES_COVERAGE_CLASS` (`COVERAGECLASSID`, `TYPE`, `VALUE`, `NAME`, `COVERAGEID`)
    VALUES (:id, :type, :value, :name, :coverage_id)
");

$stmt_coverage_class->execute([
    ':id'          => $coverageClassId,
    ':type'        => $value,
    ':value'       => $_POST['policyClassName'],
    ':name'        => NULL,
    ':coverage_id' => $coverageId
]);

}
        echo "<h3 style='color:green;text-align:center;'>✅ تم حفظ بيانات المستفيد و بيانات خطط التأمين بنجاح</h3>";
              echo '<br>';
       echo'<a href="NewEligibilityRequest.php" class="btn btn-block btn-primary btn-lg">Create New Request Eligibility</a>';

      } catch (PDOException $e) {
        echo "<h3 style='color:red;text-align:center;'>❌ حدث خطأ: " . $e->getMessage() . "</h3>";
    }
}


?>

            
          </div>
             
             </div>

               
             
            </div>

          



          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <footer class="main-footer">
    <div class="pull-right hidden-xs">
      <b>Version</b> 1.0.1
    </div>
    <strong>Copyright &copy; 2024-2025 <a href="http://hasanaltohami.com">ENGI / Hasan ALTohami</a>.</strong> All rights
    reserved.
  </footer>
  <!-- Control Sidebar -->

  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
