<?php include 'sessionheaderrecption.php'; ?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
 <title>Reception ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

 <?php include 'receptionheader.php'; ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
         <!-- Sidebar user panel -->
    <?php include 'receptionsidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenureception.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Add A New New Request Eligibility Insurance </a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Request Eligibility Status </h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              
            <h3>Received New Eligibility Insurance Request :</h3>
<?php
require_once 'dbase.php';
require_once 'token.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $beneficiaryId = $_POST['beneficiary_id'] ?? '';
    $DATEOFBIRTH = $_POST['DATEOFBIRTH'];

    if (!$beneficiaryId) die("رقم الهوية غير موجود");

    try {
        $pdo = getPDO();

        // جلب بيانات المستفيد
        $stmt = $pdo->prepare("SELECT * FROM NPHIES_BENEFICIARY WHERE BENEFICIARYID = ?");
        $stmt->execute([$beneficiaryId]);
        $beneficiary = $stmt->fetch();
        if (!$beneficiary) die("لا يوجد مستفيد برقم الهوية هذه");

        // جلب بيانات التغطية
        $stmt = $pdo->prepare("SELECT * FROM NPHIES_COVERAGE WHERE BENEFICIARYID = ?");
        $stmt->execute([$beneficiaryId]);
        $coverage = $stmt->fetch();
        if (!$coverage) die("لا توجد تغطية مرتبطة بهذا المستفيد");

        // بناء بيانات الخطة
        $planData = [
            "planId" => "080299101225",
            "payerId" => $coverage['PAYERNPHIESID'],
            "payerName" => $coverage['POLICYHOLDER'],
            "memberCardId" => $coverage['MEMBERID'],
            "policyNumber" => $coverage['POLICYNUMBER'],
            "payerNphiesId" => $coverage['PAYERNPHIESID'],
            "tpaNphiesId" => $coverage['TPANPHIESID'] ?? "-1",
            "expiryDate" => date("Y-m-d", strtotime($coverage['EXPIRYDATE'])),
            "relationWithSubscriber" => $coverage['RELATIONWITHSUBSCRIBER'],
            "coverageType" => $coverage['COVERAGETYPE'],
            "patientShare" => null,
            "maxLimit" => null,
            "coverageClassList" => [
                [
                    "type" => "plan",
                    "value" => $coverage['POLICYNUMBER'],
                    "name" => null
                ]
            ],
            "policyHolder" => $coverage['POLICYHOLDER'],
            "primary" => true
        ];

        $json = [
            "isNewBorn" => false,
            "beneficiary" => [
                "name" => $beneficiary['FULLNAME'],
                "documentId" => $beneficiary['DOCUMENTID'],
                "documentType" => $beneficiary['DOCUMENTTYPE'],
                "firstName" => null,
                "secondName" => null,
                "thirdName" => null,
                "familyName" => null,
                "fullName" => $beneficiary['FULLNAME'],
                 "dob" => $beneficiary['DOB'],
                "gender" => $beneficiary['GENDER'],
                "nationality"=> null,
                "contactNumber"=> null,       
                "email"=> null,
                "emergencyPhoneNumber"=> null,
        "bloodGroup"=> null,
        "fileId"=> null,
        "eHealthId"=> null,
        "residencyType"=> null,
        "maritalStatus" => $beneficiary['MARITALSTATUS'],
        "religion"=> null,
        "occupation" => $beneficiary['OCCUPATION'],
        "preferredLanguage"=> null,
        "addressLine"=> null,
        "streetLine"=> null,
        "city"=> null,
        "state"=> null,
        "country"=> null,
        "postalCode"=> null,
        "isNewBorn"=> null
            ],
           [
        "plans"=> $planData      
           ], 
            "isEligibilityDone"=> true, 
            "subscriber"=> null,
            "insurancePlan" => $planData,
            "serviceDate" => date("Y-m-d"),
            "toDate" => null,
            "benefits" => true,
            "discovery" => false,
            "validation" => true,
            "transfer" => false,
            "isEmergency" => false,
            "destinationId" => "-1"
        ];

        $token = getAccessToken();
        $providerId = 3640;
        $url = "https://api.eclaims.waseel.com/eligibilities/providers/$providerId/request";

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($json));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: Bearer $token",
            "Content-Type: application/json"
        ]);

        $response = curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // تخزين الرد
        $stmt = $pdo->prepare("INSERT INTO waseel_responses (beneficiary_id, response_code, response_body, created_at)
                               VALUES (?, ?, ?, NOW())");
        $stmt->execute([$beneficiaryId, $code, $response]);

        // عرض الرد
        echo "<h3 style='color:green;'>Response Code: $code ✅</h3>";

        // تحويل الرد من JSON إلى مصفوفة
        $responseData = json_decode($response, true);
        if (isset($responseData['siteEligibility'])) {
            if (strtolower($responseData['siteEligibility']) === 'eligible') {
                echo '<h4 style="color:green; font-weight:bold;text-align:center;">✅ يحق للمستخدم الحصول على العلاج</h4><br>';
            } else {
                echo '<h4 style="color:red; font-weight:bold;text-align:center;">❌ لا يحق للمستخدم الحصول على العلاج ⚠️</h4>';
            }
        } else {
            echo '<h4 style="color:orange;">⚠️ لم يتم العثور على نتيجة التحقق من الأهلية</h4>';
        }

        echo '<pre>' . htmlspecialchars(json_encode($responseData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) . '</pre>';
        echo '<a href="view.php">عرض كل الردود</a>';

    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>



            
          </div>
             
             </div>

               
             
            </div>

          



          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <footer class="main-footer">
    <div class="pull-right hidden-xs">
      <b>Version</b> 1.0.1
    </div>
    <strong>Copyright &copy; 2024-2025 <a href="http://hasanaltohami.com">ENGI / Hasan ALTohami</a>.</strong> All rights
    reserved.
  </footer>
  <!-- Control Sidebar -->

  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
