<?php include 'sessionheaderrecption.php'; ?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
  <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">
      <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <title>تحديد الفترات</title>
    <style>
        body { font-family: Tahoma; background: #f0f0f0; }
        label, input { display: block; margin: 5px 0; direction: rtl; font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease; font-size: large; }
        .slots { margin: 15px 0; }
        .slot { background: #d4edda; padding: 10px; margin: 5px; border-radius: 5px; border: 1px solid #28a745; display: inline-block; }
        .slot input { margin-left: 5px; font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease; font-size: large; }
        button { padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; margin-top: 20px; }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">

<div class="wrapper">


<?php include 'receptionheader.php'; ?>
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'receptionsidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenureception.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains ppatient_name content -->
  <div class="content-wrapper">
    <!-- Content Header (Ppatient_name header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="receptiondashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Search By Appoiment</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title" style="font-family: Tajawal,sans-serif;text-decoration: none;font-weight: 500;transition: all .3s ease;">Filtiration Appoiments Info - فلترة الفترات حسب التاريخ وعدد الجلسات</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">

            <div class="col-md-12" style="text-align: center;">

 <?php
$host = "localhost:3306";
$dbname = "acesaudi_site";
$username = "acesaudi_usr";
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("فشل الاتصال بقاعدة البيانات: " . $e->getMessage());
}

$selected_slots     = $_POST['selected_slots'] ?? [];
$slot_types         = $_POST['slot_types'] ?? [];
$session_duration   = $_POST['session_duration'] ?? 45;
$patient_name       = $_POST['patient_name'] ?? '';
$patient_id         = $_POST['patient_id'] ?? '';
$service_id         = $_POST['serviceedid'] ?? '';
$spesilstid         = $_POST['spesilstid'] ?? '';
$userupsated        = $_POST['userupsated'] ?? 1;
$end_repeat_date    = $_POST['to'] ?? ''; // نهاية التكرار

if (empty($selected_slots)) {
    die("❌ لم يتم تحديد أي فترات.");
}

$total_updated = 0;
$warnings = [];

foreach ($selected_slots as $i => $slot_id) {
    $typeservice = $slot_types[$i] ?? 'غير محدد';

    $stmt = $pdo->prepare("SELECT * FROM bookings WHERE id = :id");
    $stmt->execute([':id' => $slot_id]);
    $booking = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$booking) continue;

    $room_id       = $booking['room_id'];
    $booking_date  = $booking['booking_date'];
    $time_slot     = $booking['time_slot'];
    $end_time      = $booking['end_time'];
    $dayname       = date('l', strtotime($booking_date));
    $spclistsname  = $booking['spclistsname'] ?? '---';
    $period        = $booking['period'] ?? 'غير محددة';
    $daterigestred = date('Y-m-d H:i:s');

    // تاريخ نهاية التكرار
    $repeat_until = new DateTime($end_repeat_date);
    $current_date = new DateTime($booking_date);

    while ($current_date <= $repeat_until) {
        $formatted_date = $current_date->format('Y-m-d');

        $stmt_check = $pdo->prepare("SELECT * FROM bookings WHERE booking_date = :date AND time_slot = :time_slot AND room_id = :room_id");
        $stmt_check->execute([
            ':date' => $formatted_date,
            ':time_slot' => $time_slot,
            ':room_id' => $room_id
        ]);

        $existing = $stmt_check->fetch(PDO::FETCH_ASSOC);

        if ($existing) {
            if ($existing['bookingstatus'] === 'متوفر') {
                $update = $pdo->prepare("
                    UPDATE bookings SET 
                        session_duration = :session_duration,
                        period = :period,
                        patient_name = :patient_name,
                        bookingstatus = 'محجوز',
                        room_id = :room_id,
                        patient_id = :patient_id,
                        service_id = :service_id,
                        daterigestred = :daterigestred,
                        spesilstid = :spesilstid,
                        userupsated = :userupsated,
                        dayname = :dayname,
                        spclistsname = :spclistsname,
                        typeservice = :typeservice
                    WHERE id = :id
                ");
                $update->execute([
                    ':session_duration' => $session_duration,
                    ':period'           => $period,
                    ':patient_name'     => $patient_name,
                    ':room_id'          => $room_id,
                    ':patient_id'       => $patient_id,
                    ':service_id'       => $service_id,
                    ':daterigestred'    => $daterigestred,
                    ':spesilstid'       => $spesilstid,
                    ':userupsated'      => $userupsated,
                    ':dayname'          => $dayname,
                    ':spclistsname'     => $spclistsname,
                    ':typeservice'      => $typeservice,
                    ':id'               => $existing['id']
                ]);
                $total_updated++;
            } else {
                $warnings[] = "📌 الفترة في {$formatted_date} من {$time_slot} إلى {$end_time} محجوزة مسبقًا.";
            }
        } else {
            $warnings[] = "⚠️ الفترة غير موجودة في {$formatted_date} من {$time_slot} إلى {$end_time}.";
        }

        $current_date->modify('+7 days');
    }
}

// النتائج
echo "<h2 style='color: green;font-family: Tajawal,sans-serif;'>✅ تم تحديث {$total_updated} من المواعيد المتاحة بنجاح</h2>";
foreach ($warnings as $warn) {
    echo "<p style='color: red; font-family: Tajawal,sans-serif;'>$warn</p>";
}
echo "<a href='customerreception.php' style='font-family: Tajawal,sans-serif;'>🔙 العودة لتحديد فترات أخرى</a>";
?>

            </div>
            </body>
</html>

