<?php include 'sessionheaderrecption.php'; ?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Reception ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
 <?php include 'receptionheader.php'; ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
    <!-- Sidebar user panel -->
    <?php include 'receptionsidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenureception.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="receptiondashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">New Cash Customer</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Status Of Medical File For Customer</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
      
            <div class="box-header">
              <h3 class="box-title"> 

              <?php
include('conn.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    $proudctid = $_POST['typeservice']; 

    // جلب اسم الخدمة وسعرها بناءً على ID الخدمة
    $query = "SELECT servicename, cashprice FROM services WHERE serviceid = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $proudctid);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $service = $result->fetch_assoc();
        $service_name = $service['servicename'];
        $amount = $service['cashprice'];
    } else {
        $service_name = "غير معروف";
        $amount = 0;
    }
    $amount;
    // استلام البيانات بعد التأكد من عدم وجود قيم فارغة
    $required_fields = [
        "typeservice", "fullname", "efullname", "enfullname",
        "idcustomer", "age", "parentsname", "mobilecustomer","anothermobile",
        "emailcustomer", "atusimestatus", "haire", "paymethode",
        "isatusimcustomer", "accept", "howtoknowus", "officerno"
    ];

    $errors = [];

    // التحقق من الحقول المطلوبة
    foreach ($required_fields as $field) {
        if (empty($_POST[$field])) {
            $errors[] = "يرجى تعبئة الحقل: " . $field;
        }
    }

    // التحقق من رقم الهوية
    $idcustomer = $_POST['idcustomer'];
    if (!is_numeric($idcustomer)) {
        $errors[] = "رقم الهوية يجب أن يكون أرقام فقط.";
    }

    // التحقق من رقم الجوال وصيغة 9665
    $mobilecustomer = $_POST['mobilecustomer'];
    if (!preg_match('/^9665\d{8}$/', $mobilecustomer)) {
        $errors[] = "رقم الجوال يجب أن يبدأ بـ 9665 ويتكون من 12 رقمًا.";
    }

    // التحقق من رقم الجوال وصيغة 9665
    $anothermobile = $_POST['anothermobile'];
    if (!preg_match('/^9665\d{8}$/', $anothermobile)) {
        $errors[] = "رقم الجوال البديل يجب أن يبدأ بـ 9665 ويتكون من 12 رقمًا.";
    }

    // في حال وجود أخطاء، يتم عرضها وإيقاف التنفيذ
    if (!empty($errors)) {
        echo '<h4><div class="alert alert-danger" style="text-align:center;color:red;"><br>';
        echo implode("<br>", $errors);
        echo '<br>يرجى تصحيح الأخطاء وإعادة المحاولة.</div></h4>';
        exit();
    }

    // تنظيف البيانات لمنع الهجمات الأمنية
    
    $location = '';
    $custmoername = $conn->real_escape_string($_POST['fullname']);
    $efullname = $conn->real_escape_string($_POST['efullname']);
    $enfullname = $conn->real_escape_string($_POST['enfullname']);
    $age = $conn->real_escape_string($_POST['age']);
    $parentsname = $conn->real_escape_string($_POST['parentsname']);
    $emailcustomer = $conn->real_escape_string($_POST['emailcustomer']);
    $atusimestatus = $conn->real_escape_string($_POST['atusimestatus']);
    $haire = $conn->real_escape_string($_POST['haire']);
    $paymethode = $conn->real_escape_string($_POST['paymethode']);
    $isatusimcustomer = $conn->real_escape_string($_POST['isatusimcustomer']);
    $accept = $conn->real_escape_string($_POST['accept']);
    $statuorder = $conn->real_escape_string($_POST['statuorder']);
    $howtoknowus = $conn->real_escape_string($_POST['howtoknowus']);
    $officerno = $conn->real_escape_string($_POST['officerno']);

    function getServiceName($conn, $service_id) {
    $query = "SELECT servicename FROM services WHERE serviceid = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $service_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $service = $result->fetch_assoc();
        return $service['servicename'];
    } else {
        return "خدمة غير معروفة";
    }
}

// استلام كود الخدمة من الفورم
$typeservice = $conn->real_escape_string($_POST['typeservice']);

// جلب اسم الخدمة بناءً على الكود
$service_name = getServiceName($conn, $typeservice);

// عرض اسم الخدمة
"<h3>اسم الخدمة: " . htmlspecialchars($service_name) . "</h3><br>";
   
    // التحقق من وجود طلب جديد قيد المراجعة
    $checkQuery = "SELECT statuorder FROM photo WHERE idcustomer = ? AND typeservice = ? ORDER BY creatdate DESC LIMIT 1";
    $stmt = $conn->prepare($checkQuery);
    $stmt->bind_param("ss", $idcustomer, $service_name);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        if ($row['statuorder'] == 'جديد') {
            echo '<h4><div class="alert alert-danger" style="text-align:center;color:red;"><br>
            لديك طلب جديد قيد المراجعة، لا يمكنك تقديم طلب آخر في هذا الوقت<br><br>
            You have a new application under review, you cannot submit another application at this time. <br><br>
            يرجى الانتظار للمراجعة أو التواصل مع الإدارة <br><br>
            Please wait for review or contact the administration <br><br>
            <h3 style="text-align:center;"> <a href="receptionmedicalfile.php?customerid=' . urlencode($idcustomer) . '">
            
           
            </div></h4>';
            exit();
        }
    }
    $amount;
    // إدراج البيانات في قاعدة البيانات
    $sql = "INSERT INTO photo (photoid, location, proudctid, typeservice, fullname, efullname, enfullname, idcustomer, age, parentsname, mobilecustomer, emailcustomer,anothermobile, atusimestatus, haire, paymethode, isatusimcustomer, officerno, statuorder, howtoknowus, amount, paymentstatus, creatdate)
            VALUES (NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'غيرمدفوع', NOW())";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssssssssssssssssss", $location, $proudctid, $service_name, $custmoername, $efullname, $enfullname, $idcustomer, $age, $parentsname, $mobilecustomer, $emailcustomer, $anothermobile, $atusimestatus, $haire, $paymethode, $isatusimcustomer, $officerno, $statuorder, $howtoknowus, $amount);

    if ($stmt->execute()) {
        echo '<h3><div class="alert alert-success" style="text-align:center;color:green;"><br> The service has been successfully added to the beneficiary file<br></div></h3>
        <h3 style="text-align:center;"> <a href="receptionmedicalfile.php?customerid=' . urlencode($idcustomer) . '">
        <i class="ace-icon fa fa-angle-double-down bigger-120"></i> Next step: Collect Cash Payment - الخطوة التالية : قبض المبلغ </a></h3>';
    
        
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}
?>


              </h3>
            </div>
            <!-- /.box-header -->

          
          
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
