<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Finance ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
 <?php include 'financeheader.php'; ?>
 
  <!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
    <?php include 'financesidepanle.php'; ?>
      <!-- search form -->
    <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
     <?php include 'navemenufinance.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="admindashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Vat Report</a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Vat Report Info</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              
              <div class="row"><div class="col-sm-12">
                
                    <?php include('conn.php'); ?>

<!-- نموذج الفلترة -->
<form method="GET">
     <div class="row">
     <div class="col-sm-3">
          <label>رقم الفاتورة </label><br>
     <input type="text" name="invoice" placeholder="رقم الفاتورة" value="<?php echo $_GET['invoice'] ?? ''; ?>" class="form-control" style="border-color: #3c8dbc;width:stretch;">
     </div>
    <div class="col-sm-3">
     <label>المستفيد </label><br>
     <input type="text" name="customer" placeholder="اسم العميل" value="<?php echo $_GET['customer'] ?? ''; ?>" class="form-control" style="border-color: #3c8dbc;width:stretch;">
    </div>
    <div class="col-sm-3">
     <label>من تايخ</label><br>
    <input type="date" name="from_date" value="<?php echo $_GET['from_date'] ?? ''; ?>" class="form-control" style="border-color: #3c8dbc;width:stretch;">
    </div>
    <div class="col-sm-3">
     <label>إلى تاريخ</label><br>
     <input type="date" name="to_date" value="<?php echo $_GET['to_date'] ?? ''; ?>" class="form-control" style="border-color: #3c8dbc;width:stretch;">
    </div>
    <div class="col-sm-12">
     <label></label><br>
    <button type="submit" class="btn btn-block btn-primary">🔍 فلترة</button>
    </div>
     <div class="col-sm-6">
     <br>
     <button type="submit" name="export_excel" value="1" class="btn btn-block btn-success"><i class="fa fa-fw fa-file-excel-o"></i> تصدير Excel</button>
     </div>
     <div class="col-sm-6">
     <br>
     <button type="submit" class="btn btn-block btn-danger" style="color: white;"><i class="fa fa-fw fa-file-pdf-o"></i><a href="exportvatreport_pdf.php" target="_blank" style="color: white;">تصدير PDF</a> </button>
     </div>
         
    </div>
</form>
 
<?php
if (isset($_GET['export_excel'])) {
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=invoices_export_" . date('Ymd_His') . ".xls");
    echo "<table border='1'>";
    echo "<tr><th>رقم الفاتورة</th><th>اسم العميل</th><th>ID العميل</th><th>رقم العميل</th><th>تم التأكيد بواسطة</th><th>المبلغ بدون ضريبة</th><th>الضريبة</th><th>المبلغ الإجمالي</th><th>الحالة</th><th>التاريخ</th></tr>";

    $export_sql = mysqli_query($conn, $sql); // نفس الاستعلام المفلتر السابق
    while($row = mysqli_fetch_assoc($export_sql)) {
        $without_vat = $row['totalamountwvat'] / 115 * 100;
        echo "<tr>";
        echo "<td>{$row['idinvoice']}</td>";
        echo "<td>" . htmlspecialchars($row['customername'], ENT_QUOTES, 'UTF-8') . "</td>";
        echo "<td>{$row['idcustomer']}</td>";
        echo "<td>{$row['customerid']}</td>";
        echo "<td>{$row['userconfirmed']}</td>";
        echo "<td>" . number_format($without_vat, 2) . "</td>";
        echo "<td>" . number_format($row['vat'], 2) . "</td>";
        echo "<td>" . number_format($row['totalamountwvat'], 2) . "</td>";
        echo "<td>{$row['invoicestatus']}</td>";
        echo "<td>{$row['timeadded']}</td>";
        echo "</tr>";
    }

    echo "</table>";
    exit;
}
?>

<div class="col-sm-2">
     <br><br><br>
</div>
<table border="1" width="100%" id="example1" class="table table-bordered table-striped dataTable" role="grid" aria-describedby="example1_info">
    <thead>
        <tr role="row">
            <th class="sorting_asc" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 296px;text-align:center;" aria-sort="ascending" aria-label="Rendering engine: activate to sort column descending">Invoice NO.<br> رقم الفاتورة</th><th class="sorting" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 360px;text-align:center;" aria-label="Browser: activate to sort column ascending">Name <br>  المستفيد</th><th class="sorting" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 360px;text-align:center;" aria-label="Browser: activate to sort column ascending">VAT / ID <br> الرقم الضريبي / رقم الهوية </th><th class="sorting" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 187px;text-align:center;" aria-label="CSS grade: activate to sort column ascending">Service ID <br> رقم الخدمة</th><th class="sorting" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 320px;text-align:center;" aria-label="Platform(s): activate to sort column ascending">Service <br> الخدمة</th><th class="sorting" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 320px;text-align:center;" aria-label="Platform(s): activate to sort column ascending">Issuied User <br> مصدر الفاتورة</th>
                <th class="sorting" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 187px;text-align:center;" aria-label="CSS grade: activate to sort column ascending"> Without VAT <br>  بدون الضريبة</th>
                <th class="sorting" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 187px;text-align:center;" aria-label="CSS grade: activate to sort column ascending">Total Amount <br> الضريبة</th>
                <th class="sorting" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 187px;text-align:center;" aria-label="CSS grade: activate to sort column ascending">Total Amount <br> اجمالي المبلغ</th>
               <th class="sorting" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 187px;text-align:center;" aria-label="CSS grade: activate to sort column ascending">Status <br> حالة الفاتورة</th>
               <th class="sorting" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 187px;text-align:center;" aria-label="CSS grade: activate to sort column ascending">Time & Date <br> الوقت و التاريخ</th>
               <th class="sorting" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 187px;text-align:center;" aria-label="CSS grade: activate to sort column ascending">View <br> عرض</th>
                <th class="sorting" tabindex="0" aria-controls="example1" rowspan="1" colspan="1" style="width: 187px;text-align:center;" aria-label="CSS grade: activate to sort column ascending">Download <br> تحميل الفاتورة</th>
        </tr>
    </thead>
    <tbody>

<?php
$where = [];
if (!empty($_GET['invoice'])) {
    $invoice = mysqli_real_escape_string($conn, $_GET['invoice']);
    $where[] = "`idinvoice` = '$invoice'";
}

if (!empty($_GET['customer'])) {
    $customer = mysqli_real_escape_string($conn, $_GET['customer']);
    $where[] = "`customername` LIKE '%$customer%'";
}

if (!empty($_GET['from_date'])) {
    $from = $_GET['from_date'];
    $where[] = "`timeadded` >= '$from'";
}

if (!empty($_GET['to_date'])) {
    $to = $_GET['to_date'];
    $where[] = "`timeadded` <= '$to'";
}

$where_sql = count($where) ? 'WHERE ' . implode(' AND ', $where) : '';

$sql = "SELECT `idinvoice`,`customername`,`customerid`,`vat`,`totalamountwvat`,`invoicestatus`,`servicename`,`userconfirmed`,`idcustomer`,`timeadded` FROM `qrcode` $where_sql";
$result = mysqli_query($conn, $sql);

$total_without_vat = 0;
$total_with_vat = 0;
$total_vat = 0;

while($row = mysqli_fetch_assoc($result)) {
    $without_vat = $row['totalamountwvat'] / 115 * 100;
    $vat = $row['vat'];
    $with_vat = $row['totalamountwvat'];

    $total_without_vat += $without_vat;
    $total_with_vat += $with_vat;
    $total_vat += $vat;
?>

<tr>
    <td style="text-align:center;"><?php echo $row['idinvoice']; ?></td>
    <td style="text-align:center;"><?php echo htmlspecialchars($row['customername'], ENT_QUOTES, 'UTF-8'); ?></td>
    <td style="text-align:center;"><?php echo $row['idcustomer']; ?></td>
    <td style="text-align:center;"><?php echo $row['customerid']; ?></td>
    <td style="text-align:center;"><?php echo $row['servicename']; ?></td>
    <td style="text-align:center;"><?php echo $row['userconfirmed']; ?></td>
    <td style="text-align:center;"><?php echo number_format($without_vat, 2); ?></td>
    <td style="text-align:center;"><?php echo number_format($vat, 2); ?></td>
    <td style="text-align:center;"><?php echo number_format($with_vat, 2); ?></td>
    <td style="text-align:center;"><span class="label label-success"><?php echo $row['invoicestatus']; ?></span></td>
    <td style="text-align:center;"><?php echo $row['timeadded']; ?></td>
    <td style="text-align:center;">
        <a href="digitalinvoice/digitalqrcode/invoices/invoice_<?php echo $row['idinvoice']; ?>.pdf" target="_blank" class="btn bg-navy margin">View PDF</a>
    </td>
    <td style="text-align:center;">
        <a href="digitalinvoice/digitalqrcode/invoices/invoice_<?php echo $row['idinvoice']; ?>.pdf" class="btn bg-navy margin" download>Download PDF</a>
    </td>
</tr>

<?php } ?>

    </tbody>
    <tfoot>
        <tr>
            <th colspan="5" style="text-align:right;">🔢 مجموع بدون ضريبة :</th>
            <th style="text-align:center;"><?php echo number_format($total_without_vat, 2); ?></th>
            <th></th>
             <th></th>
              <th></th>
               <th></th>
                <th></th>
                 <th></th>
        </tr>
        <tr>
        <th colspan="6" style="text-align:right;">مجموع الضريبة  :</th>
            <th style="text-align:center;"><?php echo number_format($total_vat, 2); ?></th>
              <th></th>
             <th></th>
              <th></th>
               <th></th>
                <th></th>
                
        </tr>

        <tr>
           <th colspan="7" style="text-align:right;">📊 مجموع المبيعات :</th>
            <th style="text-align:center;"><?php echo number_format($total_with_vat, 2); ?></th>
            <th></th>
              <th></th>
               <th></th>
                <th></th>
        </tr>
    </tfoot>
</table>

          
                </tr>
                
               </tbody>
               
              </table></div></div><div class="row"><div class="col-sm-5"><div class="dataTables_info" id="example1_info" role="status" aria-live="polite">Showing 1 to 10 of 57 entries</div></div><div class="col-sm-7"><div class="dataTables_paginate paging_simple_numbers" id="example1_paginate"><ul class="pagination"><li class="paginate_button previous disabled" id="example1_previous"><a href="#" aria-controls="example1" data-dt-idx="0" tabindex="0">Previous</a></li><li class="paginate_button active"><a href="#" aria-controls="example1" data-dt-idx="1" tabindex="0">1</a></li><li class="paginate_button "><a href="#" aria-controls="example1" data-dt-idx="2" tabindex="0">2</a></li><li class="paginate_button "><a href="#" aria-controls="example1" data-dt-idx="3" tabindex="0">3</a></li><li class="paginate_button "><a href="#" aria-controls="example1" data-dt-idx="4" tabindex="0">4</a></li><li class="paginate_button "><a href="#" aria-controls="example1" data-dt-idx="5" tabindex="0">5</a></li><li class="paginate_button "><a href="#" aria-controls="example1" data-dt-idx="6" tabindex="0">6</a></li><li class="paginate_button next" id="example1_next"><a href="#" aria-controls="example1" data-dt-idx="7" tabindex="0">Next</a></li></ul></div></div></div></div>
            </div>
            <!-- /.box-body -->
          </div>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
          
        </div>
        <!-- /.box-footer-->
      </div>
      <!-- /.box -->

    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include 'footer.php'; ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Create the tabs -->
    <ul class="nav nav-tabs nav-justified control-sidebar-tabs">
      <li><a href="#control-sidebar-home-tab" data-toggle="tab"><i class="fa fa-home"></i></a></li>

      <li><a href="#control-sidebar-settings-tab" data-toggle="tab"><i class="fa fa-gears"></i></a></li>
    </ul>
    <!-- Tab panes -->
    <div class="tab-content">
      <!-- Home tab content -->
      <div class="tab-pane" id="control-sidebar-home-tab">
        <h3 class="control-sidebar-heading">Recent Activity</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-birthday-cake bg-red"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Langdon's Birthday</h4>

                <p>Will be 23 on April 24th</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-user bg-yellow"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Frodo Updated His Profile</h4>

                <p>New phone +1(800)555-1234</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-envelope-o bg-light-blue"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Nora Joined Mailing List</h4>

                <p>nora@example.com</p>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <i class="menu-icon fa fa-file-code-o bg-green"></i>

              <div class="menu-info">
                <h4 class="control-sidebar-subheading">Cron Job 254 Executed</h4>

                <p>Execution time 5 seconds</p>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

        <h3 class="control-sidebar-heading">Tasks Progress</h3>
        <ul class="control-sidebar-menu">
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Custom Template Design
                <span class="label label-danger pull-right">70%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-danger" style="width: 70%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Update Resume
                <span class="label label-success pull-right">95%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-success" style="width: 95%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Laravel Integration
                <span class="label label-warning pull-right">50%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-warning" style="width: 50%"></div>
              </div>
            </a>
          </li>
          <li>
            <a href="javascript:void(0)">
              <h4 class="control-sidebar-subheading">
                Back End Framework
                <span class="label label-primary pull-right">68%</span>
              </h4>

              <div class="progress progress-xxs">
                <div class="progress-bar progress-bar-primary" style="width: 68%"></div>
              </div>
            </a>
          </li>
        </ul>
        <!-- /.control-sidebar-menu -->

      </div>
      <!-- /.tab-pane -->
      <!-- Stats tab content -->
      <div class="tab-pane" id="control-sidebar-stats-tab">Stats Tab Content</div>
      <!-- /.tab-pane -->
      <!-- Settings tab content -->
      <div class="tab-pane" id="control-sidebar-settings-tab">
        <form method="post">
          <h3 class="control-sidebar-heading">General Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Report panel usage
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Some information about this general settings option
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Allow mail redirect
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Other sets of options are available
            </p>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Expose author name in posts
              <input type="checkbox" class="pull-right" checked>
            </label>

            <p>
              Allow the user to show his name in blog posts
            </p>
          </div>
          <!-- /.form-group -->

          <h3 class="control-sidebar-heading">Chat Settings</h3>

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Show me as online
              <input type="checkbox" class="pull-right" checked>
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Turn off notifications
              <input type="checkbox" class="pull-right">
            </label>
          </div>
          <!-- /.form-group -->

          <div class="form-group">
            <label class="control-sidebar-subheading">
              Delete chat history
              <a href="javascript:void(0)" class="text-red pull-right"><i class="fa fa-trash-o"></i></a>
            </label>
          </div>
          <!-- /.form-group -->
        </form>
      </div>
      <!-- /.tab-pane -->
    </div>
  </aside>
  <!-- /.control-sidebar -->
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- jQuery 2.2.3 -->
<script src="plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="bootstrap/js/bootstrap.min.js"></script>
<!-- SlimScroll -->
<script src="plugins/slimScroll/jquery.slimscroll.min.js"></script>
<!-- FastClick -->
<script src="plugins/fastclick/fastclick.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/app.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
</body>
</html>
