<?php
// ====== DB config (عدّلهم عندك) ======
const DB_DSN  = 'mysql:host=localhost:3306;dbname=acesaudi_site;charset=utf8mb4';
const DB_USER = 'acesaudi_usr';
const DB_PASS = 'tabfyv-6xiFry-noczak';

// Helpers
function esc($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
function fmtDate($s){ if(!$s) return ''; $t=strtotime($s); return $t?date('Y-m-d',$t):''; }
function pdo(): PDO {
  static $pdo; if ($pdo) return $pdo;
  $pdo = new PDO(DB_DSN, DB_USER, DB_PASS, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);
  return $pdo;
}
function fetchRow($sql,$p=[]){ $st=pdo()->prepare($sql); $st->execute($p); return $st->fetch() ?: []; }
function fetchAll($sql,$p=[]){ $st=pdo()->prepare($sql); $st->execute($p); return $st->fetchAll() ?: []; }

// ====== التعرّف على رقم المستفيد من الرابط أو POST ======
$beneficiaryid =
  $_GET['beneficiaryid']   ?? $_GET['BeneficiaryId'] ??
  $_POST['beneficiaryid']  ?? '';

// ====== تحميل بيانات المستفيد والتغطيات ======
$B = [];           // Beneficiary row
$COVERAGES = [];   // list of coverages
$C = null;         // selected coverage
$CLASSES = [];     // coverage classes

if ($beneficiaryid !== '') {
  // عدّل أسماء الجداول/الأعمدة بما يطابق سكيمتك
  $B = fetchRow("
    SELECT BENEFICIARYID,FIRSTNAME,MIDDLENAME,LASTNAME,FULLNAME,DOB,GENDER,
           DOCUMENTTYPE,DOCUMENTID,EHEALTHID,NATIONALITY,
           ADDRESSLINE,ADDRESSSTREETNAME,ADDRESSCITY,ADDRESSSTATE,ADDRESSCOUNTRY,
           ADDRESSPOSTALCODE,ADDRESSDISTRICT,PATIENTFILENO,CONTACTNUMBER,EMAIL,
           PREFERREDLANGUAGE,MARITALSTATUS,BLOODGROUP,RESIDENCYTYPE,OCCUPATION,RELIGION
    FROM NPHIES_BENEFICIARY
    WHERE BENEFICIARYID = :id
    LIMIT 1
  ", [':id'=>$beneficiaryid]);

  $COVERAGES = fetchAll("
    SELECT COVERAGEID,COVERAGETYPE,EXPIRYDATE,PAYERNPHIESID,MEMBERID,
           POLICYNUMBER,POLICYHOLDER,RELATIONWITHSUBSCRIBER,TPANPHIESID
    FROM NPHIES_COVERAGE
    WHERE BENEFICIARYID = :id
    ORDER BY EXPIRYDATE DESC
  ", [':id'=>$beneficiaryid]);

  // اختر تغطية محددة من الرابط أو أول تغطية موجودة
  $coverageId = $_GET['coverageid'] ?? ($COVERAGES[0]['COVERAGEID'] ?? null);
  if ($coverageId) {
    $C = fetchRow("SELECT * FROM NPHIES_COVERAGE WHERE COVERAGEID=:cov LIMIT 1", [':cov'=>$coverageId]);
    $CLASSES = fetchAll("SELECT * FROM NPHIES_COVERAGE_CLASS WHERE COVERAGEID=:cov", [':cov'=>$coverageId]);
  }
}

// ملاحظة: باقي الصفحة (HTML/JS) يستخدم الآن $B و $COVERAGES و $C و $CLASSES الجاهزين.
?>

<?php
// ===== Helpers (لتفادي undefined function) =====
if (!function_exists('esc')) {
  function esc($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
}
if (!function_exists('fmtDate')) {
  function fmtDate($s){ if(!$s) return ''; $t=strtotime($s); return $t ? date('Y-m-d',$t) : ''; }
}

// ===== جلب beneficiaryid من أي مكان متاح =====
$beneficiaryid =
  $_GET['beneficiaryid']   ?? $_GET['BeneficiaryId'] ??
  ($_POST['beneficiaryid'] ?? '') ??
  ($B['BENEFICIARYID'] ?? '');

// إن لم تكن متغيرات $B/$COVERAGES/$C/$CLASSES مُعرفة، عرّفها افتراضيًا لمنع التنبيهات
$B         = isset($B) ? $B : [];
$COVERAGES = isset($COVERAGES) ? $COVERAGES : [];
$C         = isset($C) ? $C : null;
$CLASSES   = isset($CLASSES) ? $CLASSES : [];
?>
<!doctype html>
<html lang="en" dir="ltr">
<head>
  <meta charset="utf-8">
  <title>Create New Claim</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap + Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    /* لمسات بسيطة للواجهة */
    .tag-input{display:flex;flex-wrap:wrap;gap:6px;min-height:42px;align-items:center;padding:6px;border:1px solid #ced4da;border-radius:.375rem}
    .tag-input input{border:none;flex:1;min-width:180px;outline:none}
    .tag{background:#eef2ff;color:#344;display:inline-flex;align-items:center;border-radius:999px;padding:.25rem .5rem}
    .tag .remove{border:none;background:transparent;margin-left:.25rem;cursor:pointer}
    .ac-wrap{position:relative}
    .ac-menu{position:absolute;z-index:30;left:0;right:0;max-height:260px;overflow:auto;background:#fff;border:1px solid #ddd;border-top:none;display:none}
    .ac-item{display:flex;justify-content:space-between;gap:8px;padding:8px 10px;cursor:pointer}
    .ac-item:hover,.ac-item.active{background:#f7f7fb}
    .ac-item .t{font-weight:600}
    .ac-item .s{font-size:.85rem;color:#666}
    .items-box{border:1px solid #e5e7eb;border-radius:.5rem;margin-top:1rem}
    .items-header,.items-row{display:grid;grid-template-columns: 32px 110px 130px 150px 1fr 170px 170px 120px 210px 110px 40px;gap:8px;align-items:center}
    .items-header{background:#f8fafc;padding:10px 12px;font-weight:600}
    .items-row{padding:10px 12px;border-top:1px solid #f0f0f0}
    .items-row .muted{color:#777;font-size:.85em}
    .expander{cursor:pointer;user-select:none}
    .badge-soft{background:#f1f5f9;border:1px solid #e2e8f0;border-radius:.4rem;padding:.25rem .5rem}
    .req{color:#d00}
  </style>
</head>
<body class="bg-light">

<div class="container py-4" style="max-width: 1720px;">
  <h3 class="mb-4">Create A New Claim</h3>

  <!-- Tabs (إن لم تكن لديك، ضع أي محتوى داخل تبويب واحد) -->
  <ul class="nav nav-tabs" id="tabs" role="tablist">
    <li class="nav-item" role="presentation"><button class="nav-link active" id="preauth-tab" data-bs-toggle="tab" data-bs-target="#preauth" type="button" role="tab">Claim</button></li>
    <li class="nav-item" role="presentation"><button class="nav-link" id="beneficiary-tab" data-bs-toggle="tab" data-bs-target="#beneficiary" type="button" role="tab">Beneficiary</button></li>
    <li class="nav-item" role="presentation"><button class="nav-link" id="careteam-tab" data-bs-toggle="tab" data-bs-target="#careteam" type="button" role="tab">Care Team</button></li>
    <li class="nav-item" role="presentation"><button class="nav-link" id="diagnosis-tab" data-bs-toggle="tab" data-bs-target="#diagnosis" type="button" role="tab">Diagnosis</button></li>
    <li class="nav-item" role="presentation"><button class="nav-link" id="supporting-tab" data-bs-toggle="tab" data-bs-target="#supporting" type="button" role="tab">Supporting</button></li>
    <li class="nav-item" role="presentation"><button class="nav-link" id="items-tab" data-bs-toggle="tab" data-bs-target="#items" type="button" role="tab">Items</button></li>
    <li class="nav-item" role="presentation"><button class="nav-link" id="accident-tab" data-bs-toggle="tab" data-bs-target="#accident" type="button" role="tab">Accident</button></li>
    <li class="nav-item" role="presentation"><button class="nav-link" id="encounter-tab" data-bs-toggle="tab" data-bs-target="#encounter" type="button" role="tab">Encounter</button></li>
  </ul>

  <!-- ===== Main Form ===== -->
  <form id="preauthForm"
        method="post"
        enctype="multipart/form-data"
        action="save_claiminfo.php?beneficiaryid=<?= urlencode($beneficiaryid) ?>"
        class="needs-validation tab-content bg-white border border-top-0 p-3 rounded-bottom"
        novalidate>

    <input type="hidden" name="beneficiaryid" value="<?= esc($beneficiaryid) ?>">

    <!-- ===== Tab: Claim ===== -->
    <div class="tab-pane fade show active" id="preauth" role="tabpanel" aria-labelledby="preauth-tab" tabindex="0">

      <!-- Has referred Preauthorization? -->
      <div class="form-check form-switch mb-3">
        <input type="hidden" name="hasPreauth" value="0">
        <input class="form-check-input" type="checkbox" id="hasPreauth" name="hasPreauth" value="1">
        <label class="form-check-label fw-medium" for="hasPreauth">Has referred Preauthorization?</label>
      </div>

      <input type="hidden" name="PROVCLAIMNO" value="<? echo $PROVCLAIMNO = $_GET['idrequestclaim']; ?>">

      <div class="row g-3">
        <!-- Date Ordered -->
        <div class="col-lg-3 col-md-6">
          <label class="form-label">Date Ordered <span class="req">*</span></label>
          <div class="input-group">
            <input type="datetime-local" class="form-control" id="ClaimCreatedDate" name="ClaimCreatedDate" required>
            <span class="input-group-text"><i class="bi bi-calendar-event"></i></span>
            <div class="invalid-feedback">Please select date & time.</div>
          </div>
        </div>

        <!-- Type -->
        <div class="col-lg-3 col-md-6">
          <label class="form-label">Type <span class="req">*</span></label>
          <select id="type" name="ClaimType" class="form-select" required>
            <option value="" disabled hidden>Select Type</option>
            <option value="professional">Professional</option>
          </select>
          <div class="invalid-feedback">Type is required.</div>
        </div>

        <!-- Sub Type -->
        <div class="col-lg-3 col-md-6">
          <label class="form-label">Sub Type <span class="req">*</span></label>
          <select id="subType" name="ClaimSubtype" class="form-select" required>
            <option value="" disabled hidden>Select Sub Type</option>
            <option value="op">OutPatient</option>
          </select>
          <div class="invalid-feedback">Sub Type is required.</div>
        </div>

        <!-- Payee Type -->
        <div class="col-lg-3 col-md-6">
          <label class="form-label">Payee Type <span class="req">*</span></label>
          <select id="payeeType" name="PAYEETYPE" class="form-select" required>
            <option value="10000300205372" selected>Provider</option>
          </select>
          <div class="invalid-feedback">Payee Type is required.</div>
        </div>

        <!-- Payee -->
        <div class="col-lg-3 col-md-6">
          <label class="form-label">Payee <span class="req">*</span></label>
          <select id="payee" name="payee" class="form-select" required>
            <option value="" disabled hidden>Select Payee</option>
            <option value="Autism Center of Excellence">Autism Center of Excellence</option>
          </select>
          <div class="invalid-feedback">Payee is required.</div>
        </div>

        <!-- Preauthorization Reference No(s) - tags -->
        <div class="col-lg-3 col-md-6" id="preauthRefsWrapper">
          <label class="form-label" for="preauthInput">Preauthorization Reference No(s).</label>
          <div id="preauthRefs" class="tag-input" data-hidden-target="preauthRefsHidden">
            <input id="preauthInput" class="form-control" type="text" placeholder="Enter a new tag">
          </div>
          <input type="hidden" id="preauthRefsHidden" name="preauth_reference_nos" value="">
        </div>

        <!-- Episode No. -->
        <div class="col-lg-3 col-md-6">
          <label class="form-label">Episode - Invoice No. <span class="req">*</span></label>
          <input type="text" class="form-control" id="EpisodeId" name="EpisodeId" placeholder="Episode No" required value="419">
          <div class="invalid-feedback">Episode No. is required.</div>
        </div>

        <!-- Accounting Period -->
        <div class="col-lg-3 col-md-6">
          <label class="form-label">Accounting Period</label>
          <div class="input-group">
            <input type="date" class="form-control" id="AccountingPeriod" name="AccountingPeriod">
            <span class="input-group-text"><i class="bi bi-calendar-event"></i></span>
          </div>
        </div>

        <input type="hidden" name="IsNewborn" value="false">
        <input type="hidden" name="ISREFERRAL" value="false">
        <input type="hidden" name="ProviderNphiesId" value="10000300205372">

        <div class="col-lg-3 col-md-6">
          <label class="form-label">Amount <span class="req">*</span></label>
          <input type="text" class="form-control" name="Total" required>
          <div class="invalid-feedback">Amount is required.</div>
        </div>

        <div class="col-lg-3 col-md-6">
          <label class="form-label">Invoice NO. <span class="req">*</span></label>
          <input type="text" class="form-control" name="CoverageId" value="4089" required>
          <div class="invalid-feedback">Invoice No. is required.</div>
        </div>

        <div class="col-lg-3 col-md-6">
          <label class="form-label">Beneficiary ID <span class="req">*</span></label>
          <input type="text" name="BeneficiaryId" class="form-control" value="<?= esc($B['BENEFICIARYID'] ?? '2184261119') ?>" required>
          <div class="invalid-feedback">Beneficiary ID is required.</div>
        </div>

        <div class="col-lg-3 col-md-6">
          <label class="form-label">ProviderClaimNo <span class="req">*</span></label>
          <input type="text" name="ProviderClaimNo" class="form-control" value="419" required>
          <div class="invalid-feedback">ProviderClaimNo is required.</div>
        </div>

        <div class="col-lg-3 col-md-6">
          <label class="form-label">PRE AUTH OFFLINE DATE <span class="req">*</span></label>
          <input type="date" class="form-control" id="PREAUTHOFFLINEDATE" name="PREAUTHOFFLINEDATE" required>
          <div class="invalid-feedback">PREAUTH OFFLINE DATE is required.</div>
        </div>

        <div class="col-lg-3 col-md-6">
          <label class="form-label">BILLABLE PERIOD START <span class="req">*</span></label>
          <input type="date" class="form-control" name="BILLABLEPERIODSTART" required>
          <div class="invalid-feedback">BILLABLE PERIOD START is required.</div>
        </div>

        <!-- Referral Provider Name -->
        <div class="col-lg-6 col-md-6" id="preauth-section">
          <label class="form-label">Referral Provider Name</label>
          <input type="text" class="form-control" id="REFERRINGPROVIDERNAME" name="REFERRINGPROVIDERNAME" value="10000300205372" placeholder="Referral Provider Name">
        </div>

        <!-- Eligibility Details -->
        <div class="col-lg-4 col-md-6">
          <label class="form-label">Eligibility Details</label>
          <select id="eligibility" name="eligibility_details" class="form-select">
            <option value="" disabled hidden>Select Eligibility Type</option>
            <option value="online">Online</option>
            <option value="offline">Offline</option>
          </select>
        </div>

        <!-- Preauthorization Details -->
        <div class="col-lg-4 col-md-6">
          <label class="form-label">Preauthorization Details</label>
          <select id="preauthDetailsSelect" name="preauth_details" class="form-select">
            <option value="" disabled hidden>Select Preauth Type</option>
            <option value="online">Online</option>
            <option value="offline">Offline</option>
          </select>
        </div>

         <div class="col-lg-4 col-md-6">
    <label class="form-label">Attachments</label>
    <!-- لاحظ: حوّلنا لاسم موحد attachments[] ودعمنا multiple -->
    <input type="file" name="attachments[]" class="form-control"
           multiple
           accept=".pdf,.jpg,.jpeg,.png,.doc,.docx,.xls,.xlsx">
  </div>
        
      </div>
    </div>

    <!-- ===== Tab: Beneficiary ===== -->
    <div class="tab-pane fade" id="beneficiary" role="tabpanel" aria-labelledby="beneficiary-tab" tabindex="0">
      <div class="p-2">
        <div class="row g-3">
          <div class="col-md-3">
            <label class="form-label">First Name</label>
            <input class="form-control" readonly value="<?= esc($B['FIRSTNAME'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Second Name</label>
            <input class="form-control" readonly value="<?= esc($B['MIDDLENAME'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Family Name</label>
            <input class="form-control" readonly value="<?= esc($B['LASTNAME'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Full Name*</label>
            <input class="form-control" readonly value="<?= esc($B['FULLNAME'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Beneficiary File ID*</label>
            <input class="form-control" readonly value="<?= esc($B['BENEFICIARYID'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Date of Birth*</label>
            <input class="form-control" readonly value="<?= esc(fmtDate($B['DOB'] ?? '')) ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Gender*</label>
            <input class="form-control" readonly value="<?= esc($B['GENDER'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Document Type*</label>
            <input class="form-control" readonly value="<?= esc($B['DOCUMENTTYPE'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Document ID*</label>
            <input class="form-control" readonly value="<?= esc($B['DOCUMENTID'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">E-Health ID</label>
            <input class="form-control" readonly value="<?= esc($B['EHEALTHID'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Nationality</label>
            <input class="form-control" readonly value="<?= esc($B['NATIONALITY'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Occupation*</label>
            <input class="form-control" readonly value="<?= esc($B['OCCUPATION'] ?? '') ?>">
          </div>
           <div class="col-md-3">
            <label class="form-label">Marital Status*</label>
            <input class="form-control" readonly value="<?= esc($B['MARITALSTATUS'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Contact Number</label>
            <input class="form-control" readonly value="<?= esc($B['CONTACTNUMBER'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Email</label>
            <input class="form-control" readonly value="<?= esc($B['EMAIL'] ?? '') ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Blood Group</label>
            <input class="form-control" readonly value="<?= esc($B['BLOODGROUP'] ?? '') ?>">
          </div>
          <!-- ... بقية حقول العنوان ... -->

          <div class="mt-3 d-flex justify-content-between align-items-center">
            <span class="fw-semibold">Insurance Plan</span>
            <?php if ($COVERAGES): ?>
              <input type="hidden" name="beneficiaryid" value="<?= esc($beneficiaryid) ?>">
              <select name="coverageid" class="form-select" style="min-width:420px;">
                <?php foreach ($COVERAGES as $cov):
                  $lbl = ($cov['COVERAGETYPE'] ?? '') . ' • Exp: ' . fmtDate($cov['EXPIRYDATE'] ?? '') .
                         ' • PAYER-ID: ' . ($cov['PAYERNPHIESID'] ?? '') . ' (ID: ' . ($cov['COVERAGEID'] ?? '') . ')';
                  $sel = ($C && ($cov['COVERAGEID'] ?? null) == ($C['COVERAGEID'] ?? null)) ? 'selected' : '';
                ?>
                  <option value="<?= esc($cov['COVERAGEID'] ?? '') ?>" <?=$sel?>><?= esc($lbl) ?></option>
                <?php endforeach; ?>
              </select>
            <?php endif; ?>
          </div>

          <?php if ($C): ?>
          <div class="row g-3 mt-1">
            <div class="col-md-3"><label class="form-label">Payer NPHIES ID</label><input class="form-control" readonly value="<?= esc($C['PAYERNPHIESID']) ?>"></div>
            <div class="col-md-3"><label class="form-label">Expiry Date</label><input class="form-control" readonly value="<?= esc(fmtDate($C['EXPIRYDATE'])) ?>"></div>
            <div class="col-md-3"><label class="form-label">Member Card ID</label><input class="form-control" readonly value="<?= esc($C['MEMBERID']) ?>"></div>
            <div class="col-md-3"><label class="form-label">Policy Number</label><input class="form-control" readonly value="<?= esc($C['POLICYNUMBER']) ?>"></div>
          </div>
          <?php else: ?>
            <div class="alert alert-warning mt-2">لا توجد أي تغطية لهذا المستفيد</div>
          <?php endif; ?>

          <div class="mt-3">Coverage Classes</div>
          <?php if ($C && $CLASSES): ?>
            <div class="table-responsive">
              <table class="table table-bordered align-middle">
                <thead class="table-light">
                  <tr><th>#</th><th>COVERAGECLASSID</th><th>TYPE</th><th>VALUE</th><th>NAME</th><th>COVERAGEID</th></tr>
                </thead>
                <tbody>
                <?php foreach ($CLASSES as $i=>$row): ?>
                  <tr>
                    <td><?= $i+1 ?></td>
                    <td><?= esc($row['COVERAGECLASSID']) ?></td>
                    <td><?= esc($row['TYPE']) ?></td>
                    <td><?= esc($row['VALUE']) ?></td>
                    <td><?= esc($row['NAME']) ?></td>
                    <td><?= esc($row['COVERAGEID']) ?></td>
                  </tr>
                <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          <?php else: ?>
            <div class="small-note">لا توجد فئات تغطية للتغطية المحددة</div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <!-- ===== Tab: CareTeam (IDs فريدة) ===== -->
    <div class="tab-pane fade" id="careteam" role="tabpanel" aria-labelledby="careteam-tab" tabindex="0">
      <div class="row g-3">
        <div class="col-md-3">
          <label class="form-label">Practitioner*</label>
          <input class="form-control" readonly name="SEQUENCENO" value="<?= esc('1') ?>">
        </div>
        <div class="col-md-3">
          <label class="form-label">Practitioner Role*</label>
          <select id="ctPractitionerRole" name="ct_practitioner_role" class="form-select">
            <option value="" disabled hidden>Select</option>
            <option value="doctor">Doctor</option>
            <option value="teacher">Teacher</option>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label">Care Team Role*</label>
          <select id="ctCareTeamRole" name="ct_careteam_role" class="form-select">
            <option value="" disabled hidden>Select</option>
            <option value="primaryprovider">Primary provider</option>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label">Qualification*</label>
          <select id="ctQualification" name="ct_qualification" class="form-select">
            <option value="" disabled hidden>Select</option>
            <option value="08.26">Mental Health</option>
          </select>
        </div>

        <input type="hidden" name="PHYSICIANNAME" value="Khoulud Alsayari">

      </div>
    </div>

    <!-- ===== Tab: Diagnosis ===== -->
    <div class="tab-pane fade" id="diagnosis" role="tabpanel" aria-labelledby="diagnosis-tab" tabindex="0">
      <div class="container p-0">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h5 class="m-0">Diagnosis <span class="text-danger">*</span></h5>
          <button type="button" id="dxAddRowBtn" class="btn btn-sm btn-primary">+ Add</button>
        </div>
        <div class="border rounded-3 p-2">
          <div class="row g-0 fw-semibold text-secondary border-bottom pb-1 mb-2">
            <div class="col-7">Code - Description</div>
            <div class="col-4">Type</div>
            <div class="col-1"></div>
          </div>
          <div id="dxRows"></div>
          <div class="mt-2 small">Rows: <span id="countBadge">0</span></div>
        </div>
        <input type="hidden" name="diagnosis_json" id="diagnosis_json">
      </div>
    </div>

    <script>
(function attachDiagnosisSerializer(){
  const form = document.getElementById('preauthForm');
  if(!form) return;

  function collectDiagnosis(){
    const rows = [...document.querySelectorAll('#dxRows .dx-row')];
    return rows.map((r,i)=>{
      const text = (r.querySelector('.code-input')?.value || '').trim();
      return {
        seq:  i+1,                                                        // SEQUENCENO
        id:   (r.querySelector('.code-id')?.value || '').trim(),         // إن كان لديك ID
        text: text,                                                      // "96180-00-20 — ABC..."
        type: (r.querySelector('.type-select')?.value || '').trim(),     // principal / secondary...
        onadmission:     null,                                           // إن لم تكن حقولها موجودة بالواجهة
        conditiononset:  null
      };
    }).filter(x => x.text);
  }

  form.addEventListener('submit', ()=>{
    document.getElementById('diagnosis_json').value =
      JSON.stringify(collectDiagnosis());
  });
})();
</script>



    <!-- ===== Tab: Supporting Info ===== -->
    <div class="tab-pane fade" id="supporting" role="tabpanel" aria-labelledby="supporting-tab" tabindex="0">
      <div class="card shadow-sm">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="m-0">Supporting Info</h5>
            <div class="d-flex gap-2">
              <button id="supAddAllBtn" type="button" class="btn btn-outline-primary btn-sm">إضافة كل الخدمات الافتراضية</button>
              <button id="supAddRowBtn" type="button" class="btn btn-primary btn-sm">إضافة صف</button>
            </div>
          </div>

          <div class="table-responsive">
            <table class="table table-bordered align-middle" id="supTable">
              <thead>
                <tr class="text-center">
                  <th style="width:60px">#</th>
                  <th style="min-width:220px">CATEGORY</th>
                  <th style="min-width:200px">REASON</th>
                  <th style="min-width:140px">SUPPORTINGVALUE</th>
                  <th style="min-width:120px">UNIT</th>
                  <th style="width:60px"></th>
                </tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>

          <input type="hidden" name="supporting_rows_json" id="supporting_rows_json">

          <div class="mt-2">Rows: <span id="rowsCount">0</span></div>
        </div>
      </div>
    </div>

    <script>
  // اجمع صفوف Supporting Info من الجدول الحالي
  function collectSupportingRows(){
    const tb = document.querySelector('#supTable tbody');
    if(!tb) return [];
    const rows = [...tb.querySelectorAll('tr')].map((tr,i)=>({
      SEQUENCENO:      i+1,
      CATEGORY:        tr.querySelector('.category')?.value ?? '',
      REASON:          tr.querySelector('.reason')?.value ?? '',
      SUPPORTINGVALUE: tr.querySelector('.svalue')?.value ?? '',
      UNIT:            tr.querySelector('.unit')?.value ?? ''
    }));
    return rows;
  }

  // قبل إرسال النموذج الرئيسي خزّن JSON في الحقل المخفي
  document.getElementById('preauthForm')?.addEventListener('submit', function(){
    const rows = collectSupportingRows();
    document.getElementById('supporting_rows_json').value = JSON.stringify(rows);
  });
</script>


    <!-- ===== Tab: Items ===== -->
    <div class="tab-pane fade" id="items" role="tabpanel" aria-labelledby="items-tab" tabindex="0">
      <div class="modal-like">
        <div class="header h5 mb-3">Add Item</div>
        <div class="body">
          <!-- لا نموذج داخلي هنا — داخل النموذج الرئيسي -->
          <div id="itemForm">
            <div class="ac-wrap mb-3">
              <div class="input-group">
                <input id="globalSearch" type="text" class="form-control form-control-lg"
                       placeholder="Search for item by standard code, standard description, internal code or internal description"
                       autocomplete="off">
                <span class="input-group-text"><i class="bi bi-search"></i>🔎</span>
              </div>
              <div class="ac-menu" id="searchMenu"></div>
            </div>

            <input type="hidden" name="service_id" id="service_id">

            <div class="row g-3">
              <div class="col-md-3">
                <label class="form-label">Type <span class="req">*</span></label>
                <select class="form-select" id="type_svc" name="SERVICE_TYPE">
                  <option value="" hidden>Select Type</option>
                  <option value="consultation">Consultation</option>
                  <option value="service">Service</option>
                  <option value="procedure">Procedure</option>
                  <option value="lab">Lab</option>
                  <option value="imaging">Imaging</option>
                </select>
              </div>

              <div class="col-md-3">
                <label class="form-label">Standard Code - Description <span class="req">*</span></label>
                <select class="form-select" id="stdSelect" name="STD_CODE_DESC">
                  <option value="" hidden>Select Code-Description</option>
                </select>
              </div>

              <div class="col-md-3">
                <label class="form-label">Non Standard Code</label>
                <input class="form-control" id="nonStdCode" name="NON_STANDARD_CODE" placeholder="Enter non standard code">
              </div>

              <div class="col-md-3">
                <label class="form-label">Non Standard Description</label>
                <input class="form-control" id="nonStdDesc" name="NON_STANDARD_DESC" placeholder="Enter non standard description">
              </div>

              <div class="col-md-3">
                <label class="form-label">Service Start Date</label>
                <div class="input-group">
                  <input type="date" class="form-control" id="startDate">
                  <span class="input-group-text">📅</span>
                </div>
              </div>

              <div class="col-md-3">
                <label class="form-label">Service End Date</label>
                <div class="input-group">
                  <input type="date" class="form-control" id="endDate">
                  <span class="input-group-text">📅</span>
                </div>
              </div>

              <div class="col-md-3">
                <label class="form-label">Invoice No. <span class="req">*</span></label>
                <input class="form-control" id="invoiceNo">
              </div>

              <div class="col-md-3">
                <label class="form-label">Quantity <span class="req">*</span></label>
                <div class="input-group">
                  <input type="number" min="0" step="1" class="form-control" id="quantity" value="1">
                  <select class="form-select unit-xs" id="qtyType">
                    <option>Unit</option><option>Package</option><option>Session</option>
                  </select>
                </div>
              </div>

              <div class="col-md-3">
                <label class="form-label">Unit Price <span class="req">*</span></label>
                <div class="input-group">
                  <input type="number" min="0" step="0.01" class="form-control" id="unitPrice">
                  <span class="input-group-text">SR</span>
                </div>
              </div>

              <div class="col-md-3">
                <label class="form-label">Tax Amount</label>
                <div class="input-group">
                  <input type="number" min="0" step="0.01" class="form-control" id="taxAmount" value="0">
                  <span class="input-group-text">SR</span>
                </div>
              </div>

              <div class="col-md-3">
                <label class="form-label">Factor</label>
                <input type="number" min="0" step="0.01" class="form-control" id="factor" value="1">
              </div>

              <div class="col-md-3">
                <label class="form-label">Discount Amount</label>
                <div class="input-group">
                  <input type="number" min="0" step="0.01" class="form-control" id="discountAmount" value="0">
                  <span class="input-group-text">SR</span>
                </div>
              </div>

              <div class="col-md-3">
                <label class="form-label">Patient Share Amount</label>
                <div class="input-group">
                  <input type="number" min="0" step="0.01" class="form-control" id="patientShare" value="0">
                  <span class="input-group-text">SR</span>
                </div>
              </div>

              <div class="col-md-3">
                <label class="form-label">Payer Share</label>
                <div class="input-group">
                  <input type="number" min="0" step="0.01" class="form-control" id="payerShare" value="0">
                  <span class="input-group-text">SR</span>
                </div>
              </div>

              <div class="col-md-3">
                <label class="form-label">Net</label>
                <div class="input-group">
                  <input type="number" class="form-control" id="netAmount" readonly>
                  <span class="input-group-text">SR</span>
                </div>
              </div>

              <div class="col-md-3 d-flex align-items-end">
                <div class="form-check me-4">
                  <input class="form-check-input" type="radio" name="isPackage" id="isPackageNo" value="false" checked>
                  <label class="form-check-label" for="isPackageNo" valu="false">Is Package? No</label>
                </div>
                <div class="form-check me-4">
                  <input class="form-check-input" type="radio" name="isMaternity" id="isMaternityNo" value="false" checked>
                  <label class="form-check-label" for="isMaternityNo">Is Maternity? No</label>
                </div>
              </div>
            </div>

            <div class="d-flex justify-content-end mt-3">
              <button id="btnAddItem" class="btn btn-primary" type="button">Add</button>
            </div>

            <div class="items-box" id="itemsBox" hidden>
              <div class="items-header">
                <div></div>
                <div>Sequence No.</div>
                <div>Invoice No.</div>
                <div>Type</div>
                <div>Code - Description</div>
                <div>Net <span class="muted">/ Tax</span></div>
                <div>Benefit <span class="muted">/ Tax</span></div>
                <div>Status</div>
                <div>Adjudication Reason Code</div>
                <div>Note No.</div>
                <div></div>
              </div>
              <div id="itemsRows"></div>
            </div>
          </div>
          <input type="hidden" name="items_json" id="items_json">
        </div>
      </div>
    </div>

    <script>
  // … ضمن سكربت العناصر …
  function captureCurrent(){
    const elType    = document.getElementById('type_svc');
    const elStd     = document.getElementById('stdSelect');
    const elNonCode = document.getElementById('nonStdCode');
    const elNonDesc = document.getElementById('nonStdDesc');
    const elSvcId   = document.getElementById('service_id');

    const elInv     = document.getElementById('invoiceNo');
    const elQty     = document.getElementById('quantity');
    const elQtyType = document.getElementById('qtyType');
    const elUnit    = document.getElementById('unitPrice');
    const elTax     = document.getElementById('taxAmount');
    const elFactor  = document.getElementById('factor');
    const elDisc    = document.getElementById('discountAmount');
    const elBen     = document.getElementById('patientShare');
    const elPayer   = document.getElementById('payerShare');
    const elStart   = document.getElementById('startDate');
    const elEnd     = document.getElementById('endDate');
    const isPackage   = document.querySelector('input[name="isPackage"]:checked')?.value || 'false';
    const isMaternity = document.querySelector('input[name="isMaternity"]:checked')?.value || 'false';

    // استخرج من القياسي أولاً ثم غير القياسي
    const stdText = (elStd?.options[elStd.selectedIndex]?.text || '').trim();
    const codeStd = (elStd?.value || '').trim();
    const code    = codeStd || (elNonCode?.value || '').trim();
    const desc    = stdText || (elNonDesc?.value || '').trim();

    const qty      = parseFloat(elQty?.value || 0);
    const unit     = parseFloat(elUnit?.value || 0);
    const factor   = parseFloat(elFactor?.value || 1);
    const disc     = parseFloat(elDisc?.value || 0);
    const tax      = parseFloat(elTax?.value || 0);
    const net      = Math.max(0, qty * unit * factor - disc);

    return {
      seq:        (window.__items?.length || 0) + 1,
      invoiceNo:  (elInv?.value || '').trim(),
      type:       (elType?.options[elType.selectedIndex]?.text || '').trim() || (elType?.value || ''),
      code, desc,
      nonStdCode: (elNonCode?.value || '').trim(),
      nonStdDesc: (elNonDesc?.value || '').trim(),
      qty:        qty,
      qtyType:    (elQtyType?.value || 'Unit'),
      unitPrice:  unit,
      factor:     factor,
      discount:   disc,
      tax:        tax,
      patientShare: elBen && elBen.value!=='' ? parseFloat(elBen.value) : 0,
      payerShare:   elPayer && elPayer.value!=='' ? parseFloat(elPayer.value) : 0,
      net:        net,
      isPackage,
     isMaternity,
      startDate:  elStart?.value || null,
      endDate:    elEnd?.value || null,
      serviceId:  (elSvcId?.value || '').trim()
    };
  }

  // عند الإضافة: خزّن في مصفوفة items وأرسلها للحقل المخفي items_json
  (function(){
    const $rows    = document.getElementById('itemsRows');
    const $box     = document.getElementById('itemsBox');
    const $payload = document.getElementById('items_json');
    window.__items = window.__items || [];

    function renderRow(it){ /* … كود عرض الصف لديك … */ }

    function refresh(){
      $rows.innerHTML = '';
      window.__items.forEach(it => $rows.appendChild(renderRow(it)));
      $box.hidden = window.__items.length === 0;
      $payload.value = JSON.stringify(window.__items);
    }

    document.getElementById('btnAddItem')?.addEventListener('click', (e)=>{
      e.preventDefault();
      const it = captureCurrent();
      if(!it.code && !it.nonStdCode){ alert('اختر/أدخل الكود'); return; }
      window.__items.push(it);
      refresh();
    });

    // عند إرسال النموذج الرئيسي: تأكد أن JSON مُحدّث
    document.getElementById('preauthForm')?.addEventListener('submit', ()=>{
      document.getElementById('items_json').value = JSON.stringify(window.__items||[]);
    });
  })();
</script>


    <!-- ===== Tab: Accident (لا نموذج متداخل) ===== -->
    <div class="tab-pane fade" id="accident" role="tabpanel" aria-labelledby="accident-tab" tabindex="0">
      <div class="section-wrap">
        <div class="section-head h5">Accident</div>
        <div class="section-body" id="accidentForm" novalidate>
          <div class="row g-3">
            <div class="col-lg-3">
              <label class="form-label">Accident Type</label>
              <select class="form-select" name="accident_type" id="accident_type">
                <option value="" selected disabled hidden>Select Accident Type</option>
                <option value="motor-vehicle">Motor Vehicle</option>
                <option value="workplace">Workplace</option>
                <option value="sporting">Sporting Accident</option>
                <option value="fall">Fall / Slip</option>
                <option value="other">Other</option>
              </select>
            </div>
            <div class="col-lg-3">
              <label class="form-label">Street Name</label>
              <input type="text" class="form-control" name="street_name" id="street_name">
            </div>
            <div class="col-lg-3">
              <label class="form-label">City</label>
              <input type="text" class="form-control" name="city" id="city">
            </div>
            <div class="col-lg-3">
              <label class="form-label">Date</label>
              <div class="input-group">
                <input type="date" class="form-control" name="accident_date" id="accident_date">
                <button class="input-group-text" type="button" id="dateBtn" title="Pick date">
                  <i class="bi bi-calendar-date"></i>
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- ===== Tab: Encounter ===== -->
    <div class="tab-pane fade" id="encounter" role="tabpanel" aria-labelledby="encounter-tab" tabindex="0">
      <div class="card-like">
        <div class="card-head h5">Encounter <span class="req">*</span></div>
        <div class="card-body">
          <div class="row g-3">
            <div class="col-lg-3">
              <label class="form-label">Status <span class="req">*</span></label>
              <select class="form-select" name="status" id="status" required>
                <option value="planned" selected>Planned</option>
                <option value="arrived">Arrived</option>
                <option value="in-progress">In Progress</option>
                <option value="finished">Finished</option>
                <option value="cancelled">Cancelled</option>
              </select>
              <div class="invalid-feedback">Please choose status.</div>
            </div>

            <div class="col-lg-3">
              <label class="form-label">Class <span class="req">*</span></label>
              <select class="form-select" name="class" id="class" required>
                <option value="ambulatory" selected>Ambulatory</option>
                <option value="inpatient">Inpatient</option>
                <option value="emergency">Emergency</option>
                <option value="observation">Observation</option>
                <option value="virtual">Virtual</option>
              </select>
              <div class="invalid-feedback">Please choose class.</div>
            </div>

            <div class="col-lg-3">
              <label class="form-label">Service Type</label>
              <select class="form-select" name="service_type" id="service_type">
                <option value="acute" selected>Acute Care</option>
                <option value="rehab">Rehabilitation</option>
                <option value="ltc">Long Term Care</option>
                <option value="day-surgery">Day Surgery</option>
                <option value="home-care">Home Care</option>
              </select>
            </div>

            <div class="col-lg-3">
              <label class="form-label">Priority</label>
              <select class="form-select" name="priority" id="priority">
                <option value="EL" selected>EL - Elective</option>
                <option value="EM">EM - Emergency</option>
                <option value="UR">UR - Urgent</option>
                <option value="R">R - Routine</option>
              </select>
            </div>

            <div class="col-lg-3">
              <label class="form-label">Start Period <span class="req">*</span></label>
              <div class="input-group">
                <input type="datetime-local" class="form-control" id="startPeriod" name="start_period" required>
                <button class="input-group-text" type="button" id="startBtn" aria-label="Pick start"><i class="bi bi-calendar-event"></i></button>
                <div class="invalid-feedback">Select start date/time.</div>
              </div>
            </div>

            <div class="col-lg-3">
              <label class="form-label">End Period</label>
              <div class="input-group">
                <input type="datetime-local" class="form-control" id="endPeriod" name="end_period">
                <button class="input-group-text" type="button" id="endBtn" aria-label="Pick end"><i class="bi bi-calendar-event"></i></button>
              </div>
              <div class="mini-note small">Required automatically if status = Finished</div>
            </div>

            <div class="col-lg-3">
              <label class="form-label">Cause of Death</label>
              <div class="input-group">
                <input class="form-control" list="deathCodes" id="causeOfDeath" name="cause_of_death" placeholder="Select cause of death">
                <span class="input-group-text"><i class="bi bi-search"></i></span>
                <datalist id="deathCodes">
                  <option value="R99 — Ill-defined and unknown cause of mortality"></option>
                  <option value="I21 — Acute myocardial infarction"></option>
                  <option value="I64 — Stroke, not specified"></option>
                  <option value="C34 — Malignant neoplasm of bronchus and lung"></option>
                  <option value="U07.1 — COVID-19, virus identified"></option>
                </datalist>
              </div>
            </div>

            <div class="col-lg-3">
              <label class="form-label">Service Event Type <span class="req">*</span></label>
              <select class="form-select" name="service_event_type" id="service_event_type" required>
                <option value="initial" selected>Initial client service event</option>
                <option value="followup">Follow-up visit</option>
                <option value="procedure-session">Procedure session</option>
                <option value="telehealth">Telehealth session</option>
              </select>
              <div class="invalid-feedback">Please choose event type.</div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- ===== Actions ===== -->
    <div class="d-flex justify-content-end gap-2 mt-4">
      <button class="btn btn-outline-secondary" type="reset" id="btnClear">Clear</button>
      <button class="btn btn-primary px-4" type="submit"><i class="bi bi-save me-1"></i> Save</button>
    </div>

  </form>
</div>

<!-- Bootstrap Bundle -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
// ========= Tag input (Preauth refs) =========
(function initTags(){
  const root   = document.getElementById('preauthRefs');
  const input  = root.querySelector('input');
  const hidden = document.getElementById(root.dataset.hiddenTarget);
  let tags = [];

  function render(){
    [...root.querySelectorAll('.tag')].forEach(el => el.remove());
    tags.forEach((t, i) => {
      const tag = document.createElement('span');
      tag.className = 'tag';
      tag.innerHTML = `<span>${t}</span><button type="button" class="remove" aria-label="Remove">&times;</button>`;
      tag.querySelector('.remove').addEventListener('click', () => { tags.splice(i, 1); render(); });
      root.insertBefore(tag, input);
    });
    hidden.value = tags.join(',');
  }
  function commit(){
    let v = input.value.trim().replace(/,+$/,'');
    if(!v) return; tags.push(v); input.value = ''; render();
  }
  input.addEventListener('keydown', (e) => {
    if (e.key === 'Enter' || e.key === ','){ e.preventDefault(); commit(); }
  });
  input.addEventListener('blur', commit);
  root.addEventListener('click', () => input.focus());
  render();
})();
</script>

<script>
// ========= تفعيل/تعطيل حقول الإحالة عند السويتش =========
(function(){
  const sw = document.getElementById('hasPreauth');
  const sectionEls = [
    document.getElementById('preauth-section'),
    document.getElementById('preauthDetailsSelect')?.closest('.col-lg-4'),
    document.getElementById('preauthRefsWrapper')
  ].filter(Boolean);
  function apply(){
    const on = sw.checked;
    sectionEls.forEach(col => {
      col.classList.toggle('is-section-disabled', !on);
      col.querySelectorAll('input,select,textarea').forEach(el => el.disabled = !on);
    });
  }
  sw.checked = false; apply();
  sw.addEventListener('change', apply);
})();
</script>

<script>
// ========= تشغيـل التحقق فقط للتبويب النشِط + تجميع JSON قبل الإرسال =========
(function () {
  const form = document.getElementById('preauthForm');

  function collectSupportingRows(){
    const tbody = document.querySelector('#supTable tbody');
    const rows = [...tbody.querySelectorAll('tr')].map((tr,i)=>({
      SEQUENCENO: i+1,
      CATEGORY:   tr.querySelector('.category').value,
      REASON:     tr.querySelector('.reason').value.trim() || null,
      SUPPORTINGVALUE: tr.querySelector('.svalue').value.trim() || null,
      UNIT:       tr.querySelector('.unit').value.trim() || null
    }));
    document.getElementById('supporting_rows_json').value = JSON.stringify(rows);
  }

  function collectDiagnosisRows(){
    const dxRows = [...document.querySelectorAll('#dxRows .dx-row')].map(r=>({
      code_id: r.querySelector('.code-id').value,
      text:    r.querySelector('.code-input').value.trim(),
      type:    r.querySelector('.type-select').value
    })).filter(x=>x.text);
    document.getElementById('diagnosis_json').value = JSON.stringify(dxRows);
  }

  form.addEventListener('submit', function (e) {
    // عطّل required مؤقتًا داخل التبويبات غير النشطة
    const hiddenRequired = [...form.querySelectorAll('.tab-pane:not(.show,.active) [required]')];
    hiddenRequired.forEach(el => { el.dataset.wasRequired = '1'; el.required = false; });

    // قبل الإرسال: جهّز JSON
    collectSupportingRows();
    collectDiagnosisRows();

    if (!form.checkValidity()) {
      e.preventDefault();
      e.stopPropagation();
      // أعد required كما كان
      hiddenRequired.forEach(el => { if (el.dataset.wasRequired) el.required = true; });
    }
    form.classList.add('was-validated');
  });
})();
</script>

<script>
// ========= Diagnosis (Autocomplete بسيط) =========
const DX_SEARCH_API = 'api/search_services.php'; // عدّل المصدر
const MIN_CHARS = 1;
function escHtml(s){return (s||'').toString().replace(/[&<>"']/g,m=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;','\'':'&#39;'}[m]))}
const $dxRows = document.getElementById('dxRows');
const $dxCount = document.getElementById('countBadge');

function dxUpdateCount(){ $dxCount.textContent = $dxRows.querySelectorAll('.dx-row').length; }

function createDxRow(initial={}) {
  const wrap = document.createElement('div');
  wrap.className = 'dx-row mb-2';

  wrap.innerHTML = `
    <div class="row g-2 align-items-center">
      <div class="col-md-8">
        <div class="position-relative">
          <input type="text" class="form-control code-input" placeholder="Search diagnosis code here..." autocomplete="off">
          <input type="hidden" class="code-id">
          <div class="dx-menu position-absolute bg-white border rounded w-100" style="display:none;max-height:220px;overflow:auto;z-index:20;"></div>
        </div>
      </div>
      <div class="col-md-3">
        <select class="form-select type-select">
          <option value="">Select Type</option>
          <option value="principaldiagnosis">Principal Diagnosis</option>
          <option value="secondarydiagnosis">Secondary Diagnosis</option>
          <option value="admittingdiagnosis">Admitting Diagnosis</option>
          <option value="Complication">Complication</option>
        </select>
      </div>
      <div class="col-md-1 text-end">
        <button type="button" class="btn btn-outline-danger btn-sm remove-btn">🗑️</button>
      </div>
    </div>
  `;

  const inp  = wrap.querySelector('.code-input');
  const hid  = wrap.querySelector('.code-id');
  const type = wrap.querySelector('.type-select');
  const menu = wrap.querySelector('.dx-menu');

  if (initial.text) inp.value = initial.text;
  if (initial.id)   hid.value = initial.id;
  if (initial.type) type.value= initial.type;

  wrap.querySelector('.remove-btn').addEventListener('click', ()=>{ wrap.remove(); dxUpdateCount(); });

  let timer=null, idx=-1, items=[];

  function hide(){ menu.style.display='none'; menu.innerHTML=''; idx=-1; }
  function show(){ menu.style.display='block'; }
  function highlight(){
    menu.querySelectorAll('.dx-item').forEach((d,i)=>d.classList.toggle('bg-light', i===idx));
  }
  function render(list){
    items = list||[];
    if (!items.length){ hide(); return; }
    menu.innerHTML = items.map((it,i)=>`
      <div class="dx-item p-2 border-bottom" data-i="${i}">
        <div class="fw-semibold">${escHtml(it.code||'—')} — ${escHtml(it.name_ar||it.name_en||'')}</div>
        <div class="text-muted small">${escHtml(it.name_en||'')}</div>
      </div>`).join('');
    show(); idx=0; highlight();
  }
  function pick(i){
    const it = items[i]; if(!it) return;
    inp.value = `${it.code||''} — ${it.name_ar||it.name_en||''}`.trim();
    hid.value = it.id || it.service_id || it.code || '';
    hide();
  }

  inp.addEventListener('input', ()=>{
    const q = inp.value.trim(); hid.value='';
    if (q.length < MIN_CHARS){ hide(); return; }
    clearTimeout(timer);
    timer = setTimeout(async ()=>{
      try{
        const res = await fetch(`${DX_SEARCH_API}?q=${encodeURIComponent(q)}`);
        const js  = await res.json();
        render(js.results||[]);
      }catch(e){ hide(); }
    }, 150);
  });

  inp.addEventListener('keydown', e=>{
    const open = menu.style.display==='block'; if(!open) return;
    const max = menu.querySelectorAll('.dx-item').length - 1;
    if (e.key==='ArrowDown'){ idx=Math.min(max, idx+1); highlight(); e.preventDefault(); }
    else if (e.key==='ArrowUp'){ idx=Math.max(0, idx-1); highlight(); e.preventDefault(); }
    else if (e.key==='Enter' || e.key==='Tab'){ if(idx>=0){ pick(idx); e.preventDefault(); } }
    else if (e.key==='Escape'){ hide(); }
  });
  menu.addEventListener('mousedown', e=>{
    const el = e.target.closest('.dx-item'); if (el) pick(parseInt(el.dataset.i,10));
  });
  document.addEventListener('click', e=>{ if (!wrap.contains(e.target)) hide(); });

  return wrap;
}

document.getElementById('dxAddRowBtn').addEventListener('click', ()=>{
  $dxRows.appendChild(createDxRow());
  dxUpdateCount();
});
// صف ابتدائي
$dxRows.appendChild(createDxRow());
dxUpdateCount();
</script>

<script>
// ========= Supporting Info =========
const CATEGORIES = [
  {key:'vital-sign-weight',        unit:'kg',     reason:''},
  {key:'oxygen-saturation',        unit:'%',      reason:''},
  {key:'treatment-plan',           unit:'',       reason:''},
  {key:'vital-sign-height',        unit:'cm',     reason:''},
  {key:'pulse',                    unit:'/min',   reason:''},
  {key:'vital-sign-systolic',      unit:'mmHg',   reason:''},
  {key:'vital-sign-diastolic',     unit:'mmHg',   reason:''},
  {key:'chief-complaint',          unit:'',       reason:''},
  {key:'respiratory-rate',         unit:'/min',   reason:''},
  {key:'investigation-result',     unit:'',       reason:'unknown'},
  {key:'temperature',              unit:'°C',     reason:''},
  {key:'birth-weight',             unit:'kg',     reason:''},
  {key:'patient-history',          unit:'',       reason:'unknown'},
  {key:'history-of-present-illness',unit:'',      reason:'unknown'},
  {key:'physical-examination',     unit:'',       reason:'unknown'},
];
function pretty(key){ return key.replace(/-/g, ' ').replace(/\b\w/g, m=>m.toUpperCase()); }

const $supTbody   = document.querySelector('#supTable tbody');
const $rowsCount  = document.getElementById('rowsCount');
function supUpdateCount(){ $rowsCount.textContent = $supTbody.querySelectorAll('tr').length; }
function supNextSeq(){ return $supTbody.querySelectorAll('tr').length + 1; }

function firstUnusedCategory(){
  const used = new Set([...$supTbody.querySelectorAll('select.category')].map(s=>s.value));
  return CATEGORIES.find(c=>!used.has(c.key)) || CATEGORIES[0];
}
function buildCategoryOptions(selected=''){
  return CATEGORIES.map(c=>{
    const sel = c.key === selected ? 'selected' : '';
    return `<option value="${c.key}" ${sel}>${pretty(c.key)}</option>`;
  }).join('');
}
function supRenumber(){
  [...$supTbody.querySelectorAll('tr')].forEach((tr,i)=>{
    tr.querySelector('.seq').textContent = i+1;
  });
}
function supAddRow(initial={}){
  const catInfo = CATEGORIES.find(c=>c.key===initial.category) || firstUnusedCategory();
  const seq = supNextSeq();
  const tr = document.createElement('tr');
  tr.innerHTML = `
    <td class="text-center fw-semibold seq">${seq}</td>
    <td>
      <select class="form-select category">
        ${buildCategoryOptions(catInfo.key)}
      </select>
    </td>
    <td><input type="text" class="form-control reason" placeholder="Reason" value="${initial.reason ?? catInfo.reason ?? ''}"></td>
    <td><input type="text" class="form-control svalue" placeholder="Value"  value="${initial.value ?? ''}"></td>
    <td><input type="text" class="form-control unit"   placeholder="Unit"   value="${initial.unit ?? catInfo.unit ?? ''}"></td>
    <td class="text-center"><button type="button" class="btn btn-outline-danger btn-sm remove-btn">✖</button></td>
  `;
  const sel   = tr.querySelector('select.category');
  const unit  = tr.querySelector('input.unit');
  const reason= tr.querySelector('input.reason');
  sel.addEventListener('change',()=>{
    const info = CATEGORIES.find(c=>c.key===sel.value);
    if (!info) return;
    if (!unit.value)   unit.value   = info.unit || '';
    if (!reason.value) reason.value = info.reason || '';
  });
  tr.querySelector('.remove-btn').addEventListener('click', ()=>{ tr.remove(); supRenumber(); supUpdateCount(); });
  $supTbody.appendChild(tr); supUpdateCount();
}
function supAddAllDefaults(){
  const used = new Set([...$supTbody.querySelectorAll('select.category')].map(s=>s.value));
  CATEGORIES.forEach(c=>{ if (!used.has(c.key)) supAddRow({category:c.key, reason:c.reason||'', unit:c.unit||''}); });
}

document.getElementById('supAddRowBtn').addEventListener('click', ()=> supAddRow({}));
document.getElementById('supAddAllBtn').addEventListener('click', supAddAllDefaults);
supAddRow({});
</script>

<script>
// ========= Items: Autocomplete + إضافة للجدول + JSON =========
function g(obj, ...keys){
  for (const k of keys){ const v = obj?.[k]; if (v!==undefined && v!==null && String(v).trim()!=='') return v; }
  return '';
}
function normalizeService(it){
  return {
    id:        g(it,'service_id','id'),
    type:      g(it,'SERVICE_TYPE','type'),
    code:      g(it,'SERVICE_CODE','code'),
    nonCode:   g(it,'NON_STANDARD_CODE','non_code'),
    nonDesc:   g(it,'NON_STANDARD_DESC','non_desc','desc'),
    nameAr:    g(it,'service_name_ar','name_ar'),
    nameEn:    g(it,'service_name_en','name_en'),
    price:     Number(g(it,'UNIT_PRICE','price')) || 0,
    factor:    Number(g(it,'FACTOR','factor')) || 1,
    company:   g(it,'insurancecompanyname','company'),
    specialty: g(it,'specialty','SPECIALTY')
  };
}
const SERVICE_API = 'api/search_services.php'; // عدّل للمسار الصحيح
const $search  = document.getElementById('globalSearch');
const $menu    = document.getElementById('searchMenu');
const $stdSel  = document.getElementById('stdSelect');
const $typeSvc = document.getElementById('type_svc');
const $nonCode = document.getElementById('nonStdCode');
const $nonDesc = document.getElementById('nonStdDesc');
const $uprice  = document.getElementById('unitPrice');
const $factor  = document.getElementById('factor');
const $svcId   = document.getElementById('service_id');
const $qty     = document.getElementById('quantity');
const $disc    = document.getElementById('discountAmount');
const $tax     = document.getElementById('taxAmount');
const $net     = document.getElementById('netAmount');

function setStdSelect(itemText, itemValue){
  $stdSel.innerHTML = '';
  const opt = new Option(itemText || '—', itemValue || '');
  $stdSel.add(opt); $stdSel.value = itemValue || '';
}

// Autocomplete
let timer=null, idx=-1, items=[];
function hideMenu(){ $menu.style.display='none'; $menu.innerHTML=''; }
function showMenu(){ $menu.style.display='block'; }
function highlight(){
  $menu.querySelectorAll('.ac-item').forEach((d,i)=>d.classList.toggle('active', i===idx));
  const a = $menu.querySelector('.ac-item.active'); if (a) a.scrollIntoView({block:'nearest'});
}
function render(list){
  items = list.map(normalizeService);
  if (!items.length){ hideMenu(); return; }
  $menu.innerHTML = items.map((it,i)=>`
    <div class="ac-item" data-i="${i}">
      <div class="l">
        <div class="t">${escHtml(it.code || '—')} — ${escHtml(it.nameAr || it.nameEn || '')}</div>
        <div class="s">
          ${it.nonCode ? 'NSC: '+escHtml(it.nonCode)+' • ' : ''}
          ${it.specialty ? escHtml(it.specialty)+' • ' : ''}
          ${it.company ? escHtml(it.company) : ''}
        </div>
      </div>
      <div class="s">SR ${it.price.toFixed(2)}</div>
    </div>
  `).join('');
  showMenu(); idx = 0; highlight();
}
function pick(i){
  const it = items[i]; if (!it) return;
  $svcId.value   = it.id || '';
  setStdSelect(`${it.code||''} — ${it.nameAr||it.nameEn||''}`.trim(), it.code||'');
  if (it.type)   $typeSvc.value = it.type;
  $nonCode.value = it.nonCode || '';
  $nonDesc.value = it.nonDesc || it.nameEn || it.nameAr || '';
  $uprice.value  = it.price.toFixed(2);
  $factor.value  = it.factor;
  hideMenu();
  recalc();
}
$search.addEventListener('input', ()=>{
  const q = $search.value.trim();
  if (q.length < 1){ hideMenu(); return; }
  clearTimeout(timer);
  timer = setTimeout(async ()=>{
    try{
      const res = await fetch(`${SERVICE_API}?q=${encodeURIComponent(q)}`);
      const js  = await res.json();
      render(js.results || []);
    }catch(e){ hideMenu(); }
  }, 150);
});
$menu.addEventListener('mousedown', (e)=>{
  const el = e.target.closest('.ac-item'); if (!el) return;
  pick(parseInt(el.dataset.i,10));
});
document.addEventListener('click', (e)=>{ 
  if (!document.querySelector('.ac-wrap').contains(e.target)) hideMenu();
});
$search.addEventListener('keydown', (e)=>{
  const open = $menu.style.display==='block'; if (!open) return;
  const max = $menu.querySelectorAll('.ac-item').length - 1;
  if (e.key==='ArrowDown'){ idx=Math.min(max, idx+1); highlight(); e.preventDefault(); }
  else if (e.key==='ArrowUp'){ idx=Math.max(0, idx-1); highlight(); e.preventDefault(); }
  else if (e.key==='Enter'){ if (idx>=0){ pick(idx); e.preventDefault(); } }
  else if (e.key==='Escape'){ hideMenu(); }
});

// Items list
(function(){
  const $rows    = document.getElementById('itemsRows');
  const $box     = document.getElementById('itemsBox');
  const $payload = document.getElementById('items_json');
  const items    = [];

  const fmt = n => (Math.round((+n||0)*100)/100).toFixed(2);
  function textOfSelect(sel){
    if (!sel) return '';
    const opt = sel.options[sel.selectedIndex] || sel.options[0];
    return opt ? opt.text.trim() : '';
  }
  function renderRow(it){
    const row = document.createElement('div');
    row.className = 'items-row';
    row.innerHTML = `
      <div class="expander">+</div>
      <div>${it.seq}</div>
      <div>${it.invoiceNo || '-'}</div>
      <div>${it.type || '-'}</div>
      <div class="code-desc">${it.code ? it.code+' - ' : ''}${it.desc || ''}</div>
      <div>${fmt(it.net)} <span class="muted">SR / ${fmt(it.tax)} SR</span></div>
      <div>${it.benefit!=null ? fmt(it.benefit) : '-'} <span class="muted">${it.benefit!=null ? 'SR' : ''}</span></div>
      <div>${it.status || '-'}</div>
      <div>${it.reason || '-'}</div>
      <div>${it.noteNo || '-'}</div>
      <div class="cell-actions">⋮</div>
    `;
    row.querySelector('.expander').addEventListener('click', ()=>{
      alert(
        `Details:\n`+
        `Code: ${it.code}\nDesc: ${it.desc}\nQty: ${it.qty}\nUnit: ${fmt(it.unit)} SR\nFactor: ${fmt(it.factor)}\nService ID: ${it.serviceId||'-'}`
      );
    });
    return row;
  }
  function refresh(){
    $rows.innerHTML = '';
    items.forEach(it => $rows.appendChild(renderRow(it)));
    $box.hidden = items.length === 0;
    $payload.value = JSON.stringify(items);
  }
  function captureCurrent(){
    const elInv   = document.getElementById('invoiceNo');
    const elQty   = document.getElementById('quantity');
    const elUnit  = document.getElementById('unitPrice');
    const elTax   = document.getElementById('taxAmount');
    const elFact  = document.getElementById('factor');
    const elDisc  = document.getElementById('discountAmount');
    const elBen   = document.getElementById('patientShare');
    const elPayer = document.getElementById('payerShare');

    const code = (document.getElementById('stdSelect')?.value || '').trim() || (document.getElementById('nonStdCode')?.value || '').trim();
    let desc   = textOfSelect(document.getElementById('stdSelect'));
    if (!desc) desc = (document.getElementById('nonStdDesc')?.value || '').trim();

    const qty    = parseFloat(elQty?.value || 1);
    const unit   = parseFloat(elUnit?.value || 0);
    const factor = parseFloat(elFact?.value || 1);
    const disc   = parseFloat(elDisc?.value || 0);
    const tax    = parseFloat(elTax?.value || 0);
    const net    = Math.max(0, qty * unit * factor - disc);

    return {
      seq:       items.length + 1,
      invoiceNo: (elInv?.value || '').trim(),
      type:      textOfSelect(document.getElementById('type_svc')) || 'Procedures',
      code, desc,
      net, tax,
      benefit:   elBen && elBen.value !== '' ? parseFloat(elBen.value) : null,
      payerShare:elPayer && elPayer.value !== '' ? parseFloat(elPayer.value) : null,
      status:    '-',
      reason:    '-',
      noteNo:    '-',
      qty, unit, factor, discount: disc,
      serviceId: (document.getElementById('service_id')?.value || '').trim()
    };
  }
  document.getElementById('btnAddItem').addEventListener('click', (e)=>{
    e.preventDefault();
    const curr = captureCurrent();
    if (!curr.code){
      alert('اختر خدمة أولًا (كود قياسي أو غير قياسي).');
      return;
    }
    if (!curr.invoiceNo){
      alert('Invoice No مطلوب.');
      return;
    }
    items.push(curr);
    refresh();
  });

  // حساب الصافي لحظيًا
  function onChange(){ recalc(); }
  ['quantity','unitPrice','factor','discountAmount'].forEach(id=>{
    const el=document.getElementById(id); if (el) el.addEventListener('input', onChange);
  });
  window.recalc = function(){
    const qty    = parseFloat($qty.value || 1);
    const price  = parseFloat($uprice.value || 0);
    const fac    = parseFloat($factor.value || 1);
    const disc   = parseFloat($disc.value || 0);
    const net    = Math.max(0, qty*price*fac - disc);
    $net.value = net.toFixed(2);
  };
})();
</script>

</body>
</html>
