<?php
$host = "localhost:3306";
$dbname = "acesaudi_site";
$username = "acesaudi_usr";
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("فشل الاتصال بقاعدة البيانات: " . $e->getMessage());
}

$from = $_GET['from'] ?? date('Y-m-d');
$to = $_GET['to'] ?? date('Y-m-d', strtotime('+7 days'));
$total_session = intval($_GET['total_session'] ?? 1);
$roomno = $_GET['roomno'] ?? '';
$patientname = $_GET['patient_name'] ?? '';
$serviceedid = $_GET['serviceedid'] ?? '';
$patient = $_GET['patient_id'] ?? '';
$typeservice = $_GET['typeservice'] ?? '';
$spesilstid = $_GET['spesilstid'] ?? '';

$startTime = '08:00:00';
$endTime = '12:30:00';
$stmt = $pdo->prepare("SELECT * FROM bookings WHERE bookingstatus = 'متوفر' AND booking_date BETWEEN :from AND :to AND room_id = :roomno AND time_slot BETWEEN :start_time AND :end_time ORDER BY booking_date, time_slot");
$stmt->execute([
    ':from' => $from,
    ':to' => $to,
    ':roomno' => $roomno,
    ':start_time' => $startTime,
    ':end_time' => $endTime
]);
$slots = $stmt->fetchAll(PDO::FETCH_ASSOC);

$grouped_slots = [];
foreach ($slots as $slot) {
    $grouped_slots[$slot['booking_date']][] = $slot;
}
?>
<?php include 'sessionheaderrecption.php'; ?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>تحديد الفترات</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">
    <style>
        body { font-family: Tahoma; background: #f0f0f0; }
        label, input { display: block; margin: 5px 0; direction: rtl; font-family: Tajawal,sans-serif; font-size: large; }
        .slots { margin: 15px 0; }
        .slot { background: #d4edda; padding: 10px; margin: 5px; border-radius: 5px; border: 1px solid #28a745; display: inline-block; }
        .slot input { margin-left: 5px; }
        button { padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; margin-top: 20px; }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
<?php include 'receptionheader.php'; ?>
<aside class="main-sidebar">
    <section class="sidebar">
        <?php include 'receptionsidepanle.php'; ?>
        <?php include 'searchform.php'; ?>
        <?php include 'navemenureception.php'; ?>
    </section>
</aside>
<div class="content-wrapper">
<section class="content-header">
    <ol class="breadcrumb">
        <li><a href="receptiondashboard.php"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Search By Appoiment</a></li>
    </ol>
</section>
<section class="content">
<div class="box">
<div class="box-header with-border">
    <h3 class="box-title" style="font-family: Tajawal;">فلترة الفترات حسب التاريخ وعدد الجلسات</h3>
</div>
<div class="box-body">
<div class="col-md-12" style="text-align: center;">
<form method="GET">
    <div class="col-md-6">
        <div class="form-group">
            <label>تاريخ الحجز إلى</label>
            <input type="date" name="to" value="<?= htmlspecialchars($to) ?>" required class="form-control">
        </div>
        <div class="form-group">
            <label>المستفيد</label>
            <input type="text" name="patient_name" value="<?= htmlspecialchars($patientname) ?>" required class="form-control" readonly>
        </div>
        <div class="form-group">
            <label>رقم ملف المستفيد</label>
            <input type="text" name="patient_id" value="<?= htmlspecialchars($patient) ?>" required class="form-control" readonly>
        </div>
        <div class="form-group">
            <label>رقم الأخصائي</label>
            <input type="text" name="spesilstid" value="<?= htmlspecialchars($spesilstid) ?>" required class="form-control" readonly>
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            <label>تاريخ الحجز من</label>
            <input type="date" name="from" value="<?= htmlspecialchars($from) ?>" required class="form-control"> 
        </div>
        <div class="form-group">
            <label>رقم الغرفة</label>
            <input type="text" name="roomno" value="<?= htmlspecialchars($roomno) ?>" required class="form-control" readonly> 
        </div>
        <div class="form-group">
            <label>رقم الخدمة</label>
            <input type="text" name="serviceedid" value="<?= htmlspecialchars($serviceedid) ?>" required class="form-control" readonly>
        </div>
        <div class="form-group">
            <label>نوع الخدمة</label>
            <input type="text" name="typeservice" value="<?= htmlspecialchars($typeservice) ?>" required class="form-control" readonly>
        </div>
    </div>
    <div class="col-md-12">
        <div class="from-group">
            <label>عدد الجلسات المطلوبة في نفس اليوم</label>
            <input type="number" name="total_session" value="<?= htmlspecialchars($total_session) ?>" min="1" required onchange="this.form.submit();" class="form-control">
        </div>
    </div>
</form>
<br>
<?php if ($total_session > 0 && !empty($grouped_slots)): ?>
<form method="POST" action="updatebook_sloting.php">
    <input type="hidden" name="session_duration" value="45">
    <input type="hidden" name="roomno" value="<?= htmlspecialchars($roomno) ?>">
    <input type="hidden" name="patient_name" value="<?= htmlspecialchars($patientname) ?>">
    <input type="hidden" name="serviceedid" value="<?= htmlspecialchars($serviceedid) ?>">
    <input type="hidden" name="patient_id" value="<?= htmlspecialchars($patient) ?>">
    <input type="hidden" name="typeservice" value="<?= htmlspecialchars($typeservice) ?>">
    <input type="hidden" name="spesilstid" value="<?= htmlspecialchars($spesilstid) ?>">

    <?php foreach ($grouped_slots as $date => $day_slots): ?>
        <?php
            $dayName = date('l', strtotime($date));
            if ($dayName == 'Friday') continue;
        ?>
        <?php if (count($day_slots) >= $total_session): ?>
        <br>
        <h3>تاريخ: <?= $date ?> (عدد الفترات المتاحة: <?= count($day_slots) ?>)</h3>
        <div class="slots">
            <?php for ($i = 0; $i < $total_session; $i++): 
                $slot = $day_slots[$i]; ?>
                <label class="slot">
                    <input type="checkbox" name="selected_slots[]" value="<?= $slot['id'] ?>">
                    من <?= $slot['time_slot'] ?> إلى <?= $slot['end_time'] ?> |
                    الغرفة: <?= $slot['room_id'] ?> |
                    الأخصائي: <?= $slot['spclistsname'] ?? '---' ?> |
                    <strong>نوع الفترة:</strong> <?= htmlspecialchars($slot['period'] ?? 'غير محددة') ?>
                    <input type="hidden" name="slot_types[]" value="<?= htmlspecialchars($slot['typeservice'] ?? 'غير معروف') ?>">
                </label>
            <?php endfor; ?>
        </div>
        <?php endif; ?>
    <?php endforeach; ?>
    <button type="submit">تأكيد الحجز</button>
</form>
<?php else: ?>
<p style="color:red;">⚠️ لا توجد فترات كافية متاحة حسب الفلترة المحددة</p>
<?php endif; ?>
</div>
</div>
</section>
</div>
</div>
</body>
</html>
