<?php
// بدء الجلسة
session_start();

// التحقق مما إذا كان المستخدم مسجلاً للدخول
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: superadminlogin.php");
    exit;
}
// جلب معرف المستخدم من الجلسة
$iduser = $_SESSION["iduser"];
?>
<?php
/********* إعداد الاتصال *********/
$host     = 'localhost:3306';
$dbname   = 'acesaudi_site';
$username = 'acesaudi_usr';
$password = 'tabfyv-6xiFry-noczak';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username, $password, [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
} catch (PDOException $e) { die("DB Error: " . $e->getMessage()); }

function h($v){ return htmlspecialchars((string)($v ?? ''), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }

/********* مُدخلات *********/
$year      = isset($_GET['year']) ? (int)$_GET['year'] : (int)date('Y');
$fulltime  = isset($_GET['fulltime_only']);          // users.worktime = 'Full Time AM 8 hours'
$ids_raw   = trim($_GET['specialist_ids'] ?? '');    // "324,173"
$export    = isset($_GET['export']);

$MONTHS = [1=>'Jan',2=>'Feb',3=>'March',4=>'April',5=>'May',6=>'June',7=>'July',8=>'Aug',9=>'Sep',10=>'Oct',11=>'Nov',12=>'Dec'];
$MONTHLY_TARGET_HOURS = 170.0; // الهدف الشهري الثابت لكل أخصائي

/********* Helpers *********/
function parseIdList($raw){
    $out=[]; if($raw!==''){ foreach(explode(',',$raw) as $id){ $id=trim($id); if($id!==''&&ctype_digit($id)) $out[]=(int)$id; } }
    return $out;
}
$ids = parseIdList($ids_raw);

/* ==== 1) شروط الاستعلام الفرعي على bookings (alias b) ==== */
$subWhere  = ["YEAR(b.booking_date)=?", "TRIM(COALESCE(b.bookingstatus,'')) IN ('مكتمل','محجوز')"];
$subParams = [$year];

if (!empty($ids)) {
    $in = implode(',', array_fill(0, count($ids), '?'));
    $subWhere[] = "b.spesilstid IN ($in)";
    $subParams  = array_merge($subParams, $ids);
}
$subWhereSql = 'WHERE '.implode(' AND ', $subWhere);

/* ==== 2) الاستعلام الفرعي: حساب دقائق كل موعد ==== */
$subSql = "
  SELECT
    b.spesilstid,
    COALESCE(NULLIF(b.spclistsname,''), '') AS spclistsname,
    b.booking_date,
    CASE
      WHEN b.session_duration IS NOT NULL AND b.session_duration > 0
        THEN b.session_duration
      WHEN b.end_time IS NOT NULL AND b.time_slot IS NOT NULL
        THEN GREATEST(0, TIMESTAMPDIFF(MINUTE, CONCAT(b.booking_date,' ',b.time_slot), CONCAT(b.booking_date,' ',b.end_time)))
      ELSE 45
    END AS session_minutes
  FROM bookings b
  $subWhereSql
";

/* ==== 3) شرط خارجي اختياري على users (alias u) ==== */
$outerWhere  = [];
$outerParams = [];
if ($fulltime) {
    $outerWhere[] = "TRIM(COALESCE(u.worktime,''))='Full Time AM 8 hours'";
}
$outerWhereSql = $outerWhere ? ('WHERE '.implode(' AND ', $outerWhere)) : '';

/* ==== 4) الاستعلام النهائي مع Pivot شهري ==== */
$monthSums = [];
foreach (array_keys($MONTHS) as $m) {
    $monthSums[] = "SUM(CASE WHEN MONTH(b2.booking_date)=$m THEN b2.session_minutes ELSE 0 END) AS m$m";
}
$monthSumsSql = implode(",\n  ", $monthSums);

$sql = "
SELECT
  b2.spesilstid AS specialist_id,
  COALESCE(NULLIF(b2.spclistsname,''), u.fullarabicname, 'غير محدد') AS specialist_name,
  u.worktime,
  $monthSumsSql,
  SUM(b2.session_minutes) AS minutes_year
FROM ( $subSql ) b2
LEFT JOIN users u ON u.iduser = b2.spesilstid
$outerWhereSql
GROUP BY b2.spesilstid, specialist_name, u.worktime
ORDER BY minutes_year DESC, specialist_name ASC
";

/* ==== 5) تنفيذ ==== */
$params = array_merge($subParams, $outerParams);
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

/********* تجهيز بيانات العرض *********/
$data = [];
$totals_per_month = array_fill(1,12,0.0);

foreach ($rows as $r){
    $spec = [
        'id'   => $r['specialist_id'],
        'name' => $r['specialist_name'],
        'work' => $r['worktime'],
        'months' => [],
        'year_minutes' => (float)$r['minutes_year'],
        'year_hours'   => ((float)$r['minutes_year'])/60.0,
        'growth'       => 0.0
    ];
    $lastMonthWithHours = 0; $lastVal = 0.0;

    foreach ($MONTHS as $m => $label){
        $min  = (float)($r["m$m"] ?? 0);
        $hrs  = $min / 60.0;
        $kpi  = $MONTHLY_TARGET_HOURS>0 ? ($hrs/$MONTHLY_TARGET_HOURS)*100.0 : 0.0;

        $spec['months'][$m] = ['hours'=>$hrs,'kpi'=>$kpi];
        $totals_per_month[$m] += $hrs;

        if ($hrs > 0) { $lastMonthWithHours = $m; $lastVal = $hrs; }
    }

    // Growth: آخر شهر مقابل السابق له
    if ($lastMonthWithHours > 1) {
        $prevHrs = $spec['months'][$lastMonthWithHours-1]['hours'] ?? 0.0;
        if ($prevHrs > 0) {
            $spec['growth'] = (($lastVal - $prevHrs)/$prevHrs)*100.0;
        } else {
            $spec['growth'] = $lastVal > 0 ? 100.0 : 0.0;
        }
    } else {
        $spec['growth'] = 0.0;
    }

    $data[] = $spec;
}

usort($data, fn($a,$b) => $b['year_hours'] <=> $a['year_hours']);

/********* Export Excel *********/
if ($export) {
    header('Content-Type: application/vnd.ms-excel; charset=utf-8');
    header("Content-Disposition: attachment; filename=\"annual_kpi_{$year}.xls\"");
    echo "<table border='1' style='text-align:center;font-family:Tahoma'>";
    echo "<tr><th>#</th><th>Specialist</th>";
    foreach ($MONTHS as $m=>$lab) echo "<th>{$lab} (hrs)</th>";
    echo "<th>Total (hrs)</th><th>Growth %</th></tr>";
    $i=1;
    foreach ($data as $row){
        echo "<tr>";
        echo "<td>".($i++)."</td>";
        echo "<td>".h($row['name'])."</td>";
        foreach ($MONTHS as $m=>$lab){
            echo "<td>".number_format($row['months'][$m]['hours'],1)."</td>";
        }
        echo "<td>".number_format($row['year_hours'],1)."</td>";
        echo "<td>".number_format($row['growth'],1)."%</td>";
        echo "</tr>";
    }
    // إجمالي شهري
    echo "<tr style='font-weight:bold;background:#f3f5fb'><td colspan='2'>Totals</td>";
    foreach ($MONTHS as $m=>$lab) echo "<td>".number_format($totals_per_month[$m],1)."</td>";
    echo "<td></td><td></td></tr>";
    echo "</table>";
    exit;
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Supervisor ACE | Dashboard</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/AdminLTE.min.css">
  <!-- AdminLTE Skins. Choose a skin from the css/skins
       folder instead of downloading all of them to reduce the load. -->
  <link rel="stylesheet" href="dist/css/skins/_all-skins.min.css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
  <![endif]-->
<title>KPI سنوي للأخصائيين (<?= h($year) ?>)</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
table{border-collapse:collapse;width:100%}
th,td{border:1px solid #ddd;padding:6px;text-align:center}
th{background:#f3f5fb}
.badge{display:inline-block;padding:2px 6px;border-radius:10px;font-size:11px}
.badge.red{background:#f8d7da;color:#721c24}
.badge.orange{background:#fff3cd;color:#856404}
.badge.green{background:#d4edda;color:#155724}
.growth.red{background:#f8d7da}
.growth.green{background:#d4edda}
.small{font-size:12px;color:#666}
.head-sticky thead th{position:sticky;top:0;z-index:2}
.controls{margin:8px 0}
</style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<!-- Site wrapper -->
<div class="wrapper">

  
<?php include 'superadminheader.php'; ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar user panel -->
      <?php include 'supersidepanle.php'; ?>
      <!-- search form -->
     <?php include 'searchform.php'; ?>
      <!-- /.search form -->
      <!-- sidebar menu: : style can be found in sidebar.less -->
        <?php include 'navemenusuper.php'; ?>
    </section>
    <!-- /.sidebar -->
  </aside>

  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        
        <small></small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Yearly FT KPIS Of Our Team </a></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">

      <!-- Default box -->
      <div class="box">
        <div class="box-header with-border">
          <h3 class="box-title">Yearly Full Time KPIS Team Details</h3>

          <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" data-toggle="tooltip" title="Collapse">
              <i class="fa fa-minus"></i></button>
            <button type="button" class="btn btn-box-tool" data-widget="remove" data-toggle="tooltip" title="Remove">
              <i class="fa fa-times"></i></button>
          </div>
        </div>
        <div class="box-body">
         <div class="box">
            <div class="box-header">
              <h3 class="box-title"></h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
  <!-- #region -->

<br>
  <div class="col-md-12" style="text-align: center;">

<form method="get" class="controls">
  السنة
  <select name="year" class="form-control">
    <?php for($y=date('Y')-2;$y<=date('Y')+1;$y++): ?>
      <option value="<?= $y ?>" <?= $y==$year?'selected':''; ?>><?= $y ?></option>
    <?php endfor; ?>
  </select> <br>
  الأخصائيين (اختياري) <input type="text" name="specialist_ids" value="<?= h($ids_raw) ?>" placeholder="324,173" class="form-control"><br>
  <label style="margin:0 8px;">
    <input type="checkbox" name="fulltime_only" value="1" <?= $fulltime?'checked':''; ?>> دوام كامل فقط
  </label><br><br>
  <button type="submit" class="btn btn-info">تحديث و فلترة</button>
  <button type="submit" name="export" value="1" class="btn btn-success">تصدير ملف إكسل</button>

    <div class="col-md-12" style="text-align:center;margin-top:10px;">
    <div class="box box-primary collapsed-box box-solid">
      <div class="box-header with-border">
        <h3 class="box-title">• الهدف الشهري لكل أخصائي = <b><?= number_format($MONTHLY_TARGET_HOURS,1) ?> ساعة</b> (42.5 ساعة/أسبوع × ~4 أسابيع)<br></h3>
        <div class="box-tools pull-right">
          <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i></button>
        </div>
      </div>
      <div class="box-body" style="text-align:right">
        • الهدف الشهري لكل أخصائي = <b><?= number_format($MONTHLY_TARGET_HOURS,1) ?> ساعة</b> (42.5 ساعة/أسبوع × ~4 أسابيع)<br>
      </div>
    </div>
  </div>

 
</form>

<table class="head-sticky">
  <thead>
    <tr>
      <th>#</th>
      <th>الأخصائي</th>
      <?php foreach($MONTHS as $m=>$lab): ?>
        <th><?= $lab ?><br><span class="small">hrs • KPI%</span></th>
      <?php endforeach; ?>
      <th>Total (hrs)</th>
      <th>Growth</th>
    </tr>
  </thead>
  <tbody>
    <?php if(!$data): ?>
      <tr><td colspan="<?= 3+count($MONTHS) ?>">لا توجد بيانات.</td></tr>
    <?php else: $i=1; foreach($data as $row): ?>
      <tr>
        <td><?= $i++ ?></td>
        <td><?= h($row['name']) ?><?= $row['work']?' <div class="small">'.h($row['work']).'</div>':'' ?></td>
        <?php foreach($MONTHS as $m=>$lab):
              $hrs = $row['months'][$m]['hours'];
              $kpi = $row['months'][$m]['kpi'];
              $cls = ($kpi>=100)?'green':(($kpi>=80)?'orange':'red');
        ?>
          <td>
            <?= number_format($hrs,1) ?>
            <div class="badge <?= $cls ?>"><?= number_format($kpi,0) ?>%</div>
          </td>
        <?php endforeach; ?>
        <td><?= number_format($row['year_hours'],1) ?></td>
        <?php $gcls = ($row['growth']>=0)?'green':'red'; ?>
        <td class="growth <?= $gcls ?>"><?= ($row['growth']>=0?'+':'').number_format($row['growth'],1) ?>%</td>
      </tr>
    <?php endforeach; endif; ?>
  </tbody>
  <tfoot>
    <tr style="font-weight:bold;background:#f3f5fb">
      <td colspan="2">Totals</td>
      <?php foreach($MONTHS as $m=>$lab): ?>
        <td><?= number_format($totals_per_month[$m],1) ?></td>
      <?php endforeach; ?>
      <td></td><td></td>
    </tr>
  </tfoot>
</table>

</body>
</html>
