<?php
function downloadFile($filePath) {
    // Check if file exists
    if (file_exists($filePath)) {
        // Get the file's basename (e.g., "file.txt")
        $fileName = basename($filePath);

        // Set headers to initiate a file download
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $fileName . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($filePath));

        // Clear output buffer to avoid any interference
        ob_clean();
        flush();

        // Read the file and send it to the output buffer
        readfile($filePath);
        exit;
    } else {
        // Handle the error if the file doesn't exist
        echo "Error: File not found.";
    }
}

